/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.definition;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.Translation;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ModelExtensionDefinitionWriter {
    private static final String NS_MED_COLON = "p:";

    public InputStream writeAsStream(ModelExtensionDefinition med) throws IllegalStateException {
        FileInputStream inputStream = null;
        try {
            File tempFile = File.createTempFile("MxdTemp", ".mxd");
            FileOutputStream tempOutputStream = new FileOutputStream(tempFile);
            StreamResult streamResult = new StreamResult(tempOutputStream);
            this.transform(med, streamResult);
            inputStream = new FileInputStream(tempFile);
        }
        catch (Exception e) {
            IllegalStateException error = null;
            error = e instanceof IllegalStateException ? (IllegalStateException)e : new IllegalStateException(e);
            throw error;
        }
        return inputStream;
    }

    public String writeAsText(ModelExtensionDefinition med) throws IllegalStateException {
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        this.transform(med, streamResult);
        return stringWriter.getBuffer().toString();
    }

    private void transform(ModelExtensionDefinition med, Result result) throws IllegalStateException {
        CoreArgCheck.isNotNull((Object)med, (String)"med is null");
        CoreArgCheck.isNotNull((Object)result, (String)"result is null");
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation domImpl = documentBuilder.getDOMImplementation();
            Document document = domImpl.createDocument("http://www.jboss.org/teiiddesigner/ext/2012", "modelExtension", null);
            Element modelExtensionElem = document.getDocumentElement();
            this.setModelExtensionElementAttributes(document, modelExtensionElem, med);
            String[] extendedMetaclassNames = med.getExtendedMetaclasses();
            Element[] extendedMetaclassElems = this.createExtendedMetaclassElements(document, modelExtensionElem, extendedMetaclassNames);
            int i = 0;
            while (i < extendedMetaclassNames.length) {
                String metaclassName = extendedMetaclassNames[i];
                Element metaclassElem = extendedMetaclassElems[i];
                Collection<ModelExtensionPropertyDefinition> properties = med.getPropertyDefinitions(metaclassName);
                this.createProperyElements(document, metaclassElem, properties);
                ++i;
            }
            DOMSource domSource = new DOMSource(document);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(domSource, result);
        }
        catch (Exception e) {
            IllegalStateException error = null;
            error = e instanceof IllegalStateException ? (IllegalStateException)e : new IllegalStateException(e);
            throw error;
        }
    }

    private void setModelExtensionElementAttributes(Document document, Element modelExtensionElem, ModelExtensionDefinition med) {
        modelExtensionElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        modelExtensionElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:p", "http://www.jboss.org/teiiddesigner/ext/2012");
        Attr attr = document.createAttribute("xsi:schemaLocation");
        attr.setValue("http://www.jboss.org/teiiddesigner/ext/2012 http://www.jboss.org/teiiddesigner/ext/2012/modelExtension.xsd");
        modelExtensionElem.setAttributeNode(attr);
        if (!CoreStringUtil.isEmpty((String)med.getMetamodelUri())) {
            attr = document.createAttribute("metamodelUri");
            attr.setValue(med.getMetamodelUri());
            modelExtensionElem.setAttributeNode(attr);
        }
        if (!CoreStringUtil.isEmpty((String)med.getNamespaceUri())) {
            attr = document.createAttribute("namespaceUri");
            attr.setValue(med.getNamespaceUri());
            modelExtensionElem.setAttributeNode(attr);
        }
        if (!CoreStringUtil.isEmpty((String)med.getNamespacePrefix())) {
            attr = document.createAttribute("namespacePrefix");
            attr.setValue(med.getNamespacePrefix());
            modelExtensionElem.setAttributeNode(attr);
        }
        attr = document.createAttribute("version");
        attr.setValue(String.valueOf(med.getVersion()));
        modelExtensionElem.setAttributeNode(attr);
        String medDescription = med.getDescription();
        if (medDescription != null && !medDescription.isEmpty()) {
            Element descriptionElem = document.createElement("p:description");
            modelExtensionElem.appendChild(descriptionElem);
            Text descriptionText = document.createTextNode(med.getDescription());
            descriptionElem.appendChild(descriptionText);
        }
        for (String modelType : med.getSupportedModelTypes()) {
            Element modelTypeElem = document.createElement("p:modelType");
            modelExtensionElem.appendChild(modelTypeElem);
            Text modelTypeText = document.createTextNode(modelType);
            modelTypeElem.appendChild(modelTypeText);
        }
    }

    private Element[] createExtendedMetaclassElements(Document document, Element rootElem, String[] extendedMetaclassNames) {
        Element[] extendedMetaclassElems = new Element[extendedMetaclassNames.length];
        Attr attr = document.createAttribute("xsi:schemaLocation");
        int i = 0;
        while (i < extendedMetaclassNames.length) {
            String extendedMetaclassName = extendedMetaclassNames[i];
            Element extendedMetaclassElem = document.createElement("p:extendedMetaclass");
            rootElem.appendChild(extendedMetaclassElem);
            attr = document.createAttribute("name");
            attr.setValue(extendedMetaclassName);
            extendedMetaclassElem.setAttributeNode(attr);
            extendedMetaclassElems[i] = extendedMetaclassElem;
            ++i;
        }
        return extendedMetaclassElems;
    }

    private void createProperyElements(Document document, Element metaclassElem, Collection<ModelExtensionPropertyDefinition> properties) {
        for (ModelExtensionPropertyDefinition propDefn : properties) {
            Attr attr = document.createAttribute("xsi:schemaLocation");
            Element propertyElem = document.createElement("p:property");
            metaclassElem.appendChild(propertyElem);
            if (!CoreStringUtil.isEmpty((String)propDefn.getSimpleId())) {
                attr = document.createAttribute("name");
                attr.setValue(propDefn.getSimpleId());
                propertyElem.setAttributeNode(attr);
            }
            if (!CoreStringUtil.isEmpty((String)propDefn.getRuntimeType())) {
                attr = document.createAttribute("type");
                attr.setValue(propDefn.getRuntimeType());
                propertyElem.setAttributeNode(attr);
            }
            if (!CoreStringUtil.isEmpty((String)propDefn.getDefaultValue())) {
                attr = document.createAttribute("defaultValue");
                attr.setValue(propDefn.getDefaultValue());
                propertyElem.setAttributeNode(attr);
            }
            if (!CoreStringUtil.isEmpty((String)propDefn.getFixedValue())) {
                attr = document.createAttribute("fixedValue");
                attr.setValue(propDefn.getFixedValue());
                propertyElem.setAttributeNode(attr);
            }
            boolean isRequired = propDefn.isRequired();
            attr = document.createAttribute("required");
            attr.setValue(Boolean.toString(isRequired));
            propertyElem.setAttributeNode(attr);
            boolean isAdvanced = propDefn.isAdvanced();
            attr = document.createAttribute("advanced");
            attr.setValue(Boolean.toString(isAdvanced));
            propertyElem.setAttributeNode(attr);
            boolean isMasked = propDefn.isMasked();
            attr = document.createAttribute("masked");
            attr.setValue(Boolean.toString(isMasked));
            propertyElem.setAttributeNode(attr);
            boolean isIndexed = propDefn.shouldBeIndexed();
            attr = document.createAttribute("index");
            attr.setValue(Boolean.toString(isIndexed));
            propertyElem.setAttributeNode(attr);
            Set<Translation> descriptions = propDefn.getDescriptions();
            for (Translation descriptionTranslation : descriptions) {
                String descriptionLocale = descriptionTranslation.getLocale().toString();
                String descriptionName = descriptionTranslation.getTranslation();
                if (descriptionLocale == null) continue;
                Element descrElement = document.createElement("p:description");
                Text descriptionText = document.createTextNode(descriptionName);
                descrElement.appendChild(descriptionText);
                attr = document.createAttribute("locale");
                attr.setValue(descriptionLocale);
                descrElement.setAttributeNode(attr);
                propertyElem.appendChild(descrElement);
            }
            Set<Translation> displayNames = propDefn.getDisplayNames();
            for (Translation displayTranslation : displayNames) {
                String dnLocale = displayTranslation.getLocale().toString();
                String dnName = displayTranslation.getTranslation();
                if (dnLocale == null) continue;
                Element displayElement = document.createElement("p:display");
                Text displayText = document.createTextNode(dnName);
                displayElement.appendChild(displayText);
                attr = document.createAttribute("locale");
                attr.setValue(dnLocale);
                displayElement.setAttributeNode(attr);
                propertyElem.appendChild(displayElement);
            }
            String[] allowedValues = propDefn.getAllowedValues();
            int i = 0;
            while (i < allowedValues.length) {
                String allowedValueStr = allowedValues[i];
                Element allowedValueElement = document.createElement("p:allowedValue");
                Text elemText = document.createTextNode(allowedValueStr);
                allowedValueElement.appendChild(elemText);
                propertyElem.appendChild(allowedValueElement);
                ++i;
            }
        }
    }
}

