/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.properties;

import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.Messages;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.extension.properties.Translation;

public interface ModelExtensionPropertyDefinition
extends Cloneable,
PropertyDefinition {
    public static final String[] BOOLEAN_ALLOWED_VALUES = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
    public static final char ID_DELIM = ':';
    public static final char URI_START_DELIM = '{';
    public static final char URI_END_DELIM = '}';
    public static final boolean ADVANCED_DEFAULT = false;
    public static final boolean INDEX_DEFAULT = true;
    public static final boolean MASKED_DEFAULT = false;
    public static final boolean REQUIRED_DEFAULT = false;
    public static final Type TYPE_DEFAULT = Type.STRING;

    public boolean addAllowedValue(String var1);

    public boolean addDescription(Translation var1);

    public boolean addDisplayName(Translation var1);

    public boolean addListener(PropertyChangeListener var1);

    public Set<String> allowedValues();

    public Object clone();

    public Set<Translation> getDescriptions();

    public Set<Translation> getDisplayNames();

    public String getFixedValue();

    public NamespaceProvider getNamespaceProvider();

    public String getRuntimeType();

    public String getSimpleId();

    public Type getType();

    public boolean removeAllowedValue(String var1);

    public boolean removeDescription(Translation var1);

    public boolean removeDisplayName(Translation var1);

    public boolean removeListener(PropertyChangeListener var1);

    public void setAdvanced(boolean var1);

    public void setAllowedValues(Set<String> var1);

    public void setDefaultValue(String var1);

    public void setDescriptions(Set<Translation> var1);

    public void setDisplayNames(Set<Translation> var1);

    public void setFixedValue(String var1);

    public void setIndex(boolean var1);

    public void setMasked(boolean var1);

    public void setNamespaceProvider(NamespaceProvider var1);

    public void setRequired(boolean var1);

    public void setSimpleId(String var1);

    public void setType(Type var1);

    public boolean shouldBeIndexed();

    public static enum PropertyName {
        ADVANCED,
        ALLOWED_VALUES,
        DEFAULT_VALUE,
        DESCRIPTION,
        DISPLAY_NAME,
        FIXED_VALUE,
        INDEX,
        MASKED,
        NAMESPACE_PREFIX,
        REQUIRED,
        SIMPLE_ID,
        TYPE;

    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type BIG_DECIMAL = new Type("bigdecimal");
        public static final /* enum */ Type BIG_INTEGER = new Type("biginteger");
        public static final /* enum */ Type BLOB = new Type("blob");
        public static final /* enum */ Type BOOLEAN = new Type("boolean");
        public static final /* enum */ Type BYTE = new Type("byte");
        public static final /* enum */ Type CHAR = new Type("char");
        public static final /* enum */ Type CLOB = new Type("clob");
        public static final /* enum */ Type DATE = new Type("date");
        public static final /* enum */ Type DOUBLE = new Type("double");
        public static final /* enum */ Type FLOAT = new Type("float");
        public static final /* enum */ Type INTEGER = new Type("integer");
        public static final /* enum */ Type LONG = new Type("long");
        public static final /* enum */ Type OBJECT = new Type("object");
        public static final /* enum */ Type SHORT = new Type("short");
        public static final /* enum */ Type STRING = new Type("string");
        public static final /* enum */ Type TIME = new Type("time");
        public static final /* enum */ Type TIMESTAMP = new Type("timestamp");
        public static final /* enum */ Type XML = new Type("xml");
        private static char[] _firstChars;
        private final String runtimeType;
        private static final /* synthetic */ Type[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Type[]{BIG_DECIMAL, BIG_INTEGER, BLOB, BOOLEAN, BYTE, CHAR, CLOB, DATE, DOUBLE, FLOAT, INTEGER, LONG, OBJECT, SHORT, STRING, TIME, TIMESTAMP, XML};
        }

        public static char[] getFirstChars() {
            if (_firstChars == null) {
                HashSet<Character> temp = new HashSet<Character>();
                String chars = "";
                Type[] typeArray = Type.values();
                int n = typeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type type = typeArray[n2];
                    char c = type.getRuntimeType().charAt(0);
                    if (temp.add(Character.valueOf(c))) {
                        chars = String.valueOf(chars) + c;
                    }
                    ++n2;
                }
                _firstChars = chars.toCharArray();
            }
            return _firstChars;
        }

        private Type(String type) {
            assert (type != null) : "runtime type is null";
            this.runtimeType = type;
        }

        public String getRuntimeType() {
            return this.runtimeType;
        }

        public String toString() {
            return this.getRuntimeType();
        }

        public static Type[] values() {
            Type[] typeArray = ENUM$VALUES;
            int n = typeArray.length;
            Type[] typeArray2 = new Type[n];
            System.arraycopy(ENUM$VALUES, 0, typeArray2, 0, n);
            return typeArray2;
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }

    public static class Utils {
        public static Type convertRuntimeType(String runtimeType) {
            CoreArgCheck.isNotEmpty((String)runtimeType, (String)"runtimeType is empty");
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                if (type.getRuntimeType().equals(runtimeType)) {
                    return type;
                }
                ++n2;
            }
            throw new IllegalArgumentException(NLS.bind((String)Messages.invalidRuntimeType, (Object)runtimeType));
        }

        public static String getIndexedId(NamespaceProvider namespaceProvider, String simpleId) {
            if (namespaceProvider == null || CoreStringUtil.isEmpty((String)simpleId)) {
                return null;
            }
            return String.valueOf('{') + namespaceProvider.getNamespaceUri() + '}' + simpleId;
        }

        private static String getNamespacePrefix(String propId) {
            if (CoreStringUtil.isEmpty((String)propId)) {
                return null;
            }
            int index = propId.indexOf(58);
            if (index != -1) {
                if (index == 0 || propId.length() == index + 1) {
                    return null;
                }
                return propId.substring(0, index);
            }
            return null;
        }

        public static String getPropertyId(NamespaceProvider namespaceProvider, String propertySimpleId) {
            if (namespaceProvider == null || CoreStringUtil.isEmpty((String)propertySimpleId)) {
                return null;
            }
            return String.valueOf(namespaceProvider.getNamespacePrefix()) + ':' + propertySimpleId;
        }

        public static boolean isExtensionPropertyId(String propId, NamespaceProvider namespaceProvider) {
            CoreArgCheck.isNotEmpty((String)propId, (String)"propId is empty");
            CoreArgCheck.isNotNull((Object)namespaceProvider, (String)"namespaceProvider is null");
            String nsPrefix = namespaceProvider.getNamespacePrefix();
            if (CoreStringUtil.isEmpty((String)nsPrefix)) {
                return false;
            }
            String propNsPrefix = Utils.getNamespacePrefix(propId);
            if (CoreStringUtil.isEmpty((String)propNsPrefix)) {
                return false;
            }
            return propNsPrefix.equals(nsPrefix);
        }

        public static String isValidValue(String valueTypeMsg, Type runtimeType, String proposedValue, boolean required, String[] allowedValues) {
            if (runtimeType == null) {
                return Messages.missingRuntimeTypeValidationMsg;
            }
            if (CoreStringUtil.isEmpty((String)proposedValue) && required) {
                return NLS.bind((String)Messages.emptyPropertyValue, (Object)valueTypeMsg);
            }
            if (allowedValues != null && allowedValues.length != 0) {
                String[] stringArray = allowedValues;
                int n = allowedValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String allowedValue = stringArray[n2];
                    if (allowedValue.equals(proposedValue)) {
                        return null;
                    }
                    ++n2;
                }
                return Messages.valueDoesNotMatchAnAllowedValue;
            }
            if (Type.STRING == runtimeType || Type.BLOB == runtimeType || Type.CLOB == runtimeType || Type.OBJECT == runtimeType || Type.XML == runtimeType) {
                return null;
            }
            if (Type.BOOLEAN == runtimeType) {
                if (!proposedValue.equalsIgnoreCase(Boolean.TRUE.toString()) && !proposedValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else if (Type.CHAR == runtimeType) {
                if (proposedValue.length() != 1) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else if (Type.BYTE == runtimeType) {
                try {
                    Byte.parseByte(proposedValue);
                }
                catch (Exception exception) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else if (Type.SHORT == runtimeType) {
                try {
                    Short.parseShort(proposedValue);
                }
                catch (Exception exception) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else if (Type.INTEGER == runtimeType) {
                try {
                    Integer.parseInt(proposedValue);
                }
                catch (Exception exception) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else if (Type.LONG == runtimeType) {
                try {
                    Long.parseLong(proposedValue);
                }
                catch (Exception exception) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else if (Type.FLOAT == runtimeType) {
                try {
                    Float.parseFloat(proposedValue);
                }
                catch (Exception exception) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else if (Type.DOUBLE == runtimeType) {
                try {
                    Double.parseDouble(proposedValue);
                }
                catch (Exception exception) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else if (Type.BIG_INTEGER == runtimeType) {
                try {
                    new BigInteger(proposedValue);
                }
                catch (Exception exception) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else if (Type.BIG_DECIMAL == runtimeType) {
                try {
                    new BigDecimal(proposedValue);
                }
                catch (Exception exception) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else if (Type.DATE == runtimeType) {
                try {
                    Date.valueOf(proposedValue);
                }
                catch (Exception exception) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else if (Type.TIME == runtimeType) {
                try {
                    Time.valueOf(proposedValue);
                }
                catch (Exception exception) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else if (Type.TIMESTAMP == runtimeType) {
                try {
                    Timestamp.valueOf(proposedValue);
                }
                catch (Exception exception) {
                    return NLS.bind((String)Messages.invalidPropertyValueForType, (Object)proposedValue, (Object)((Object)runtimeType));
                }
            } else {
                return NLS.bind((String)Messages.unknownPropertyType, (Object)((Object)runtimeType));
            }
            return null;
        }
    }
}

