/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.registry;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.extension.ExtensionConstants;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.Messages;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionWriter;

public final class ExtensionDefinitionsManager
implements ExtensionConstants {
    private final String medsDirPath;
    private final FilenameFilter mxdFilter;

    public ExtensionDefinitionsManager(String directoryPath) {
        this.medsDirPath = directoryPath;
        this.mxdFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".mxd");
            }
        };
    }

    private String getDefinitionDirectory(ExtensionConstants.MxdType mxdType) {
        File directory;
        StringBuilder pathBuilder = new StringBuilder(this.medsDirPath);
        if (ExtensionConstants.MxdType.IMPORTED.equals((Object)mxdType)) {
            pathBuilder.append(File.separator).append("imported");
        }
        if (!(directory = new File(pathBuilder.toString())).exists()) {
            directory.mkdirs();
        }
        return pathBuilder.toString();
    }

    public Collection<File> retrieveDefinitionFiles(ExtensionConstants.MxdType mxdType) {
        ArrayList<File> defnFiles = new ArrayList<File>();
        if (this.medsDirPath == null) {
            return Collections.emptyList();
        }
        String mxdDirPath = this.getDefinitionDirectory(mxdType);
        File dir = new File(mxdDirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return Collections.emptyList();
        }
        File[] files = dir.listFiles(this.mxdFilter);
        int i = 0;
        while (i < files.length) {
            File mxdFile = files[i];
            if (!(mxdFile.isFile() && mxdFile.exists() && mxdFile.canRead())) {
                ExtensionPlugin.Util.log(4, NLS.bind((String)Messages.errorUserDefinitionNotFoundOrNotReadable, (Object)mxdFile.getAbsolutePath()));
            } else {
                defnFiles.add(mxdFile);
            }
            ++i;
        }
        return defnFiles;
    }

    private void writeFile(InputStream inputStream, File outFile) throws IOException {
        int len;
        FileOutputStream out = new FileOutputStream(outFile);
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        inputStream.close();
    }

    private void deleteExistingMed(String medFilePath) {
        File medFile = new File(medFilePath);
        if (!medFile.exists()) {
            return;
        }
        medFile.setWritable(true);
        if (!medFile.isFile() || !medFile.canWrite()) {
            ExtensionPlugin.Util.log(4, NLS.bind((String)Messages.errorUserDefinitionDeleteNotFoundOrCantWrite, (Object)medFile.getAbsolutePath()));
            return;
        }
        medFile.delete();
    }

    public File saveDefinition(ModelExtensionDefinitionWriter medWriter, ModelExtensionDefinition med) {
        ExtensionConstants.MxdType mxdType = ExtensionConstants.MxdType.USER;
        if (med.isImported()) {
            mxdType = ExtensionConstants.MxdType.IMPORTED;
        }
        String mxdDirPath = this.getDefinitionDirectory(mxdType);
        String namespacePrefix = med.getNamespacePrefix();
        int version = med.getVersion();
        String fName = String.valueOf(namespacePrefix) + version + ".mxd";
        File file = new File(String.valueOf(mxdDirPath) + File.separator + fName);
        this.deleteExistingMed(file.getAbsolutePath());
        InputStream stream = medWriter.writeAsStream(med);
        try {
            this.writeFile(stream, file);
        }
        catch (IOException iOException) {
            ExtensionPlugin.Util.log(4, NLS.bind((String)Messages.errorUserDefinitionNotSaved, (Object)file.getAbsolutePath()));
            return null;
        }
        return file;
    }

    public void saveDefinitions(Collection<ModelExtensionDefinition> mxdDefns) {
        ModelExtensionDefinitionWriter medWriter = new ModelExtensionDefinitionWriter();
        for (ModelExtensionDefinition med : mxdDefns) {
            this.saveDefinition(medWriter, med);
        }
    }
}

