/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.registry;

import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;

public class RegistryEvent {
    private final ModelExtensionDefinition definition;
    private final Type type;

    public static RegistryEvent createAddDefinitionEvent(ModelExtensionDefinition definition) {
        CoreArgCheck.isNotNull((Object)definition, (String)"definition is null");
        return new RegistryEvent(Type.ADD, definition);
    }

    public static RegistryEvent createChangeDefinitionEvent(ModelExtensionDefinition definition) {
        CoreArgCheck.isNotNull((Object)definition, (String)"definition is null");
        return new RegistryEvent(Type.CHANGE, definition);
    }

    public static RegistryEvent createRemoveDefinitionEvent(ModelExtensionDefinition definition) {
        CoreArgCheck.isNotNull((Object)definition, (String)"definition is null");
        return new RegistryEvent(Type.REMOVE, definition);
    }

    private RegistryEvent(Type type, ModelExtensionDefinition definition) {
        assert (type != null) : "Type should not be null";
        CoreArgCheck.isNotNull((Object)definition, (String)"definition is null");
        this.type = type;
        this.definition = definition;
    }

    public ModelExtensionDefinition getDefinition() {
        return this.definition;
    }

    public boolean isAdd() {
        return Type.ADD == this.type;
    }

    public boolean isChange() {
        return Type.CHANGE == this.type;
    }

    public boolean isRemove() {
        return Type.REMOVE == this.type;
    }

    private static enum Type {
        ADD,
        CHANGE,
        REMOVE;

    }
}

