/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest;

import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.modeshape.common.util.CheckArg;

public final class ServerRegistryEvent {
    private final ModeShapeServer server;
    private final ServerManager serverManager;
    private final Type type;
    private ModeShapeServer updatedServer;

    public static ServerRegistryEvent createNewEvent(ServerManager serverManager, ModeShapeServer newServer) {
        CheckArg.isNotNull((Object)serverManager, (String)"serverManager");
        CheckArg.isNotNull((Object)newServer, (String)"newServer");
        return new ServerRegistryEvent(serverManager, Type.NEW, newServer);
    }

    public static ServerRegistryEvent createRemoveEvent(ServerManager serverManager, ModeShapeServer removedServer) {
        CheckArg.isNotNull((Object)serverManager, (String)"serverManager");
        CheckArg.isNotNull((Object)removedServer, (String)"removedServer");
        return new ServerRegistryEvent(serverManager, Type.REMOVE, removedServer);
    }

    public static ServerRegistryEvent createUpdateEvent(ServerManager serverManager, ModeShapeServer previousServerVersion, ModeShapeServer newServerVersion) {
        CheckArg.isNotNull((Object)serverManager, (String)"serverManager");
        CheckArg.isNotNull((Object)previousServerVersion, (String)"previousServerVersion");
        CheckArg.isNotNull((Object)newServerVersion, (String)"newServerVersion");
        ServerRegistryEvent event = new ServerRegistryEvent(serverManager, Type.UPDATE, previousServerVersion);
        event.updatedServer = newServerVersion;
        return event;
    }

    private ServerRegistryEvent(ServerManager serverManager, Type type, ModeShapeServer server) {
        assert (serverManager != null);
        assert (type != null);
        assert (server != null);
        this.serverManager = serverManager;
        this.type = type;
        this.server = server;
    }

    public ModeShapeServer getServer() {
        return this.server;
    }

    public ServerManager getServerManager() {
        return this.serverManager;
    }

    public ModeShapeServer getUpdatedServer() {
        if (this.type != Type.UPDATE) {
            throw new UnsupportedOperationException();
        }
        return this.updatedServer;
    }

    public boolean isNew() {
        return this.type == Type.NEW;
    }

    public boolean isRemove() {
        return this.type == Type.REMOVE;
    }

    public boolean isUpdate() {
        return this.type == Type.UPDATE;
    }

    private static enum Type {
        NEW,
        REMOVE,
        UPDATE;

    }
}

