/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.dialogs.AddPublishAreaDialog;
import org.jboss.tools.modeshape.rest.domain.ModeShapeWorkspace;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.rest.client.Status;

public final class AddPublishAreaAction
extends BaseSelectionListenerAction {
    private boolean success;
    private final ServerManager serverManager;
    private ModeShapeWorkspace workspace;
    private final Shell shell;
    private final boolean updateOnSelection;
    private final TreeViewer viewer;

    private AddPublishAreaAction(Shell shell, ServerManager serverManager, TreeViewer viewer, boolean updateOnSelection) {
        super(RestClientI18n.addPublishAreaActionText);
        CheckArg.isNotNull((Object)serverManager, (String)"serverManager");
        this.setToolTipText(RestClientI18n.addPublishAreaActionToolTip);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/views/new_publish_area.png"));
        this.setEnabled(false);
        this.shell = shell;
        this.serverManager = serverManager;
        this.viewer = viewer;
        this.updateOnSelection = updateOnSelection;
    }

    public AddPublishAreaAction(Shell shell, ServerManager serverManager, TreeViewer viewer) {
        this(shell, serverManager, viewer, true);
    }

    public AddPublishAreaAction(Shell shell, ServerManager serverManager, ModeShapeWorkspace workspace, TreeViewer viewer) {
        this(shell, serverManager, viewer, false);
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        this.setEnabled(true);
        this.workspace = workspace;
    }

    public boolean success() {
        return this.success;
    }

    public void run() {
        this.success = false;
        AddPublishAreaDialog dialog = new AddPublishAreaDialog(this.shell, this.workspace);
        if (dialog.open() == 0) {
            boolean errorOccurred = false;
            String publishArea = dialog.publishArea();
            if (publishArea.charAt(0) != '/') {
                publishArea = String.valueOf('/') + publishArea;
            }
            try {
                Status status = this.serverManager.markAsPublishArea(this.workspace, publishArea);
                if (status.isOk()) {
                    if (this.viewer != null) {
                        final TreeViewer finalViewer = this.viewer;
                        final ModeShapeWorkspace finalWorkspace = this.workspace;
                        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                finalViewer.refresh((Object)finalWorkspace);
                            }
                        });
                    }
                } else {
                    Activator.getDefault().log(status);
                    if (status.isError()) {
                        errorOccurred = true;
                    }
                }
            }
            catch (Exception e) {
                Activator.getDefault().log(new Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.errorMarkingPublishArea, (Object)this.workspace.getName(), (Object)publishArea), (Throwable)e));
                errorOccurred = true;
            }
            if (errorOccurred) {
                MessageDialog.openError((Shell)this.shell, (String)RestClientI18n.errorDialogTitle, (String)RestClientI18n.addPublishAreaDialogErrorsOccurredMsg);
            } else {
                this.success = true;
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (this.updateOnSelection) {
            this.workspace = null;
            if (selection.isEmpty() || selection.size() > 1) {
                return false;
            }
            Object obj = selection.getFirstElement();
            if (obj instanceof ModeShapeWorkspace) {
                this.workspace = (ModeShapeWorkspace)obj;
                return true;
            }
            return false;
        }
        return this.isEnabled();
    }
}

