/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.actions;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.jboss.tools.modeshape.rest.jobs.ReconnectJob;

public final class ReconnectToServerAction
extends BaseSelectionListenerAction {
    private final TreeViewer viewer;

    public ReconnectToServerAction(TreeViewer viewer) {
        super(RestClientI18n.serverReconnectActionText);
        this.setToolTipText(RestClientI18n.serverReconnectActionToolTip);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/views/refresh.gif"));
        this.setEnabled(false);
        this.viewer = viewer;
    }

    StructuredViewer getViewer() {
        return this.viewer;
    }

    void refresh(final ModeShapeServer server) {
        Display display = this.viewer.getControl().getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReconnectToServerAction.this.getViewer().refresh((Object)server);
                }
            });
        }
    }

    public void run() {
        final ModeShapeServer server = (ModeShapeServer)this.getStructuredSelection().getFirstElement();
        final ReconnectJob job = new ReconnectJob(server);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ReconnectToServerAction.this.refresh(server);
                job.removeJobChangeListener((IJobChangeListener)this);
            }
        });
        Thread t = new Thread();
        t.run();
        job.setThread(t);
        job.schedule();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return selection.size() == 1 && selection.getFirstElement() instanceof ModeShapeServer;
    }
}

