/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.log;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.osgi.framework.Bundle;

public final class EclipseLogger
extends Logger {
    private static boolean initialized = false;
    private static boolean DEBUG_MODE = Platform.isRunning();
    private static ILog LOGGER;
    private final String name;

    public EclipseLogger(String name) {
        this.name = name;
        if (!initialized) {
            initialized = true;
            if (Platform.isRunning()) {
                DEBUG_MODE = Platform.inDebugMode() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.jboss.tools.modeshape.rest/debug"));
                LOGGER = Platform.getLog((Bundle)Platform.getBundle((String)"org.jboss.tools.modeshape.rest"));
            }
        }
    }

    public void debug(String message, Object ... params) {
        this.debug(null, message, params);
    }

    public void debug(Throwable t, String message, Object ... params) {
        if (this.isDebugEnabled()) {
            LOGGER.log((IStatus)new Status(1, "org.jboss.tools.modeshape.rest", message, t));
        }
    }

    public void error(I18nResource message, Object ... params) {
        this.error((Throwable)null, message, params);
    }

    public void error(Throwable t, I18nResource message, Object ... params) {
        if (this.isErrorEnabled() && LOGGER != null) {
            LOGGER.log((IStatus)new Status(4, "org.jboss.tools.modeshape.rest", message.text(params), t));
        }
    }

    public String getName() {
        return this.name;
    }

    public void info(I18nResource message, Object ... params) {
        this.info((Throwable)null, message, params);
    }

    public void info(Throwable t, I18nResource message, Object ... params) {
        if (this.isInfoEnabled() && LOGGER != null) {
            LOGGER.log((IStatus)new Status(1, "org.jboss.tools.modeshape.rest", message.text(params), t));
        }
    }

    public boolean isDebugEnabled() {
        return DEBUG_MODE;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return this.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void trace(String message, Object ... params) {
        this.trace(null, message, params);
    }

    public void trace(Throwable t, String message, Object ... params) {
        if (this.isTraceEnabled()) {
            this.debug(message, t);
        }
    }

    public void warn(I18nResource message, Object ... params) {
        this.warn((Throwable)null, message, params);
    }

    public void warn(Throwable t, I18nResource message, Object ... params) {
        if (this.isWarnEnabled() && LOGGER != null) {
            LOGGER.log((IStatus)new Status(2, "org.jboss.tools.modeshape.rest", message.text(params), t));
        }
    }
}

