/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.preferences;

import java.util.Collection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.preferences.IgnoredResourcesModel;
import org.jboss.tools.modeshape.rest.preferences.ResourcePattern;

public final class IgnoredResourcesEditor
extends FieldEditor {
    private Button btnAdd;
    private Button btnRemove;
    private IgnoredResourcesModel model;
    private TableViewer viewer;

    public IgnoredResourcesEditor(Composite parent) {
        super("modeShape.preference.ignoredResources", RestClientI18n.ignoredResourcesPreferencePageLabel, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.viewer.getControl().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return button;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.viewer = new TableViewer(parent, 68384);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return IgnoredResourcesEditor.this.getPatterns().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ResourcePattern pattern1 = (ResourcePattern)e1;
                ResourcePattern pattern2 = (ResourcePattern)e2;
                return pattern1.getPattern().compareTo(pattern2.getPattern());
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ResourcePattern)element).getPattern();
            }
        });
        Table table = this.viewer.getTable();
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    IgnoredResourcesEditor.this.handlePatternChecked((TableItem)event.item);
                } else {
                    IgnoredResourcesEditor.this.handlePatternSelected();
                }
            }
        });
        Composite pnlButtons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        pnlButtons.setLayout((Layout)layout);
        pnlButtons.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.btnAdd = this.createPushButton(pnlButtons, "ListEditor.add");
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IgnoredResourcesEditor.this.handleAddPressed();
            }
        });
        this.btnRemove = this.createPushButton(pnlButtons, "ListEditor.remove");
        this.btnRemove.setEnabled(false);
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IgnoredResourcesEditor.this.handleRemovePressed();
            }
        });
        this.model = new IgnoredResourcesModel();
        this.viewer.setInput((Object)this);
    }

    protected void doLoad() {
        String prefValue = this.getPreferenceStore().getString(this.getPreferenceName());
        this.model.load(prefValue);
        this.refreshUi();
    }

    protected void doLoadDefault() {
        String prefValue = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.model.load(prefValue);
        this.refreshUi();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.model.createList());
    }

    public int getNumberOfControls() {
        return 2;
    }

    Collection<ResourcePattern> getPatterns() {
        return this.model.getPatterns();
    }

    void handleAddPressed() {
        NewPatternDialog dialog = new NewPatternDialog(this.btnAdd.getShell(), this.getPatterns());
        if (dialog.open() == 0) {
            this.model.addPattern(new ResourcePattern(dialog.getNewPattern(), true));
            this.refreshUi();
        }
    }

    void handlePatternChecked(TableItem item) {
        ResourcePattern pattern = (ResourcePattern)item.getData();
        pattern.setEnabled(item.getChecked());
    }

    void handlePatternSelected() {
        boolean enable;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        boolean bl = enable = !selection.isEmpty();
        if (this.btnRemove.getEnabled() != enable) {
            this.btnRemove.setEnabled(enable);
        }
    }

    void handleRemovePressed() {
        assert (!this.viewer.getSelection().isEmpty());
        Object pattern = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        this.model.removePattern((ResourcePattern)pattern);
        this.refreshUi();
    }

    private void initializeCheckBoxStates() {
        TableItem[] tableItemArray = this.viewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            ResourcePattern pattern = (ResourcePattern)item.getData();
            if (pattern.isEnabled()) {
                item.setChecked(true);
            }
            ++n2;
        }
    }

    private void refreshUi() {
        this.viewer.refresh();
        this.initializeCheckBoxStates();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class NewPatternDialog
    extends Dialog
    implements ModifyListener {
        private final Collection<ResourcePattern> existingPatterns;
        private CLabel lblMessage;
        private String newPattern;

        public NewPatternDialog(Shell parentShell, Collection<ResourcePattern> existingPatterns) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.existingPatterns = existingPatterns;
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(RestClientI18n.newIgnoredResourceDialogTitle);
            super.configureShell(newShell);
        }

        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            Button button = super.createButton(parent, id, label, defaultButton);
            if (id == 0) {
                button.setEnabled(false);
            }
            return button;
        }

        protected Control createDialogArea(Composite parent) {
            Composite panel = (Composite)super.createDialogArea(parent);
            Composite pnlEditor = new Composite(panel, 0);
            pnlEditor.setLayout((Layout)new GridLayout());
            pnlEditor.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(pnlEditor, 0);
            label.setLayoutData((Object)new GridData(16384, 0, false, false));
            label.setText(RestClientI18n.newIgnoredResourceDialogLabel);
            Text textField = new Text(pnlEditor, 2048);
            textField.setLayoutData((Object)new GridData(4, 0, true, false));
            textField.addModifyListener((ModifyListener)this);
            textField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (e.text.contains("\\") || e.text.contains("/")) {
                        e.doit = false;
                    }
                }
            });
            this.lblMessage = new CLabel(pnlEditor, 0);
            this.lblMessage.setLayoutData((Object)new GridData(4, 0, true, false));
            ((GridData)this.lblMessage.getLayoutData()).horizontalSpan = 2;
            return panel;
        }

        public String getNewPattern() {
            if (this.getReturnCode() == 0) {
                return this.newPattern;
            }
            return null;
        }

        protected void initializeBounds() {
            super.initializeBounds();
            int width = 4 * this.convertWidthInCharsToPixels(RestClientI18n.newIgnoredResourceDialogTitle.length());
            Rectangle rectangle = this.getShell().getBounds();
            this.getShell().setBounds(rectangle.x, rectangle.y, width, rectangle.height);
        }

        public void modifyText(ModifyEvent event) {
            boolean enable;
            this.lblMessage.setImage(null);
            this.lblMessage.setText("");
            this.newPattern = ((Text)event.widget).getText();
            boolean bl = enable = this.newPattern.length() != 0;
            if (enable && this.existingPatterns != null) {
                for (ResourcePattern pattern : this.existingPatterns) {
                    if (!this.newPattern.equals(pattern.getPattern())) continue;
                    enable = false;
                    this.lblMessage.setImage(Activator.getDefault().getSharedImage("IMG_OBJS_INFO_TSK"));
                    this.lblMessage.setText(RestClientI18n.newItemDialogValueExists);
                    break;
                }
            }
            if (this.getButton(0).getEnabled() != enable) {
                this.getButton(0).setEnabled(enable);
            }
        }
    }
}

