/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.properties;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.rest.client.Status;

public final class PropertyDisplayNameProvider {
    private static final String CATEGORY_SUFFIX = ".CATEGORY";
    private static final String RESOURCE_BUNDLE = String.valueOf(PropertyDisplayNameProvider.class.getPackage().getName()) + ".PropertyDisplayNames";
    private static ResourceBundle bundle;
    private static boolean loaded;

    static {
        loaded = false;
    }

    public static String getCategory(String propertyId) {
        return PropertyDisplayNameProvider.getDisplayName(String.valueOf(propertyId) + CATEGORY_SUFFIX, false);
    }

    private static String getDisplayName(String propertyId, boolean idIfNotFound) {
        CheckArg.isNotNull((Object)propertyId, (String)"propertyId");
        if (!loaded) {
            PropertyDisplayNameProvider.load();
        }
        String displayName = null;
        if (bundle != null) {
            try {
                displayName = bundle.getString(propertyId);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return idIfNotFound && displayName == null ? propertyId : displayName;
    }

    public static String getDisplayName(String propertyId) {
        return PropertyDisplayNameProvider.getDisplayName(propertyId, true);
    }

    private static void load() {
        try {
            bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
        }
        catch (Exception e) {
            Activator.getDefault().log(new Status(Status.Severity.ERROR, RestClientI18n.propertiesBundleLoadErrorMsg, (Throwable)e));
        }
    }

    private PropertyDisplayNameProvider() {
    }
}

