/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.IServerRegistryListener;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.ServerRegistryEvent;
import org.jboss.tools.modeshape.rest.Utils;
import org.jboss.tools.modeshape.rest.actions.AddPublishAreaAction;
import org.jboss.tools.modeshape.rest.actions.NewServerAction;
import org.jboss.tools.modeshape.rest.domain.ModeShapeRepository;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.jboss.tools.modeshape.rest.domain.ModeShapeWorkspace;
import org.jboss.tools.modeshape.rest.domain.WorkspaceArea;
import org.jboss.tools.modeshape.rest.jobs.PublishJob;
import org.jboss.tools.modeshape.rest.preferences.IgnoredResourcesModel;
import org.jboss.tools.modeshape.rest.preferences.PublishingFileFilter;
import org.jboss.tools.modeshape.rest.wizards.PublishWizard;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.web.jcr.rest.client.Status;

public final class PublishPage
extends WizardPage
implements IServerRegistryListener,
ModifyListener {
    private static final String RECURSE_KEY = "recurse";
    private static boolean filterFiles = true;
    private Button btnNewArea;
    private Combo cbxRepository;
    private Combo cbxServer;
    private Combo cbxWorkspace;
    private Combo cbxWorkspaceAreas;
    private Button chkVersioning;
    private List<IFile> files;
    private PublishingFileFilter filter;
    private boolean includeProjectPath = false;
    private Link linkPrefs;
    private org.eclipse.swt.widgets.List lstResources;
    private boolean recurse = true;
    private List<ModeShapeRepository> repositories;
    private ModeShapeRepository repository;
    private boolean repositorySupportsVersioning;
    private final List<IResource> resources;
    private ModeShapeServer server;
    private List<ModeShapeServer> servers;
    private Status status;
    private final PublishJob.Type type;
    private boolean versioning = true;
    private ModeShapeWorkspace workspace;
    private String workspaceArea;
    private List<ModeShapeWorkspace> workspaces;

    private static List<IFile> findFiles(IContainer container, boolean recurse, PublishingFileFilter filter) throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        if (container instanceof IProject && !((IProject)container).isOpen() || filter != null && !filter.accept((IResource)container)) {
            return result;
        }
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (recurse && member instanceof IContainer) {
                if (!(member instanceof IProject) || ((IProject)member).isOpen()) {
                    result.addAll(PublishPage.findFiles((IContainer)member, recurse, filter));
                }
            } else if (member instanceof IFile && ((IFile)member).getLocation().toFile().exists() && (filter == null || filter.accept(member))) {
                result.add((IFile)member);
            }
            ++n2;
        }
        return result;
    }

    private static List<IFile> processResources(List<IResource> resources, boolean recurse, PublishingFileFilter filter) throws CoreException {
        Map parentMap;
        assert (resources != null);
        ArrayList<IFile> result = new ArrayList<IFile>();
        HashMap projectMap = new HashMap();
        for (IResource resource : resources) {
            IProject iProject;
            IFile file = null;
            Object var8_9 = null;
            ArrayList<IFile> files = null;
            HashMap<Object, ArrayList<IFile>> parentMap2 = null;
            if (filter != null && !filter.accept(resource)) continue;
            if (resource instanceof IFile) {
                IContainer parent = null;
                file = (IFile)resource;
                parent = file.getParent();
                IProject iProject2 = file.getProject();
                if (!projectMap.containsKey(iProject2)) {
                    projectMap.put(iProject2, null);
                }
                if ((parentMap2 = (Map)projectMap.get(iProject2)) == null) {
                    parentMap2 = new HashMap();
                    projectMap.put(iProject2, parentMap2);
                }
                if ((files = (ArrayList<IFile>)parentMap2.get(parent)) == null) {
                    files = new ArrayList<IFile>();
                    parentMap2.put(parent, files);
                }
                files.add(file);
                continue;
            }
            if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                IProject iProject3 = folder.getProject();
                if (!projectMap.containsKey(iProject3)) {
                    projectMap.put(iProject3, null);
                }
                if ((parentMap2 = (HashMap<Object, ArrayList<IFile>>)projectMap.get(iProject3)) == null) {
                    parentMap2 = new HashMap<Object, ArrayList<IFile>>();
                    projectMap.put(iProject3, parentMap2);
                }
                if (parentMap2.containsKey(folder)) continue;
                parentMap2.put(folder, null);
                continue;
            }
            if (!(resource instanceof IProject) || projectMap.containsKey(iProject = (IProject)resource)) continue;
            projectMap.put(iProject, null);
        }
        for (IProject project : projectMap.keySet()) {
            parentMap = (Map)projectMap.get(project);
            if (parentMap == null) {
                result.addAll(PublishPage.findFiles((IContainer)project, recurse, filter));
                continue;
            }
            for (IContainer iContainer : parentMap.keySet()) {
                List files = (List)parentMap.get(iContainer);
                if (files != null) continue;
                result.addAll(PublishPage.findFiles(iContainer, recurse, filter));
            }
        }
        for (IProject project : projectMap.keySet()) {
            parentMap = (Map)projectMap.get(project);
            if (parentMap == null) continue;
            for (Map.Entry entry : parentMap.entrySet()) {
                if (entry.getValue() == null) continue;
                result.addAll((Collection)entry.getValue());
            }
        }
        return result;
    }

    public PublishPage(PublishJob.Type type, List<IResource> resources) throws CoreException {
        super(PublishPage.class.getSimpleName());
        CheckArg.isNotNull(resources, (String)"resources");
        this.setTitle(type == PublishJob.Type.PUBLISH ? RestClientI18n.publishPagePublishTitle : RestClientI18n.publishPageUnpublishTitle);
        this.setPageComplete(false);
        this.type = type;
        this.resources = resources;
        IgnoredResourcesModel model = new IgnoredResourcesModel();
        model.load(Activator.getDefault().getPreferenceStore().getString("modeShape.preference.ignoredResources"));
        this.filter = filterFiles ? new PublishingFileFilter(model) : null;
    }

    private void constructLocationPanel(Composite parent) {
        Group pnl = new Group(parent, 0);
        pnl.setText(RestClientI18n.publishPageLocationGroupTitle);
        pnl.setLayout((Layout)new GridLayout(2, false));
        pnl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite pnlServer = new Composite((Composite)pnl, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        pnlServer.setLayout((Layout)layout);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        pnlServer.setLayoutData((Object)gd);
        Label lblServer = new Label(pnlServer, 16384);
        lblServer.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblServer.setText(RestClientI18n.publishPageServerLabel);
        lblServer.setToolTipText(RestClientI18n.publishPageServerToolTip);
        this.cbxServer = new Combo(pnlServer, 12);
        this.cbxServer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cbxServer.setToolTipText(RestClientI18n.publishPageServerToolTip);
        NewServerAction action = new NewServerAction(this.getShell(), this.getServerManager());
        final Button btnNewServer = new Button(pnlServer, 8);
        btnNewServer.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        btnNewServer.setText(RestClientI18n.publishPageNewServerButton);
        btnNewServer.setToolTipText(action.getToolTipText());
        btnNewServer.addSelectionListener((SelectionListener)new SelectionAdapter((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$action.run();
            }
        });
        btnNewServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PublishPage.this.updateInitialMessage();
                btnNewServer.removeSelectionListener((SelectionListener)this);
            }
        });
        Label lblRepository = new Label((Composite)pnl, 16384);
        lblRepository.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblRepository.setText(RestClientI18n.publishPageRepositoryLabel);
        lblRepository.setToolTipText(RestClientI18n.publishPageRepositoryToolTip);
        this.cbxRepository = new Combo((Composite)pnl, 12);
        this.cbxRepository.setLayoutData((Object)new GridData(4, 128, true, false));
        this.cbxRepository.setToolTipText(RestClientI18n.publishPageRepositoryToolTip);
        Label lblWorkspace = new Label((Composite)pnl, 16384);
        lblWorkspace.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblWorkspace.setText(RestClientI18n.publishPageWorkspaceLabel);
        this.cbxWorkspace = new Combo((Composite)pnl, 12);
        this.cbxWorkspace.setLayoutData((Object)new GridData(4, 128, true, false));
        if (this.type == PublishJob.Type.PUBLISH) {
            this.cbxWorkspace.setToolTipText(RestClientI18n.publishPageWorkspacePublishToolTip);
        } else {
            this.cbxWorkspace.setToolTipText(RestClientI18n.publishPageWorkspaceUnpublishToolTip);
        }
        this.cbxWorkspace.setToolTipText(this.cbxWorkspace.getToolTipText());
        Composite pnlArea = new Composite(parent, 0);
        layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        pnlArea.setLayout((Layout)layout);
        pnlArea.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)pnl.getLayoutData()).horizontalSpan = 2;
        Label lblWorkspaceArea = new Label(pnlArea, 16384);
        lblWorkspaceArea.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblWorkspaceArea.setText(RestClientI18n.publishPageWorkspaceAreaLabel);
        lblWorkspaceArea.setToolTipText(RestClientI18n.publishPageWorkspaceAreaToolTip);
        this.cbxWorkspaceAreas = new Combo(pnlArea, 12);
        this.cbxWorkspaceAreas.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cbxWorkspaceAreas.setToolTipText(RestClientI18n.publishPageWorkspaceAreaToolTip);
        this.cbxWorkspaceAreas.setEnabled(false);
        this.btnNewArea = new Button(pnlArea, 8);
        this.btnNewArea.setImage(Activator.getDefault().getSharedImage("IMG_OBJ_ADD"));
        this.btnNewArea.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.btnNewArea.setToolTipText(RestClientI18n.addPublishAreaActionToolTip);
        this.btnNewArea.setEnabled(false);
        this.btnNewArea.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PublishPage.this.handleNewWorkspaceArea();
            }
        });
    }

    private void constructResourcesPanel(Composite parent) {
        Composite pnl = new Composite(parent, 0);
        pnl.setLayout((Layout)new GridLayout());
        pnl.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lbl = new Label(pnl, 16384);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        if (this.type == PublishJob.Type.PUBLISH) {
            lbl.setText(RestClientI18n.publishPagePublishResourcesLabel);
        } else {
            lbl.setText(RestClientI18n.publishPageUnpublishResourcesLabel);
        }
        this.lstResources = new org.eclipse.swt.widgets.List(pnl, 2816);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.minimumHeight = this.lstResources.getItemHeight() * 2;
        gd.heightHint = this.lstResources.getItemHeight() * 10;
        this.lstResources.setLayoutData((Object)gd);
        final org.eclipse.swt.widgets.List finalLst = this.lstResources;
        this.lstResources.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PublishPage.this.updateInitialMessage();
                finalLst.removeSelectionListener((SelectionListener)this);
            }
        });
        this.loadFiles();
        Button chkRecurse = new Button(pnl, 32);
        chkRecurse.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        chkRecurse.setText(RestClientI18n.publishPageRecurseCheckBox);
        chkRecurse.setToolTipText(RestClientI18n.publishPageRecurseCheckBoxToolTip);
        if (this.getDialogSettings().get(RECURSE_KEY) != null) {
            this.recurse = this.getDialogSettings().getBoolean(RECURSE_KEY);
        }
        chkRecurse.setSelection(this.recurse);
        chkRecurse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PublishPage.this.handleRecurseChanged(((Button)e.widget).getSelection());
            }
        });
        chkRecurse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PublishPage.this.updateInitialMessage();
                ((Button)e.widget).removeSelectionListener((SelectionListener)this);
            }
        });
        Button chkIncludeProject = new Button(pnl, 32);
        chkIncludeProject.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        chkIncludeProject.setText(RestClientI18n.publishPageIncludeProjectCheckBox);
        chkIncludeProject.setToolTipText(RestClientI18n.publishPageIncludeProjectCheckBoxToolTip);
        chkIncludeProject.setSelection(this.includeProjectPath);
        chkIncludeProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PublishPage.this.handleIncludeProjectInPathChanged(((Button)e.widget).getSelection());
            }
        });
        chkIncludeProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PublishPage.this.updateInitialMessage();
                ((Button)e.widget).removeSelectionListener((SelectionListener)this);
            }
        });
        if (this.type == PublishJob.Type.PUBLISH) {
            Composite pnlVersioning = new Composite(pnl, 0);
            pnlVersioning.setLayout((Layout)new GridLayout(2, false));
            ((GridLayout)pnlVersioning.getLayout()).marginWidth = 0;
            pnlVersioning.setLayoutData((Object)new GridData(4, 4, false, true));
            ((GridData)pnlVersioning.getLayoutData()).minimumHeight = 30;
            this.chkVersioning = new Button(pnlVersioning, 32);
            this.chkVersioning.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.chkVersioning.setText(RestClientI18n.publishPageVersionCheckBox);
            this.chkVersioning.setToolTipText(RestClientI18n.publishPageVersionCheckBoxToolTip);
            this.versioning = Activator.getDefault().getPreferenceStore().getBoolean("modeShape.preference.enableResourceVersioning");
            this.chkVersioning.setSelection(this.versioning);
            this.chkVersioning.setEnabled(false);
            this.chkVersioning.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PublishPage.this.handleVersioningChanged(((Button)e.widget).getSelection());
                }
            });
            this.linkPrefs = new Link(pnlVersioning, 64);
            this.linkPrefs.setText(RestClientI18n.publishPageOpenPreferencePageLink);
            this.linkPrefs.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.linkPrefs.setEnabled(false);
            this.linkPrefs.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PublishPage.this.handleOpenPreferencePage();
                }
            });
        }
    }

    public void createControl(Composite parent) {
        Composite pnlMain = new Composite(parent, 0);
        pnlMain.setLayout((Layout)new GridLayout());
        pnlMain.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.constructLocationPanel(pnlMain);
        this.constructResourcesPanel(pnlMain);
        this.setControl((Control)pnlMain);
        this.cbxRepository.addModifyListener((ModifyListener)this);
        this.cbxServer.addModifyListener((ModifyListener)this);
        this.cbxWorkspace.addModifyListener((ModifyListener)this);
        this.cbxWorkspaceAreas.addModifyListener((ModifyListener)this);
        IWorkbenchHelpSystem helpSystem = Activator.getDefault().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnlMain, "org.jboss.tools.modeshape.rest.publishDialogHelpContext");
        this.getServerManager().addRegistryListener(this);
    }

    public void dispose() {
        this.getServerManager().removeRegistryListener(this);
        super.dispose();
    }

    List<IFile> getFiles() {
        return this.files;
    }

    private ServerManager getServerManager() {
        return ((PublishWizard)this.getWizard()).getServerManager();
    }

    ModeShapeWorkspace getWorkspace() {
        assert (this.isPageComplete());
        return this.workspace;
    }

    String getWorkspaceArea() {
        return this.workspaceArea;
    }

    void handleIncludeProjectInPathChanged(boolean selected) {
        this.includeProjectPath = selected;
    }

    void handleNewWorkspaceArea() {
        AddPublishAreaAction action = new AddPublishAreaAction(this.getShell(), this.getServerManager(), this.workspace, Utils.getServerViewer());
        action.run();
        if (action.success()) {
            String newPath = null;
            String[] before = this.cbxWorkspaceAreas.getItems();
            WorkspaceArea[] workspaceAreas = this.workspaceAreas();
            ArrayList<String> items = new ArrayList<String>();
            if (workspaceAreas != null && workspaceAreas.length != 0) {
                WorkspaceArea[] workspaceAreaArray = workspaceAreas;
                int n = workspaceAreas.length;
                int n2 = 0;
                while (n2 < n) {
                    WorkspaceArea area = workspaceAreaArray[n2];
                    boolean found = false;
                    String path = area.getPath();
                    items.add(path);
                    if (StringUtil.isBlank(newPath)) {
                        String[] stringArray = before;
                        int n3 = before.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String beforeArea = stringArray[n4];
                            if (beforeArea.equals(path)) {
                                found = true;
                                break;
                            }
                            ++n4;
                        }
                        if (!found) {
                            newPath = path;
                        }
                    }
                    ++n2;
                }
                Collections.sort(items);
            }
            this.cbxWorkspaceAreas.setItems(items.toArray(new String[items.size()]));
            if (!StringUtil.isBlank(newPath)) {
                this.cbxWorkspaceAreas.setText(newPath);
            }
        }
    }

    void handleOpenPreferencePage() {
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.jboss.tools.modeshape.rest.publishingPreferencePage", (String[])new String[]{"org.jboss.tools.modeshape.rest.publishingPreferencePage"}, null).open();
    }

    void handleRecurseChanged(boolean selected) {
        block2: {
            this.recurse = selected;
            try {
                this.files = PublishPage.processResources(this.resources, this.isRecursing(), this.filter);
                this.loadFiles();
            }
            catch (CoreException e) {
                Activator.getDefault().log(new Status(Status.Severity.ERROR, RestClientI18n.publishPageRecurseProcessingErrorMsg, (Throwable)e));
                if (!this.getControl().isVisible()) break block2;
                MessageDialog.openError((Shell)this.getShell(), (String)RestClientI18n.errorDialogTitle, (String)RestClientI18n.publishPageRecurseProcessingErrorMsg);
            }
        }
    }

    void handleRepositoryModified() {
        int index = this.cbxRepository.getSelectionIndex();
        if (index != -1) {
            String repoName = this.cbxRepository.getText();
            for (ModeShapeRepository repo : this.repositories) {
                if (!repoName.equals(repo.getName())) continue;
                this.repository = repo;
                break;
            }
        }
        this.updateRepositoryCapabilities();
        this.refreshWorkspaces();
        this.updateState();
    }

    void handleServerModified() {
        int index = this.cbxServer.getSelectionIndex();
        if (index != -1) {
            this.server = this.servers.get(index);
        }
        this.refreshRepositories();
        this.updateState();
    }

    void handleVersioningChanged(boolean selected) {
        this.versioning = selected;
    }

    void handleWorkspaceAreaModified() {
        int index = this.cbxWorkspaceAreas.getSelectionIndex();
        this.workspaceArea = index == -1 ? this.cbxWorkspaceAreas.getText() : this.cbxWorkspaceAreas.getItems()[index];
        this.updateState();
    }

    WorkspaceArea[] workspaceAreas() {
        try {
            WorkspaceArea[] workspaceAreas = this.getServerManager().getWorkspaceAreas(this.workspace);
            return workspaceAreas;
        }
        catch (Exception e) {
            Activator.getDefault().log(new Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.publishPageUnableToObtainWorkspaceAreas, (Object)this.workspace), (Throwable)e));
            return new WorkspaceArea[0];
        }
    }

    void handleWorkspaceModified() {
        int index = this.cbxWorkspace.getSelectionIndex();
        if (index != -1) {
            String workspaceName = this.cbxWorkspace.getText();
            for (ModeShapeWorkspace testWorkspace : this.workspaces) {
                if (!workspaceName.equals(testWorkspace.getName())) continue;
                this.workspace = testWorkspace;
                break;
            }
            WorkspaceArea[] workspaceAreas = this.workspaceAreas();
            ArrayList<String> items = new ArrayList<String>();
            if (workspaceAreas != null && workspaceAreas.length != 0) {
                WorkspaceArea[] workspaceAreaArray = workspaceAreas;
                int n = workspaceAreas.length;
                int n2 = 0;
                while (n2 < n) {
                    WorkspaceArea area = workspaceAreaArray[n2];
                    String path = area.getPath();
                    items.add(path);
                    ++n2;
                }
                Collections.sort(items);
            }
            this.cbxWorkspaceAreas.setItems(items.toArray(new String[items.size()]));
            if (!this.cbxWorkspaceAreas.isEnabled()) {
                this.cbxWorkspaceAreas.setEnabled(true);
                this.btnNewArea.setEnabled(true);
            }
        } else {
            this.workspaceArea = null;
            this.cbxWorkspaceAreas.removeAll();
            if (this.cbxWorkspaceAreas.isEnabled()) {
                this.cbxWorkspaceAreas.setEnabled(false);
                this.btnNewArea.setEnabled(false);
            }
        }
        if (this.cbxWorkspaceAreas.getItemCount() == 0) {
            this.workspaceArea = null;
        } else {
            this.cbxWorkspaceAreas.select(0);
        }
        this.updateState();
    }

    boolean isIncludingProjectPath() {
        return this.includeProjectPath;
    }

    boolean isRecursing() {
        return this.recurse;
    }

    boolean isVersioning() {
        return this.repositorySupportsVersioning && this.versioning;
    }

    private void loadFiles() {
        this.lstResources.removeAll();
        for (IResource iResource : this.files) {
            this.lstResources.add(iResource.getFullPath().toString());
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.cbxServer) {
            this.handleServerModified();
        } else if (e.widget == this.cbxRepository) {
            this.handleRepositoryModified();
        } else if (e.widget == this.cbxWorkspace) {
            this.handleWorkspaceModified();
        } else if (e.widget == this.cbxWorkspaceAreas) {
            this.handleWorkspaceAreaModified();
        } else assert (false);
    }

    private void refreshRepositories() {
        this.repository = null;
        if (this.server == null) {
            this.repositories = Collections.emptyList();
        } else {
            try {
                this.repositories = new ArrayList<ModeShapeRepository>(this.getServerManager().getRepositories(this.server));
            }
            catch (Exception e) {
                this.repositories = Collections.emptyList();
                String msg = NLS.bind((String)RestClientI18n.serverManagerGetRepositoriesExceptionMsg, (Object)this.server.getShortDescription());
                Activator.getDefault().log(new Status(Status.Severity.ERROR, msg, (Throwable)e));
            }
        }
        this.cbxRepository.removeAll();
        if (this.repositories.isEmpty()) {
            if (this.cbxRepository.getEnabled()) {
                this.cbxRepository.setEnabled(false);
            }
        } else if (this.repositories.size() == 1) {
            this.repository = this.repositories.get(0);
            this.cbxRepository.add(this.repository.getName());
            this.cbxRepository.select(0);
            if (!this.cbxRepository.getEnabled()) {
                this.cbxRepository.setEnabled(true);
            }
        } else {
            ArrayList<String> repoNames = new ArrayList<String>(this.repositories.size());
            for (ModeShapeRepository repository : this.repositories) {
                repoNames.add(repository.getName());
            }
            Collections.sort(repoNames);
            this.cbxRepository.setItems(repoNames.toArray(new String[repoNames.size()]));
            if (!this.cbxRepository.getEnabled()) {
                this.cbxRepository.setEnabled(true);
            }
        }
        this.updateRepositoryCapabilities();
        this.refreshWorkspaces();
    }

    void refreshServers() {
        this.server = null;
        this.servers = new ArrayList<ModeShapeServer>(this.getServerManager().getServers());
        this.cbxServer.removeAll();
        if (this.servers.size() == 0) {
            if (this.cbxServer.getEnabled()) {
                this.cbxServer.setEnabled(false);
            }
        } else if (this.servers.size() == 1) {
            this.server = this.servers.get(0);
            this.cbxServer.add(this.server.getName());
            this.cbxServer.select(0);
            if (!this.cbxServer.getEnabled()) {
                this.cbxServer.setEnabled(true);
            }
        } else {
            for (ModeShapeServer server : this.servers) {
                this.cbxServer.add(server.getName());
            }
            if (!this.cbxServer.getEnabled()) {
                this.cbxServer.setEnabled(true);
            }
        }
        this.refreshRepositories();
    }

    private void refreshWorkspaces() {
        this.workspace = null;
        if (this.repository == null) {
            this.workspaces = Collections.emptyList();
        } else {
            try {
                this.workspaces = new ArrayList<ModeShapeWorkspace>(this.getServerManager().getWorkspaces(this.repository));
            }
            catch (Exception e) {
                this.workspaces = Collections.emptyList();
                String msg = NLS.bind((String)RestClientI18n.serverManagerGetWorkspacesExceptionMsg, (Object)this.repository);
                Activator.getDefault().log(new Status(Status.Severity.ERROR, msg, (Throwable)e));
            }
        }
        this.cbxWorkspace.removeAll();
        this.cbxWorkspaceAreas.removeAll();
        if (this.workspaces.isEmpty()) {
            if (this.cbxWorkspace.getEnabled()) {
                this.cbxWorkspace.setEnabled(false);
            }
            if (this.cbxWorkspaceAreas.isEnabled()) {
                this.cbxWorkspaceAreas.setEnabled(false);
                this.btnNewArea.setEnabled(false);
            }
        } else if (this.workspaces.size() == 1) {
            ModeShapeWorkspace temp = this.workspaces.get(0);
            this.cbxWorkspace.add(temp.getName());
            this.cbxWorkspace.select(0);
            if (!this.cbxWorkspace.getEnabled()) {
                this.cbxWorkspace.setEnabled(true);
            }
            if (!this.cbxWorkspaceAreas.getEnabled()) {
                this.cbxWorkspaceAreas.setEnabled(true);
                this.btnNewArea.setEnabled(true);
            }
        } else {
            ArrayList<String> workspaceNames = new ArrayList<String>(this.workspaces.size());
            for (ModeShapeWorkspace workspace : this.workspaces) {
                workspaceNames.add(workspace.getName());
            }
            Collections.sort(workspaceNames);
            this.cbxWorkspace.setItems(workspaceNames.toArray(new String[workspaceNames.size()]));
            if (!this.cbxWorkspace.getEnabled()) {
                this.cbxWorkspace.setEnabled(true);
            }
            if (this.cbxWorkspaceAreas.isEnabled()) {
                this.cbxWorkspaceAreas.setEnabled(false);
                this.btnNewArea.setEnabled(false);
            }
        }
    }

    @Override
    public Exception[] serverRegistryChanged(ServerRegistryEvent event) {
        if (event.isNew()) {
            this.refreshServers();
            this.updateState();
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validate();
            this.setPageComplete(!this.status.isError());
            if (this.status.isOk()) {
                String msg = this.type == PublishJob.Type.PUBLISH ? RestClientI18n.publishPagePublishOkStatusMsg : RestClientI18n.publishPageUnpublishOkStatusMsg;
                this.setMessage(msg, 0);
            } else {
                this.setMessage(this.status.getMessage(), 3);
            }
        }
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        try {
            this.files = PublishPage.processResources(this.resources, this.isRecursing(), this.filter);
        }
        catch (CoreException e) {
            Activator.getDefault().log(new Status(Status.Severity.ERROR, RestClientI18n.publishPageRecurseProcessingErrorMsg, (Throwable)e));
        }
    }

    void updateInitialMessage() {
        String msg;
        String string = msg = this.type == PublishJob.Type.PUBLISH ? RestClientI18n.publishPagePublishOkStatusMsg : RestClientI18n.publishPageUnpublishOkStatusMsg;
        if (msg.equals(this.getMessage())) {
            this.updateState();
        }
    }

    private void updateRepositoryCapabilities() {
        Object supportsVersioning;
        this.repositorySupportsVersioning = true;
        this.repositorySupportsVersioning = this.repository == null ? false : ((supportsVersioning = this.repository.getProperties().get("option.versioning.supported")) == null ? false : Boolean.parseBoolean(supportsVersioning.toString()));
        if (this.chkVersioning != null && this.chkVersioning.getEnabled() != this.repositorySupportsVersioning) {
            this.chkVersioning.setEnabled(this.repositorySupportsVersioning);
            this.linkPrefs.setEnabled(this.repositorySupportsVersioning);
        }
    }

    void updateState() {
        this.validate();
        this.setPageComplete(!this.status.isError());
        if (this.status.isError()) {
            this.setMessage(this.status.getMessage(), 3);
        } else if (this.status.isWarning()) {
            this.setMessage(this.status.getMessage(), 2);
        } else if (this.status.isInfo()) {
            this.setMessage(this.status.getMessage(), 1);
        } else {
            this.setMessage(this.status.getMessage(), 0);
        }
    }

    private void validate() {
        String msg = null;
        Status.Severity severity = Status.Severity.ERROR;
        if (this.resources == null || this.resources.isEmpty() || this.files.isEmpty()) {
            msg = this.type == PublishJob.Type.PUBLISH ? RestClientI18n.publishPageNoResourcesToPublishStatusMsg : RestClientI18n.publishPageNoResourcesToUnpublishStatusMsg;
        } else if (this.server == null) {
            int count = this.cbxServer.getItemCount();
            msg = count == 0 ? RestClientI18n.publishPageNoAvailableServersStatusMsg : RestClientI18n.publishPageMissingServerStatusMsg;
        } else if (this.repository == null) {
            int count = this.cbxRepository.getItemCount();
            msg = count == 0 ? RestClientI18n.publishPageNoAvailableRepositoriesStatusMsg : RestClientI18n.publishPageMissingRepositoryStatusMsg;
        } else if (this.workspace == null) {
            int count = this.cbxWorkspace.getItemCount();
            msg = count == 0 ? RestClientI18n.publishPageNoAvailableWorkspacesStatusMsg : RestClientI18n.publishPageMissingWorkspaceStatusMsg;
        } else if (this.workspaceArea == null) {
            msg = RestClientI18n.publishPageMissingPublishAreaStatusMsg;
        } else {
            severity = Status.Severity.OK;
            msg = this.type == PublishJob.Type.PUBLISH ? RestClientI18n.publishPagePublishOkStatusMsg : RestClientI18n.publishPageUnpublishOkStatusMsg;
        }
        this.status = new Status(severity, msg, null);
    }

    void wizardFinished() {
        this.getDialogSettings().put(RECURSE_KEY, this.recurse);
    }
}

