/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.roles.ui.RolesUiPlugin;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.preferences.IGeneralPreferencePageContributor;

public class AutoWillToggleChildrenPreferenceContributor
implements IGeneralPreferencePageContributor,
UiConstants {
    private static final String PREF_ID = "autoWillToggleChildren";
    private static final String PREFIX = I18nUtil.getPropertyPrefix(AutoWillToggleChildrenPreferenceContributor.class);
    private Button chkEnabled;

    public void createPreferenceEditor(Composite theParent) {
        Composite pnl = new Composite(theParent, 0);
        pnl.setLayout((Layout)new GridLayout());
        pnl.setLayoutData((Object)new GridData());
        this.chkEnabled = WidgetFactory.createCheckBox((Composite)pnl, (String)this.getName());
        this.chkEnabled.setLayoutData((Object)new GridData());
        this.chkEnabled.setToolTipText(this.getToolTip());
        this.refresh();
    }

    public String getName() {
        return RolesUiPlugin.UTIL.getStringOrKey(String.valueOf(PREFIX) + "name");
    }

    private IPreferenceStore getPreferenceStore() {
        return UiPlugin.getDefault().getPreferenceStore();
    }

    public String getToolTip() {
        return RolesUiPlugin.UTIL.getStringOrKey(String.valueOf(PREFIX) + "toolTip");
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performDefaults() {
        this.chkEnabled.setSelection(this.getPreferenceStoreValue(true));
        return true;
    }

    public boolean performOk() {
        String value = "never";
        if (this.chkEnabled.getSelection()) {
            value = "always";
        }
        this.getPreferenceStore().setValue(PREF_ID, value);
        return true;
    }

    public void refresh() {
        this.chkEnabled.setSelection(this.getPreferenceStoreValue(false));
    }

    public void setWorkbench(IWorkbench theWorkbench) {
    }

    private boolean getPreferenceStoreValue(boolean theDefaultFlag) {
        boolean result = false;
        IPreferenceStore prefStore = this.getPreferenceStore();
        String value = null;
        value = theDefaultFlag ? prefStore.getDefaultString(PREF_ID) : prefStore.getString(PREF_ID);
        if (value.equals("always")) {
            result = true;
        }
        return result;
    }
}

