/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.roles.Crud;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.roles.ui.RolesUiPlugin;
import org.teiid.designer.roles.ui.wizard.DataRolesModelTreeProvider;
import org.teiid.designer.transformation.util.TransformationHelper;

public class PermissionHandler {
    private DataRolesModelTreeProvider tree;
    private Map<Object, Permission> objectsToPermissionsMap;

    public PermissionHandler(DataRolesModelTreeProvider tree) {
        this.tree = tree;
        this.objectsToPermissionsMap = new HashMap<Object, Permission>();
    }

    public void handlePermissionChanged(Permission permission) {
        Object targetObject = null;
        for (Object obj : this.objectsToPermissionsMap.keySet()) {
            Permission perm = this.objectsToPermissionsMap.get(obj);
            if (perm != permission) continue;
            targetObject = obj;
        }
        if (targetObject != null) {
            this.cleanUpPermissions(targetObject);
        }
    }

    private void cleanUpPermissions(Object changedElement) {
        Permission perm = this.objectsToPermissionsMap.get(changedElement);
        if (perm == null || perm.isPrimary() || perm.isAllowLanguage()) {
            return;
        }
        if (perm.isNullCrud()) {
            if (perm.getCondition() == null && perm.getMask() == null) {
                this.objectsToPermissionsMap.remove(changedElement);
            }
        } else {
            boolean sameCreate = false;
            boolean sameRead = false;
            boolean sameUpdate = false;
            boolean sameDelete = false;
            boolean sameExecute = false;
            boolean sameAlter = false;
            Permission parentPerm = this.getFirstParentPermission(changedElement, Crud.Type.CREATE);
            if (parentPerm != null && (perm.getCRUDValue(Crud.Type.CREATE) == parentPerm.getCRUDValue(Crud.Type.CREATE) || perm.getCRUDValue(Crud.Type.CREATE) == null && parentPerm.getCRUDValue(Crud.Type.CREATE) != null)) {
                sameCreate = true;
            }
            if (!sameCreate) {
                return;
            }
            parentPerm = this.getFirstParentPermission(changedElement, Crud.Type.READ);
            if (parentPerm != null && (perm.getCRUDValue(Crud.Type.READ) == parentPerm.getCRUDValue(Crud.Type.READ) || perm.getCRUDValue(Crud.Type.READ) == null && parentPerm.getCRUDValue(Crud.Type.READ) != null)) {
                sameRead = true;
            }
            if (!sameRead) {
                return;
            }
            parentPerm = this.getFirstParentPermission(changedElement, Crud.Type.UPDATE);
            if (parentPerm != null && (perm.getCRUDValue(Crud.Type.UPDATE) == parentPerm.getCRUDValue(Crud.Type.UPDATE) || perm.getCRUDValue(Crud.Type.UPDATE) == null && parentPerm.getCRUDValue(Crud.Type.UPDATE) != null)) {
                sameUpdate = true;
            }
            if (!sameUpdate) {
                return;
            }
            parentPerm = this.getFirstParentPermission(changedElement, Crud.Type.DELETE);
            if (parentPerm != null && (perm.getCRUDValue(Crud.Type.DELETE) == parentPerm.getCRUDValue(Crud.Type.DELETE) || perm.getCRUDValue(Crud.Type.DELETE) == null && parentPerm.getCRUDValue(Crud.Type.DELETE) != null)) {
                sameDelete = true;
            }
            if ((parentPerm = this.getFirstParentPermission(changedElement, Crud.Type.EXECUTE)) != null && (perm.getCRUDValue(Crud.Type.EXECUTE) == parentPerm.getCRUDValue(Crud.Type.EXECUTE) || perm.getCRUDValue(Crud.Type.EXECUTE) == null && parentPerm.getCRUDValue(Crud.Type.EXECUTE) != null)) {
                sameExecute = true;
            }
            if ((parentPerm = this.getFirstParentPermission(changedElement, Crud.Type.ALTER)) != null && (perm.getCRUDValue(Crud.Type.ALTER) == parentPerm.getCRUDValue(Crud.Type.ALTER) || perm.getCRUDValue(Crud.Type.ALTER) == null && parentPerm.getCRUDValue(Crud.Type.ALTER) != null)) {
                sameAlter = true;
            }
            if (sameCreate && sameRead && sameUpdate && sameDelete && sameExecute && sameAlter) {
                if (perm.getCondition() != null || perm.getMask() != null) {
                    perm.setCRUD(null, null, null, null, null, null);
                } else {
                    this.objectsToPermissionsMap.remove(changedElement);
                }
            }
        }
    }

    private void getChildPermissions(Object parent, Collection<Permission> allChildPermissions) {
        Object[] objectArray = this.tree.getChildren(parent);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            Permission perm = this.objectsToPermissionsMap.get(child);
            if (perm != null) {
                allChildPermissions.add(perm);
            }
            this.getChildPermissions(child, allChildPermissions);
            ++n2;
        }
    }

    private void getChildrenWithPermission(Object parent, Collection<Object> childrenWithPermission) {
        Object[] objectArray = this.tree.getChildren(parent);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            Permission perm = this.objectsToPermissionsMap.get(child);
            if (perm != null) {
                childrenWithPermission.add(child);
            }
            this.getChildrenWithPermission(child, childrenWithPermission);
            ++n2;
        }
    }

    public Permission getExistingPermission(Object element, Crud.Type crudType) {
        Permission perm = this.objectsToPermissionsMap.get(element);
        if (perm == null || perm.getCRUDValue(crudType) == null) {
            Object parent = this.tree.getParent(element);
            while (parent != null && (perm == null || perm.getCRUDValue(crudType) == null)) {
                perm = this.objectsToPermissionsMap.get(parent);
                parent = this.tree.getParent(parent);
            }
        }
        return perm;
    }

    public Permission getParentPermission(Object element, Crud.Type crudType) {
        Permission perm = this.objectsToPermissionsMap.get(element);
        if (perm != null && perm.getCRUDValue(crudType) != null) {
            return perm;
        }
        return null;
    }

    private Permission getModelPermssion(Object element) {
        if (element instanceof Resource) {
            return this.objectsToPermissionsMap.get(element);
        }
        Object parent = this.tree.getParent(element);
        while (parent != null) {
            if (parent instanceof Resource) {
                return this.objectsToPermissionsMap.get(parent);
            }
            parent = this.tree.getParent(parent);
        }
        return null;
    }

    private Object getModelElement(Object element) {
        Object parent = element;
        while (parent != null) {
            Object theParent = parent;
            if (theParent instanceof Resource) {
                return theParent;
            }
            parent = this.tree.getParent(theParent);
        }
        return null;
    }

    private Permission getFirstParentPermission(Object element, Crud.Type crudType) {
        Permission perm = null;
        Object parent = this.tree.getParent(element);
        while (parent != null && (perm == null || perm.getCRUDValue(crudType) == null)) {
            perm = this.objectsToPermissionsMap.get(parent);
            parent = this.tree.getParent(parent);
        }
        return perm;
    }

    public Permission getPermission(Object element) {
        return this.objectsToPermissionsMap.get(element);
    }

    public boolean hasChildWithDifferentCrudValue(Permission parentPermission, Object parent, Crud.Type type) {
        Boolean parentValue = parentPermission.getCRUDValue(type);
        ArrayList<Permission> childPermissions = new ArrayList<Permission>();
        this.getChildPermissions(parent, childPermissions);
        for (Permission perm : childPermissions) {
            Boolean childValue = perm.getCRUDValue(type);
            if (childValue == null || !parentPermission.childCrudValueIsDifferent(parentValue, childValue)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermissions() {
        return !this.objectsToPermissionsMap.isEmpty();
    }

    public void addPermission(Object key, Permission perm) {
        if (!this.objectsToPermissionsMap.containsKey(key)) {
            this.objectsToPermissionsMap.put(key, perm);
        }
    }

    private void disableNearestParentPermission(Object element, Crud.Type crudType) {
        Object firstParent = this.tree.getParent(element);
        Permission perm = this.objectsToPermissionsMap.get(firstParent);
        if (perm != null && perm.getCRUDValue(crudType) != null && perm.getCRUDValue(crudType) == Boolean.FALSE) {
            perm.setCRUDValue(Boolean.valueOf(true), crudType);
        } else {
            Permission permiss = null;
            Object parent = this.tree.getParent(firstParent);
            while (parent != null && !(parent instanceof Resource) && permiss == null) {
                permiss = this.objectsToPermissionsMap.get(parent);
                parent = this.tree.getParent(parent);
                if (permiss == null || permiss.getCRUDValue(crudType) != Boolean.FALSE) continue;
                perm.setCRUDValue(Boolean.valueOf(true), crudType);
                return;
            }
        }
    }

    private boolean hasParentPermission(Object element, Crud.Type crudType) {
        Object firstParent = this.tree.getParent(element);
        Permission perm = this.objectsToPermissionsMap.get(firstParent);
        if (perm == null || perm.getCRUDValue(crudType) == null) {
            return false;
        }
        Permission permiss = perm;
        if (permiss.getCRUDValue(crudType) == Boolean.FALSE) {
            return true;
        }
        Object parent = this.tree.getParent(firstParent);
        while (!(parent == null || parent instanceof Resource || permiss != null && permiss.getCRUDValue(crudType) != null)) {
            permiss = this.objectsToPermissionsMap.get(parent);
            parent = this.tree.getParent(parent);
            if (permiss == null || permiss.getCRUDValue(crudType) != Boolean.FALSE) continue;
            return true;
        }
        return false;
    }

    private Permission togglePermissionValue(Object element, boolean newValue, Crud.Type crudType) {
        Permission permission = this.objectsToPermissionsMap.get(element);
        if (permission == null) {
            permission = new Permission(this.tree.getTargetName(element), new Crud(null, null, null, null, null, null));
            this.objectsToPermissionsMap.put(element, permission);
            permission.setCRUDValue(Boolean.valueOf(newValue), crudType);
        } else {
            permission.toggleCRUDValue(crudType);
        }
        Boolean parentValue = permission.getCRUDValue(crudType);
        ArrayList<Permission> childPermissions = new ArrayList<Permission>();
        this.getChildPermissions(element, childPermissions);
        for (Permission perm : childPermissions) {
            if (perm.getCRUDValue(crudType) == null) continue;
            perm.setCRUDValue(parentValue, crudType);
        }
        return permission;
    }

    /*
     * WARNING - void declaration
     */
    public void toggleElementPermission(Object element, Crud.Type crudType) {
        void var7_13;
        if (!this.supportsUpdates(element, crudType)) {
            return;
        }
        Permission modelPermission = this.getModelPermssion(element);
        Object modelElement = this.getModelElement(element);
        boolean firstTimePermission = false;
        if (modelPermission == null || modelPermission.getCRUDValue(crudType) == Boolean.FALSE) {
            if (modelPermission == null) {
                Crud targetCrud = new Crud(null, null, null, null, null, null);
                modelPermission = new Permission(this.tree.getTargetName(modelElement), targetCrud);
                modelPermission.setCRUDValue(Boolean.valueOf(true), crudType);
                this.objectsToPermissionsMap.put(modelElement, modelPermission);
            } else {
                modelPermission.setCRUDValue(Boolean.valueOf(true), crudType);
            }
            firstTimePermission = true;
        }
        if (firstTimePermission) {
            this.disableAllSiblingPermissions(element, crudType);
            Object parent = this.tree.getParent(element);
            while (parent != null && parent != modelElement) {
                Object object = parent;
                this.disableAllSiblingPermissions(parent, crudType);
                parent = this.tree.getParent(object);
            }
        } else {
            boolean hasParentPermissionFalse = this.hasParentPermission(element, crudType);
            if (hasParentPermissionFalse) {
                this.disableNearestParentPermission(element, crudType);
                this.disableAllSiblingPermissions(element, crudType);
            }
            this.togglePermissionValue(element, hasParentPermissionFalse, crudType);
        }
        this.cleanUpPermissions(element);
        ArrayList<Object> childPermissions = new ArrayList<Object>();
        this.getChildrenWithPermission(element, childPermissions);
        for (Object e : childPermissions) {
            this.cleanUpPermissions(e);
        }
        Object object = element;
        while (!this.isPrimary(var7_13) && this.allSiblingsHaveSameStatus(var7_13, crudType)) {
            Object parent = this.tree.getParent(var7_13);
            if (parent != null && !this.haveSameStatus(parent, var7_13, crudType)) {
                Permission parentPerm = this.objectsToPermissionsMap.get(parent);
                Permission elementPerm = this.getExistingPermission(var7_13, crudType);
                Boolean elementStatus = elementPerm.getCRUDValue(crudType);
                if (parentPerm == null) {
                    Crud targetCrud = new Crud(null, null, null, null, null, null);
                    Permission permission = new Permission(this.tree.getTargetName(parent), targetCrud);
                    permission.setCRUDValue(elementStatus, crudType);
                    this.objectsToPermissionsMap.put(parent, permission);
                } else {
                    parentPerm.setCRUDValue(elementStatus, crudType);
                }
                this.cleanUpPermissions(parent);
                ArrayList<Object> pchildPermissions = new ArrayList<Object>();
                this.getChildrenWithPermission(parent, pchildPermissions);
                for (Object e : pchildPermissions) {
                    this.cleanUpPermissions(e);
                }
            }
            Object object2 = parent;
        }
    }

    private void disableAllSiblingPermissions(Object element, Crud.Type crudType) {
        Object parent = this.tree.getParent(element);
        if (parent != null) {
            Object[] objectArray = this.tree.getChildren(parent);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child != element) {
                    Permission existingPermission = this.objectsToPermissionsMap.get(child);
                    if (existingPermission == null) {
                        Crud childCrud = new Crud(null, null, null, null, null, null);
                        Permission newPermission = new Permission(this.tree.getTargetName(child), childCrud);
                        newPermission.setCRUDValue(Boolean.valueOf(false), crudType);
                        this.objectsToPermissionsMap.put(child, newPermission);
                    } else {
                        existingPermission.setCRUDValue(Boolean.valueOf(false), crudType);
                    }
                }
                ++n2;
            }
        }
    }

    public IStatus getToggleStatus(Object element, Crud.Type crudType) {
        if (!this.supportsUpdates(element, crudType)) {
            return this.createStatus(1, RolesUiPlugin.UTIL.getString("PermissionHandler.infoNotUpdatable", new Object[0]));
        }
        Object[] children = this.tree.getChildren(element);
        if (children.length > 0) {
            String msg = null;
            msg = crudType == Crud.Type.READ ? RolesUiPlugin.UTIL.getString("PermissionHandler.warningWillToggleChildren", new Object[0]) : RolesUiPlugin.UTIL.getString("PermissionHandler.warningWillToggleChildrenIfUpdatable", new Object[0]);
            return this.createStatus(2, msg);
        }
        return this.createStatus(0, "");
    }

    private IStatus createStatus(int statusFlag, String msg) {
        Status status = new Status(statusFlag, RolesUiPlugin.PLUGIN_ID, msg);
        return status;
    }

    private boolean allSiblingsHaveSameStatus(Object element, Crud.Type crudType) {
        boolean allSame = true;
        Object parent = this.tree.getParent(element);
        if (parent != null) {
            int i = 0;
            Boolean firstStatus = null;
            Object[] objectArray = this.tree.getChildren(parent);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                Permission perm = this.getExistingPermission(child, crudType);
                Boolean currentStatus = null;
                if (perm != null) {
                    currentStatus = perm.getCRUDValue(crudType);
                }
                if (i == 0) {
                    firstStatus = currentStatus;
                } else if (currentStatus != firstStatus) {
                    allSame = false;
                    break;
                }
                ++i;
                ++n2;
            }
        }
        return allSame;
    }

    private boolean isPrimary(Object element) {
        Permission perm = this.objectsToPermissionsMap.get(element);
        return perm != null && perm.isPrimary();
    }

    private boolean haveSameStatus(Object elem1, Object elem2, Crud.Type crudType) {
        Permission elem1Perm = this.getExistingPermission(elem1, crudType);
        Permission elem2Perm = this.getExistingPermission(elem2, crudType);
        Boolean elem1Status = elem1Perm.getCRUDValue(crudType);
        Boolean elem2Status = elem2Perm.getCRUDValue(crudType);
        return elem1Status != null && elem2Status != null && elem1Status == elem2Status;
    }

    public boolean supportsUpdates(Object element, Crud.Type crudType) {
        Object targetObj = element;
        if (TransformationHelper.isSqlColumn((Object)element) || element instanceof ProcedureParameter) {
            targetObj = ((EObject)element).eContainer();
            if (crudType == Crud.Type.DELETE) {
                return false;
            }
        }
        boolean isVirtualTable = TransformationHelper.isVirtualSqlTable((Object)targetObj);
        if (TransformationHelper.isSqlTable((Object)targetObj) && !TransformationHelper.isXmlDocument((Object)targetObj)) {
            SqlTableAspect tableAspect = (SqlTableAspect)SqlAspectHelper.getSqlAspect((EObject)((EObject)targetObj));
            if (tableAspect != null) {
                if (isVirtualTable) {
                    EObject transMappingRoot = TransformationHelper.getTransformationMappingRoot((EObject)((EObject)targetObj));
                    switch (crudType) {
                        case CREATE: {
                            return TransformationHelper.isInsertAllowed((Object)transMappingRoot);
                        }
                        case READ: {
                            return true;
                        }
                        case UPDATE: {
                            return TransformationHelper.isUpdateAllowed((Object)transMappingRoot);
                        }
                        case DELETE: {
                            return TransformationHelper.isDeleteAllowed((Object)transMappingRoot);
                        }
                    }
                    return false;
                }
                return tableAspect.supportsUpdate((EObject)targetObj);
            }
        } else {
            return true;
        }
        return false;
    }

    public void loadPermissions(Collection<Permission> permissions) {
        for (Permission perm : permissions) {
            if (perm.isAllowLanguage()) {
                this.objectsToPermissionsMap.put(perm.getTargetName(), perm);
                continue;
            }
            Object obj = this.tree.getPermissionTargetObject(perm);
            if (obj == null) continue;
            if (obj instanceof Resource) {
                perm.setPrimary(true);
            }
            perm.setCanFilter(this.tree.allowsRowFilter(obj));
            perm.setCanMask(this.tree.allowsColumnMask(obj));
            this.objectsToPermissionsMap.put(obj, perm);
        }
    }

    public Collection<Permission> getPermissions() {
        return this.objectsToPermissionsMap.values();
    }

    public List<Permission> getPermissionsWithRowBasedSecurity() {
        ArrayList<Permission> perms = new ArrayList<Permission>(10);
        for (Permission perm : this.getPermissions()) {
            if (!perm.canFilter() || perm.getCondition() == null) continue;
            perms.add(perm);
        }
        return perms;
    }

    public Permission getPermission(String targetName) {
        for (Permission perm : this.objectsToPermissionsMap.values()) {
            if (!perm.getTargetName().equals(targetName)) continue;
            return perm;
        }
        return null;
    }

    public List<Permission> getPermissionsWithColumnMasking() {
        ArrayList<Permission> perms = new ArrayList<Permission>(10);
        for (Permission perm : this.getPermissions()) {
            if (!perm.canMask() || perm.getMask() == null && perm.getCondition() == null) continue;
            perms.add(perm);
        }
        return perms;
    }

    public void removeRowBasedSecurity(Permission permission) {
        permission.setCondition(null);
        permission.setConstraint(true);
    }

    public void removeColumnMask(Permission permission) {
        permission.setMask(null);
        permission.setOrder(0);
        permission.setCondition(null);
    }

    public void removeColumnMask(String targetName) {
        Permission existingPerm = this.getPermission(targetName);
        if (existingPerm != null) {
            existingPerm.setMask(null);
            existingPerm.setOrder(0);
            existingPerm.setCondition(null);
        }
    }

    public void setColumnMask(String targetName, String condition, String mask, int order) {
        Permission existingPerm = this.getPermission(targetName);
        if (existingPerm == null) {
            existingPerm = new Permission(targetName, new Crud(null, null, null, null, null, null));
            existingPerm.setCanMask(true);
            this.objectsToPermissionsMap.put(targetName, existingPerm);
        }
        existingPerm.setMask(mask);
        existingPerm.setOrder(order);
        existingPerm.setCondition(condition);
    }

    public void setRowsBasedSecurity(String targetName, String condition, boolean constraint) {
        Permission existingPerm = this.getPermission(targetName);
        if (existingPerm == null) {
            existingPerm = new Permission(targetName, new Crud(null, null, null, null, null, null));
            existingPerm.setCanFilter(true);
            this.objectsToPermissionsMap.put(targetName, existingPerm);
        }
        existingPerm.setCondition(condition);
        existingPerm.setConstraint(constraint);
    }

    public List<String> getAllowedLanguages() {
        ArrayList<String> allowedLanguages = new ArrayList<String>(10);
        for (Permission perm : this.getPermissions()) {
            if (!perm.isAllowLanguage()) continue;
            allowedLanguages.add(perm.getTargetName());
        }
        return allowedLanguages;
    }

    public void addAllowedLanguage(String language) {
        Permission perm = new Permission(language, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        perm.setAllowLanguage(true);
        this.objectsToPermissionsMap.put(language, perm);
    }

    public void removeAllowedLanguage(String language) {
        this.objectsToPermissionsMap.remove(language);
    }
}

