/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.wizard.dialogs;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.roles.ui.Messages;
import org.teiid.designer.roles.ui.wizard.dialogs.AbstractAddOrEditTitleDialog;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Label;

public class ColumnMaskingDialog
extends AbstractAddOrEditTitleDialog {
    private String targetName;
    private Text targetNameText;
    private StyledTextEditor conditionTextEditor;
    private String conditionString;
    private StyledTextEditor maskTextEditor;
    private String maskString;
    private int order = 0;
    private Text orderText;
    private boolean isEdit;

    public ColumnMaskingDialog(Shell parentShell, String title, String message, Permission permission, boolean existingMask) {
        super(parentShell, Messages.columnMaskingDialogTitle, Messages.setConditionOrMaskingMessage, existingMask);
        this.targetName = permission.getTargetName();
        this.isEdit = true;
        if (permission.getCondition() != null) {
            this.conditionString = permission.getCondition();
        }
        if (permission.getMask() != null) {
            this.maskString = permission.getMask();
            this.order = permission.getOrder();
        }
    }

    @Override
    public void createCustomArea(Composite outerPanel) {
        Composite innerPanel = new Composite(outerPanel, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(innerPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)innerPanel);
        Label columnLabel = WidgetFactory.createLabel((Composite)innerPanel, (String)Messages.column);
        GridDataFactory.swtDefaults().align(2, 2).applyTo((Control)columnLabel);
        this.targetNameText = WidgetFactory.createTextField((Composite)innerPanel, (int)768, (int)1, (String)"");
        if (this.isEdit) {
            this.targetNameText.setText(this.targetName);
        }
        this.targetNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnMaskingDialog.this.handleInputChanged();
            }
        });
        this.targetNameText.setEditable(false);
        this.targetNameText.setBackground(innerPanel.getBackground());
        Group group = WidgetFactory.createGroup((Composite)innerPanel, (String)Messages.condition, (int)768, (int)2);
        this.conditionTextEditor = new StyledTextEditor((Composite)group, 2882);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.conditionTextEditor.getTextWidget());
        ((GridData)this.conditionTextEditor.getTextWidget().getLayoutData()).heightHint = 50;
        if (this.isEdit) {
            this.conditionTextEditor.setText(this.conditionString);
        } else {
            this.conditionTextEditor.setText("");
        }
        this.conditionTextEditor.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                ColumnMaskingDialog.this.handleInputChanged();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        WidgetFactory.createLabel((Composite)innerPanel, (String)Messages.order);
        this.orderText = WidgetFactory.createTextField((Composite)innerPanel, (int)768, (int)1, (String)"");
        if (this.isEdit) {
            this.orderText.setText(Integer.toString(this.order));
        } else {
            this.orderText.setText("0");
        }
        this.orderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnMaskingDialog.this.handleInputChanged();
            }
        });
        Group maskGroup = WidgetFactory.createGroup((Composite)innerPanel, (String)Messages.columnMasking, (int)768, (int)2);
        this.maskTextEditor = new StyledTextEditor((Composite)maskGroup, 2882);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.maskTextEditor.getTextWidget());
        ((GridData)this.maskTextEditor.getTextWidget().getLayoutData()).heightHint = 50;
        if (this.isEdit) {
            this.maskTextEditor.setText(this.maskString);
        } else {
            this.maskTextEditor.setText("");
        }
        this.maskTextEditor.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                ColumnMaskingDialog.this.handleInputChanged();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        this.orderText.setEnabled(true);
        this.maskTextEditor.getTextWidget().setEnabled(true);
    }

    public String getTargetName() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return this.targetName;
    }

    public String getCondition() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return this.conditionString;
    }

    public String getMask() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return this.maskString;
    }

    public int getOrder() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return this.order;
    }

    @Override
    protected void handleInputChanged() {
        this.validate();
    }

    public boolean hasCondition() {
        return this.getCondition() != null && !this.getCondition().isEmpty();
    }

    public boolean hasMask() {
        return this.getMask() != null && !this.getMask().isEmpty();
    }

    @Override
    protected void validate() {
        boolean maskEmpty;
        this.getButton(0).setEnabled(true);
        this.setErrorMessage(null);
        this.setMessage(Messages.clickOkToFinish);
        this.conditionString = this.conditionTextEditor.getText();
        this.maskString = this.maskTextEditor.getText();
        boolean conditionEmpty = this.conditionString == null || this.conditionString.trim().isEmpty();
        boolean bl = maskEmpty = this.maskString == null || this.maskString.trim().isEmpty();
        if (maskEmpty && conditionEmpty) {
            this.setErrorMessage(Messages.noMaskOrConditionDefined);
            this.getButton(0).setEnabled(false);
            return;
        }
        if (this.orderText.getText() != null) {
            try {
                this.order = Integer.parseInt(this.orderText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages.orderMustBeAnInteger);
                this.getButton(0).setEnabled(false);
                return;
            }
        } else {
            this.setErrorMessage(Messages.orderMustNotBeNull);
            this.getButton(0).setEnabled(false);
            return;
        }
        if (maskEmpty) {
            this.getButton(0).setEnabled(false);
            return;
        }
    }
}

