/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.wizard.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.roles.ui.Messages;
import org.teiid.designer.roles.ui.RolesUiPlugin;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.MessageLabel;

public class SelectObjectDialog
extends ElementTreeSelectionDialog
implements ISelectionChangedListener {
    private static final char DELIM = '.';
    private static final char B_SLASH = '/';
    private Text targetNameText;
    private String targetName;
    private MessageLabel statusMessageLabel;
    private Object input;
    private ILabelProvider labelProvider;
    private ITreeContentProvider contentProvider;

    public SelectObjectDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, Object input) {
        super(parent, labelProvider, contentProvider);
        this.labelProvider = labelProvider;
        this.contentProvider = contentProvider;
        this.input = input;
        this.setTitle(Messages.targetSelection);
        this.setMessage(Messages.selectTargetForCondition);
        this.setInput(input);
        this.setAllowMultiple(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData panelData = new GridData(1808);
        panel.setLayoutData((Object)panelData);
        Group selectedGroup = WidgetFactory.createGroup((Composite)panel, (String)"Selected Target", (int)768, (int)1, (int)2);
        this.targetNameText = WidgetFactory.createTextField((Composite)selectedGroup, (int)768, (String)Messages.undefined);
        GridData data = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(1);
        data.verticalAlignment = 2;
        this.targetNameText.setLayoutData((Object)data);
        this.targetNameText.setEditable(false);
        this.targetNameText.setBackground(panel.getBackground());
        this.targetNameText.setText(Messages.undefined);
        super.createDialogArea(panel);
        this.statusMessageLabel = new MessageLabel(panel);
        GridData statusData = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(1);
        this.statusMessageLabel.setLayoutData((Object)statusData);
        this.statusMessageLabel.setEnabled(false);
        this.statusMessageLabel.setText(Messages.undefined);
        this.getTreeViewer().expandToLevel(2);
        return panel;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = super.createTreeViewer(parent);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.getTree().setEnabled(true);
        viewer.setSorter(new ViewerSorter());
        viewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof EObject || element instanceof Resource;
            }
        }});
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.setInput(this.input);
        return viewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TreeSelection selection = (TreeSelection)event.getSelection();
        if (selection.isEmpty()) {
            this.targetNameText.setText(Messages.undefined);
            this.targetName = null;
            this.updateOnSelection(null);
            return;
        }
        Object firstElement = selection.getFirstElement();
        if (!(firstElement instanceof Table || firstElement instanceof View || firstElement instanceof Procedure)) {
            this.targetNameText.setText(Messages.undefined);
            this.targetName = null;
        } else {
            EObject target = (EObject)selection.getFirstElement();
            this.targetName = this.getFullName(target);
            this.targetNameText.setText(ModelerCore.getModelEditor().getName(target));
        }
        this.updateOnSelection(firstElement);
    }

    private String getFullName(EObject target) {
        String targetName = String.valueOf(this.getResourceName(target.eResource())) + '/' + ModelerCore.getModelEditor().getModelRelativePath(target);
        targetName = targetName.replace('/', '.');
        return targetName;
    }

    private String getResourceName(Resource res) {
        if (res.getURI().path().endsWith(".xmi")) {
            Path path = new Path(res.getURI().path());
            return path.removeFileExtension().lastSegment();
        }
        return res.getURI().path();
    }

    private void updateOnSelection(Object selectedObject) {
        Status status = new Status(1, RolesUiPlugin.PLUGIN_ID, "Valid column selected. Click OK to finish.");
        if (selectedObject != null) {
            if (!(selectedObject instanceof Column)) {
                status = new Status(4, RolesUiPlugin.PLUGIN_ID, "Selected object is not a column");
                this.getOkButton().setEnabled(false);
            } else {
                this.getOkButton().setEnabled(true);
            }
        } else {
            status = new Status(4, RolesUiPlugin.PLUGIN_ID, "No column selected");
            this.getOkButton().setEnabled(false);
        }
        this.statusMessageLabel.setErrorStatus((IStatus)status);
    }

    public String getColumnName() {
        return this.targetName;
    }
}

