/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.wizard.panels;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.roles.ui.Messages;
import org.teiid.designer.roles.ui.RolesUiPlugin;
import org.teiid.designer.roles.ui.wizard.DataRoleWizard;
import org.teiid.designer.roles.ui.wizard.PermissionTreeProvider;
import org.teiid.designer.roles.ui.wizard.dialogs.AbstractAddOrEditTitleDialog;
import org.teiid.designer.roles.ui.wizard.panels.DataRolePanel;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.common.widget.MessageLabel;

public class ColumnMaskingPanel
extends DataRolePanel {
    private static final char DELIM = '.';
    private static final char B_SLASH = '/';
    TableViewerBuilder tableBuilder;
    Button addButton;
    Button removeButton;
    Button editButton;
    PermissionTreeProvider permissionTreeProvider;

    public ColumnMaskingPanel(Composite parent, DataRoleWizard wizard) {
        super(parent, wizard);
    }

    @Override
    void createControl() {
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.getPrimaryPanel());
        GridDataFactory.fillDefaults().applyTo((Control)this.getPrimaryPanel());
        Composite thePanel = WidgetFactory.createPanel((Composite)this.getPrimaryPanel(), (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)thePanel);
        Text helpText = new Text(thePanel, 72);
        helpText.setBackground(thePanel.getBackground());
        helpText.setForeground(Display.getCurrent().getSystemColor(10));
        helpText.setText(Messages.columnMaskingHelpText);
        this.tableBuilder = new TableViewerBuilder(this.getPrimaryPanel(), 68352);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableBuilder.getTableViewer());
        this.tableBuilder.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                List<Permission> permissions = ColumnMaskingPanel.this.getWizard().getTreeProvider().getPermissionsWithColumnMasking();
                if (permissions.isEmpty()) {
                    return new Object[0];
                }
                return permissions.toArray(new Permission[0]);
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableBuilder.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Permission perm1 = (Permission)e1;
                Permission perm2 = (Permission)e2;
                return super.compare(viewer, (Object)perm1.getTargetName(), (Object)perm2.getTargetName());
            }
        });
        TableViewerColumn column = this.tableBuilder.createColumn(16384, 40, 100, true);
        column.getColumn().setText(String.valueOf(Messages.name) + this.getSpaces(70));
        column.setLabelProvider((CellLabelProvider)new PermissionLabelProvider(0));
        column = this.tableBuilder.createColumn(16384, 20, 100, true);
        column.getColumn().setText(String.valueOf(Messages.condition) + this.getSpaces(70));
        column.setLabelProvider((CellLabelProvider)new PermissionLabelProvider(1));
        column = this.tableBuilder.createColumn(16384, 20, 100, true);
        column.getColumn().setText(Messages.order);
        column.setLabelProvider((CellLabelProvider)new PermissionLabelProvider(2));
        column.setEditingSupport((EditingSupport)new OrderEditingSupport((ColumnViewer)this.tableBuilder.getTableViewer()));
        column = this.tableBuilder.createColumn(16384, 20, 100, true);
        column.getColumn().setText(Messages.mask);
        column.setLabelProvider((CellLabelProvider)new PermissionLabelProvider(3));
        this.tableBuilder.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enable = !ColumnMaskingPanel.this.tableBuilder.getSelection().isEmpty();
                ColumnMaskingPanel.this.editButton.setEnabled(enable);
                ColumnMaskingPanel.this.removeButton.setEnabled(enable);
            }
        });
        this.tableBuilder.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ColumnMaskingPanel.this.handleEdit();
            }
        });
        Composite toolbarPanel = WidgetFactory.createPanel((Composite)this.getPrimaryPanel(), (int)0, (int)2, (int)1, (int)3);
        this.addButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.addButton.setText(Messages.add);
        this.addButton.setToolTipText(Messages.addRowBasedSecurityTooltip);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMaskingPanel.this.handleAdd();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.editButton.setText(Messages.edit);
        this.editButton.setToolTipText(Messages.editRowBasedSecurityTooltip);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMaskingPanel.this.handleEdit();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.removeButton.setText(Messages.remove);
        this.removeButton.setToolTipText(Messages.removeRowBasedSecurityTooltip);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMaskingPanel.this.handleRemove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton.setEnabled(false);
    }

    void handleAdd() {
        ColumnMaskDialog dialog = new ColumnMaskDialog(this.getPrimaryPanel().getShell(), Messages.addColumnMaskTitle, Messages.addColumnMaskMessage, null, false);
        if (dialog.open() == 0) {
            String condition = dialog.getCondition();
            String mask = dialog.getMask();
            int order = dialog.getOrder();
            String targetName = dialog.getTargetName();
            this.getWizard().getTreeProvider().setColumnMask(targetName, condition, mask, order);
            this.getWizard().refreshAllTabs();
        }
    }

    void handleEdit() {
        Permission permission = this.getSelectedPermission();
        ColumnMaskDialog dialog = new ColumnMaskDialog(this.getPrimaryPanel().getShell(), Messages.editColumnMaskTitle, Messages.editColumnMaskMessage, permission, true);
        if (dialog.open() == 0) {
            String mask = dialog.getMask();
            int order = dialog.getOrder();
            String condition = dialog.getCondition();
            String targetName = dialog.getTargetName();
            this.getWizard().getTreeProvider().setColumnMask(targetName, condition, mask, order);
            this.getWizard().refreshAllTabs();
        }
    }

    void handleRemove() {
        Permission selection = this.getSelectedPermission();
        assert (selection != null);
        this.getWizard().getTreeProvider().removeColumnMask(selection);
        this.getWizard().getTreeProvider().handlePermissionChanged(selection);
        this.getWizard().refreshAllTabs();
    }

    private Permission getSelectedPermission() {
        IStructuredSelection selection = (IStructuredSelection)this.tableBuilder.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (Permission)selection.getFirstElement();
    }

    @Override
    public void refresh() {
        this.tableBuilder.getTable().removeAll();
        for (Permission perm : this.getWizard().getTreeProvider().getPermissionsWithColumnMasking()) {
            this.tableBuilder.add((Object)perm);
        }
        if (this.tableBuilder.getSelection().isEmpty()) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void handleInfoChanged() {
        this.refresh();
    }

    protected PermissionTreeProvider getPermissionTreeProvider() {
        if (this.permissionTreeProvider == null) {
            this.permissionTreeProvider = new PermissionTreeProvider();
        }
        return this.permissionTreeProvider;
    }

    class ColumnMaskDialog
    extends AbstractAddOrEditTitleDialog {
        private String targetColumn;
        private Text targetColumnText;
        private StyledTextEditor conditionTextEditor;
        private String conditionString;
        private StyledTextEditor textEditor;
        private String maskString;
        private int order;
        private Text orderText;
        private boolean isEdit;

        public ColumnMaskDialog(Shell parentShell, String title, String message, Permission permission, boolean okEnabled) {
            super(parentShell, title, message, okEnabled);
            this.order = 0;
            if (permission != null && (permission.getMask() != null || permission.getCondition() != null)) {
                this.maskString = permission.getMask();
                this.isEdit = true;
                this.order = permission.getOrder();
                this.targetColumn = permission.getTargetName();
                this.conditionString = permission.getCondition();
            }
        }

        @Override
        public void createCustomArea(Composite outerPanel) {
            Composite innerPanel = new Composite(outerPanel, 0);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(innerPanel);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)innerPanel);
            Label theLabel = WidgetFactory.createLabel((Composite)innerPanel, (String)Messages.targetColumn);
            GridDataFactory.fillDefaults().align(1, 2).applyTo((Control)theLabel);
            this.targetColumnText = WidgetFactory.createTextField((Composite)innerPanel, (int)768, (int)1, (String)"");
            if (this.isEdit) {
                this.targetColumnText.setText(this.targetColumn);
            }
            this.targetColumnText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ColumnMaskDialog.this.handleInputChanged();
                }
            });
            this.targetColumnText.setEditable(false);
            this.targetColumnText.setBackground(innerPanel.getBackground());
            Button button = new Button(innerPanel, 8);
            button.setText(Messages.dotDotDot);
            button.setToolTipText(Messages.browseVdbForTargetColumn);
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ColumnMaskDialog.this.handleBrowseForColumn();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Group group = WidgetFactory.createGroup((Composite)innerPanel, (String)Messages.condition, (int)768, (int)3);
            this.conditionTextEditor = new StyledTextEditor((Composite)group, 2882);
            GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.conditionTextEditor.getTextWidget());
            ((GridData)this.conditionTextEditor.getTextWidget().getLayoutData()).heightHint = 50;
            if (this.isEdit) {
                this.conditionTextEditor.setText(this.conditionString);
            } else {
                this.conditionTextEditor.setText("");
            }
            this.conditionTextEditor.getDocument().addDocumentListener(new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    ColumnMaskDialog.this.handleInputChanged();
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }
            });
            Label label = WidgetFactory.createLabel((Composite)innerPanel, (String)Messages.order);
            label.setToolTipText(Messages.orderTooltip);
            GridDataFactory.fillDefaults().align(1, 2).applyTo((Control)label);
            this.orderText = WidgetFactory.createTextField((Composite)innerPanel, (int)768, (int)2, (String)"");
            if (this.isEdit) {
                this.orderText.setText(Integer.toString(this.order));
            } else {
                this.orderText.setText("0");
            }
            this.orderText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ColumnMaskDialog.this.handleInputChanged();
                }
            });
            Group maskGroup = WidgetFactory.createGroup((Composite)outerPanel, (String)Messages.columnExpression, (int)768, (int)1);
            this.textEditor = new StyledTextEditor((Composite)maskGroup, 2882);
            GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)this.textEditor.getTextWidget());
            ((GridData)this.textEditor.getTextWidget().getLayoutData()).heightHint = 50;
            if (this.isEdit) {
                this.textEditor.setText(this.maskString);
            } else {
                this.textEditor.setText("");
            }
            this.textEditor.getDocument().addDocumentListener(new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    ColumnMaskDialog.this.handleInputChanged();
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }
            });
            Composite thePanel = WidgetFactory.createPanel((Composite)outerPanel, (int)0, (int)1, (int)1);
            GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)thePanel);
            Text helpText = new Text(thePanel, 72);
            helpText.setBackground(thePanel.getBackground());
            helpText.setForeground(Display.getCurrent().getSystemColor(10));
            helpText.setText(Messages.columnExpressionHelpText);
        }

        public String getTargetName() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.targetColumn;
        }

        public String getMask() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.maskString;
        }

        public int getOrder() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.order;
        }

        public String getCondition() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.conditionString;
        }

        private void handleBrowseForColumn() {
            SelectColumnDialog dialog = new SelectColumnDialog(this.getShell());
            if (dialog.open() == 0) {
                this.targetColumn = dialog.getColumnName();
                this.targetColumnText.setText(this.targetColumn);
                this.handleInputChanged();
            }
        }

        @Override
        protected void handleInputChanged() {
            this.validate();
        }

        @Override
        protected void validate() {
            boolean maskEmpty;
            boolean enable = true;
            this.setErrorMessage(null);
            this.setMessage(Messages.clickOkToFinish);
            this.maskString = this.textEditor.getText();
            this.targetColumn = this.targetColumnText.getText();
            this.conditionString = this.conditionTextEditor.getText();
            boolean conditionEmpty = this.conditionString == null || this.conditionString.trim().isEmpty();
            boolean bl = maskEmpty = this.maskString == null || this.maskString.trim().isEmpty();
            if (this.targetColumn == null || this.targetColumn.trim().isEmpty()) {
                enable = false;
                this.setErrorMessage(Messages.targetColumnUndefined);
                this.getButton(0).setEnabled(enable);
                return;
            }
            if (maskEmpty && conditionEmpty) {
                enable = false;
                this.setErrorMessage(Messages.noMaskOrConditionDefined);
                this.getButton(0).setEnabled(enable);
                return;
            }
            if (this.orderText.getText() != null) {
                try {
                    this.order = Integer.parseInt(this.orderText.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    enable = false;
                    this.setErrorMessage(Messages.orderMustBeAnInteger);
                    this.getButton(0).setEnabled(enable);
                    return;
                }
            } else {
                enable = false;
                this.setErrorMessage(Messages.orderMustNotBeNull);
                this.getButton(0).setEnabled(enable);
                return;
            }
            if (maskEmpty) {
                enable = false;
                this.setErrorMessage(Messages.maskIsUndefined);
                this.getButton(0).setEnabled(enable);
                return;
            }
            this.getButton(0).setEnabled(enable);
        }
    }

    class MaskEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public MaskEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof Permission) {
                return ((Permission)element).getMask();
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof Permission) {
                String oldValue = ((Permission)element).getMask();
                String newValue = (String)value;
                if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                    ((Permission)element).setMask(newValue);
                    ColumnMaskingPanel.this.tableBuilder.getTableViewer().refresh(element);
                    ColumnMaskingPanel.this.handleInfoChanged();
                }
            }
        }
    }

    class OrderEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public OrderEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof Permission) {
                return Integer.toString(((Permission)element).getOrder());
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof Permission) {
                int oldValue;
                int newValue = oldValue = ((Permission)element).getOrder();
                try {
                    newValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (newValue != oldValue) {
                    ((Permission)element).setOrder(newValue);
                    ColumnMaskingPanel.this.tableBuilder.getTableViewer().refresh(element);
                }
            }
        }
    }

    class PermissionLabelProvider
    extends ColumnLabelProvider {
        private final int columnID;

        public PermissionLabelProvider(int columnID) {
            this.columnID = columnID;
        }

        public String getText(Object element) {
            if (element instanceof Permission) {
                if (this.columnID == 0) {
                    return ((Permission)element).getTargetName();
                }
                if (this.columnID == 3) {
                    return ((Permission)element).getMask();
                }
                if (this.columnID == 2) {
                    return Integer.toString(((Permission)element).getOrder());
                }
                if (this.columnID == 1) {
                    return ((Permission)element).getCondition();
                }
            }
            return super.getText(element);
        }
    }

    class SelectColumnDialog
    extends ElementTreeSelectionDialog
    implements ISelectionChangedListener {
        private Text columnNameText;
        private String columnName;
        private MessageLabel statusMessageLabel;

        public SelectColumnDialog(Shell parent) {
            super(parent, (ILabelProvider)ColumnMaskingPanel.this.getPermissionTreeProvider(), (ITreeContentProvider)ColumnMaskingPanel.this.getPermissionTreeProvider());
            this.setTitle(Messages.targetSelection);
            this.setMessage(Messages.selectTargetColumn);
            this.setInput(ColumnMaskingPanel.this.getWizard().getTempContainer());
            this.setAllowMultiple(false);
        }

        protected Control createDialogArea(Composite parent) {
            Composite panel = new Composite(parent, 0);
            panel.setLayout((Layout)new GridLayout());
            GridData panelData = new GridData(1808);
            panel.setLayoutData((Object)panelData);
            Group selectedGroup = WidgetFactory.createGroup((Composite)panel, (String)Messages.selectedColumn, (int)768, (int)1, (int)2);
            this.columnNameText = WidgetFactory.createTextField((Composite)selectedGroup, (int)768, (String)Messages.undefined);
            GridData data = new GridData(768);
            data.heightHint = this.convertHeightInCharsToPixels(1);
            this.columnNameText.setLayoutData((Object)data);
            this.columnNameText.setEditable(false);
            this.columnNameText.setBackground(panel.getBackground());
            this.columnNameText.setText(Messages.undefined);
            super.createDialogArea(panel);
            this.statusMessageLabel = new MessageLabel(panel);
            GridData statusData = new GridData(768);
            data.heightHint = this.convertHeightInCharsToPixels(1);
            this.statusMessageLabel.setLayoutData((Object)statusData);
            this.statusMessageLabel.setEnabled(false);
            this.statusMessageLabel.setText(Messages.undefined);
            this.getTreeViewer().expandToLevel(2);
            return panel;
        }

        protected TreeViewer createTreeViewer(Composite parent) {
            TreeViewer viewer = super.createTreeViewer(parent);
            viewer.addSelectionChangedListener((ISelectionChangedListener)this);
            viewer.getTree().setEnabled(true);
            viewer.setSorter(new ViewerSorter());
            viewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof EObject || element instanceof Resource;
                }
            }});
            viewer.setContentProvider((IContentProvider)ColumnMaskingPanel.this.getPermissionTreeProvider());
            viewer.setLabelProvider((IBaseLabelProvider)ColumnMaskingPanel.this.getPermissionTreeProvider());
            viewer.setInput((Object)ColumnMaskingPanel.this.getWizard().getTempContainer());
            return viewer;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TreeSelection selection = (TreeSelection)event.getSelection();
            if (selection.isEmpty()) {
                this.columnNameText.setText(Messages.undefined);
                this.columnName = null;
                this.updateOnSelection(null);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (!(firstElement instanceof Column)) {
                this.columnNameText.setText(Messages.undefined);
                this.columnName = null;
            } else {
                Column column = (Column)selection.getFirstElement();
                this.columnName = this.getFullColumnName(column);
                this.columnNameText.setText(column.getName());
            }
            this.updateOnSelection(firstElement);
        }

        private String getFullColumnName(Column column) {
            String targetName = String.valueOf(this.getResourceName(column.eResource())) + '/' + ModelerCore.getModelEditor().getModelRelativePath((EObject)column);
            targetName = targetName.replace('/', '.');
            return targetName;
        }

        private String getResourceName(Resource res) {
            if (res.getURI().path().endsWith(".xmi")) {
                Path path = new Path(res.getURI().path());
                return path.removeFileExtension().lastSegment();
            }
            return res.getURI().path();
        }

        private void updateOnSelection(Object selectedObject) {
            Status status = new Status(1, RolesUiPlugin.PLUGIN_ID, Messages.columnMaskingOkMessage);
            if (selectedObject != null) {
                if (!(selectedObject instanceof Column)) {
                    status = new Status(4, RolesUiPlugin.PLUGIN_ID, Messages.invalidSelectionColumnMaskingMessage);
                    this.getOkButton().setEnabled(false);
                } else {
                    this.getOkButton().setEnabled(true);
                }
            } else {
                status = new Status(4, RolesUiPlugin.PLUGIN_ID, Messages.noColumnSelected);
                this.getOkButton().setEnabled(false);
            }
            this.statusMessageLabel.setErrorStatus((IStatus)status);
        }

        public String getColumnName() {
            return this.columnName;
        }
    }
}

