/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.wizard.panels;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.teiid.designer.roles.Crud;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.roles.ui.Messages;
import org.teiid.designer.roles.ui.wizard.DataRoleWizard;
import org.teiid.designer.roles.ui.wizard.dialogs.ColumnMaskingDialog;
import org.teiid.designer.roles.ui.wizard.dialogs.RowBasedSecurityDialog;
import org.teiid.designer.roles.ui.wizard.panels.DataRolePanel;
import org.teiid.designer.ui.UiPlugin;

public class CrudPanel
extends DataRolePanel {
    private TreeViewer treeViewer;

    public CrudPanel(Composite parent, DataRoleWizard wizard) {
        super(parent, wizard);
    }

    @Override
    void createControl() {
        this.treeViewer = new TreeViewer(this.getPrimaryPanel(), 66306);
        Tree tree = this.treeViewer.getTree();
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        this.treeViewer.getControl().setLayoutData((Object)gridData);
        tree.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Point pt = new Point(e.x, e.y);
                if (CrudPanel.this.treeViewer.getCell(pt) != null && CrudPanel.this.treeViewer.getCell(pt).getViewerRow() != null && CrudPanel.this.treeViewer.getCell(pt).getViewerRow().getItem() != null) {
                    CrudPanel.this.handleSelection(CrudPanel.this.treeViewer.getCell(pt).getColumnIndex(), CrudPanel.this.treeViewer.getCell(pt).getViewerRow().getItem().getData());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                Point pt = new Point(e.x, e.y);
                if (CrudPanel.this.treeViewer.getCell(pt) != null && CrudPanel.this.treeViewer.getCell(pt).getViewerRow() != null && CrudPanel.this.treeViewer.getCell(pt).getViewerRow().getItem() != null) {
                    CrudPanel.this.handleDoubleClick(CrudPanel.this.treeViewer.getCell(pt).getColumnIndex(), CrudPanel.this.treeViewer.getCell(pt).getViewerRow().getItem().getData());
                }
            }
        });
        this.treeViewer.setUseHashlookup(true);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn treeColumn = new TreeColumn(tree, 16384);
        treeColumn.setText(Messages.model);
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewer, 16384);
        treeViewerColumn.getColumn().setText(Messages.security);
        treeViewerColumn.getColumn().setToolTipText(Messages.securityTooltip);
        treeViewerColumn = new TreeViewerColumn(this.treeViewer, 16416);
        treeViewerColumn.getColumn().setText(Messages.create);
        treeViewerColumn = new TreeViewerColumn(this.treeViewer, 16416);
        treeViewerColumn.getColumn().setText(Messages.read);
        treeViewerColumn = new TreeViewerColumn(this.treeViewer, 16416);
        treeViewerColumn.getColumn().setText(Messages.update);
        treeViewerColumn = new TreeViewerColumn(this.treeViewer, 16416);
        treeViewerColumn.getColumn().setText(Messages.delete);
        treeViewerColumn = new TreeViewerColumn(this.treeViewer, 16416);
        treeViewerColumn.getColumn().setText(Messages.execute);
        treeViewerColumn = new TreeViewerColumn(this.treeViewer, 16416);
        treeViewerColumn.getColumn().setText(Messages.alter);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(8));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(11));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(8));
        tree.setLayout((Layout)layout);
        this.treeViewer.setContentProvider((IContentProvider)this.getTreeProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.getTreeProvider());
        this.treeViewer.setInput((Object)this.getWizard().getTempContainer());
    }

    private void handleSelection(int column, Object rowData) {
        if (column > 1) {
            Crud.Type crudType = Crud.getCrudType((int)column);
            boolean doToggle = true;
            IStatus toggleStatus = this.getTreeProvider().getToggleStatus(rowData, crudType);
            String autoToggle = UiPlugin.getDefault().getPreferenceStore().getString("autoWillToggleChildren");
            if (!"always".equals(autoToggle)) {
                if (toggleStatus.getSeverity() == 1) {
                    doToggle = false;
                    MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)Messages.state_change_info, (String)toggleStatus.getMessage(), (String)Messages.alwaysToggleAllChildrenMessage, (boolean)false, (IPreferenceStore)UiPlugin.getDefault().getPreferenceStore(), (String)"autoWillToggleChildren");
                } else if (toggleStatus.getSeverity() == 2) {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)Messages.confirm_state_change, (String)toggleStatus.getMessage(), (String)Messages.alwaysToggleAllChildrenMessage, (boolean)false, (IPreferenceStore)UiPlugin.getDefault().getPreferenceStore(), (String)"autoWillToggleChildren");
                    boolean bl = doToggle = dialog.getReturnCode() == 0;
                }
            }
            if (doToggle) {
                this.getTreeProvider().togglePermission(rowData, crudType);
            }
            this.treeViewer.refresh();
            this.validateInputs();
        }
    }

    private void handleDoubleClick(int column, Object target) {
        if (column == 1) {
            if (this.getTreeProvider().allowsRowFilter(target)) {
                boolean existingPerm;
                Permission perm = this.getTreeProvider().getPermission(target);
                boolean bl = existingPerm = perm != null;
                if (perm == null) {
                    perm = this.getTreeProvider().createPermission(target);
                }
                String message = this.getTreeProvider().getSecurityDialogMessage(target);
                RowBasedSecurityDialog dialog = new RowBasedSecurityDialog(this.getShell(), Messages.setSecurityValuesTitle, message, perm, existingPerm);
                if (dialog.open() == 0) {
                    if (dialog.hasCondition()) {
                        perm.setCondition(dialog.getCondition());
                        perm.setConstraint(dialog.getConstraintValue());
                    }
                    this.getWizard().refreshAllTabs();
                    this.validateInputs();
                }
            } else if (this.getTreeProvider().allowsColumnMask(target)) {
                boolean existingPerm;
                Permission perm = this.getTreeProvider().getPermission(target);
                boolean bl = existingPerm = perm != null;
                if (perm == null) {
                    perm = this.getTreeProvider().createPermission(target);
                }
                String message = this.getTreeProvider().getSecurityDialogMessage(target);
                ColumnMaskingDialog dialog = new ColumnMaskingDialog(this.getShell(), Messages.setSecurityValuesTitle, message, perm, existingPerm);
                if (dialog.open() == 0) {
                    if (dialog.hasCondition()) {
                        perm.setCondition(dialog.getCondition());
                    }
                    if (dialog.hasMask()) {
                        perm.setMask(dialog.getMask());
                        perm.setOrder(dialog.getOrder());
                    }
                    this.getWizard().refreshAllTabs();
                    this.validateInputs();
                }
            }
        }
    }

    @Override
    public void refresh() {
        this.treeViewer.refresh();
    }
}

