/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.ui.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.teiid.designer.compare.DifferenceDescriptor;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.DifferenceType;
import org.teiid.designer.compare.ui.PluginConstants;
import org.teiid.designer.compare.ui.UiConstants;
import org.teiid.designer.compare.ui.UiPlugin;
import org.teiid.designer.compare.ui.tree.DifferenceAnalysis;
import org.teiid.designer.compare.ui.tree.MappingLabelDecorator;
import org.teiid.designer.compare.ui.tree.MappingTreeContentProvider;
import org.teiid.designer.compare.ui.tree.PrimaryMetamodelObjectViewerFilter;
import org.teiid.designer.ui.common.graphics.GlobalUiFontManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.DefaultTreeViewerController;
import org.teiid.designer.ui.common.widget.ITreeViewerController;
import org.teiid.designer.ui.common.widget.Label;

public class CompareTreePanel
implements UiConstants,
PluginConstants {
    private Tree tree;
    private TreeViewer treeViewer;
    private List<DifferenceReport> diffReports;
    private boolean bDisplayOnlyPrimaryMetamodelObjects = false;
    private String title;
    private boolean updateMapping = true;
    private CompareTreeController controller;
    private boolean showCheckBoxes;
    private ITreeContentProvider contentProvider;
    private PrimaryMetamodelObjectViewerFilter pmofViewerFilter;
    private int iAdditions;
    private int iChanges;
    private int iDeletions;
    private ArrayList<TreeItem> arylTreeItemDepthFirstList;
    private TreeItem tiCurrentSelection;
    private boolean bUpdatingSelection = false;
    Button upButton;
    Button downButton;
    Button selectAllButton;
    Button deselectAllButton;
    private Composite parent;
    private static final String SELECT_ALL_TEXT = UiConstants.Util.getString("CompareTreePanel.selectAll.text", new Object[0]);
    private static final String SELECT_ALL_TIP = UiConstants.Util.getString("CompareTreePanel.selectAll.tip", new Object[0]);
    private static final String UNSELECT_ALL_TEXT = UiConstants.Util.getString("CompareTreePanel.unselectAll.text", new Object[0]);
    private static final String UNSELECT_ALL_TIP = UiConstants.Util.getString("CompareTreePanel.unselectAll.tip", new Object[0]);
    private static final String NEXT_NAV_TIP = UiConstants.Util.getString("CompareTreePanel.nextNav.tip", new Object[0]);
    private static final String PREV_NAV_TIP = UiConstants.Util.getString("CompareTreePanel.prevNav.tip", new Object[0]);
    private static final String GO_TO_NEXT_TITLE = UiConstants.Util.getString("CompareTreePanel.goToNext.title", new Object[0]);
    private static final String END_OF_DOC_MSG = UiConstants.Util.getString("CompareTreePanel.endOfDoc.msg", new Object[0]);
    private static final String BEGINNING_OF_DOC_MSG = UiConstants.Util.getString("CompareTreePanel.beginningOfDoc.msg", new Object[0]);

    public CompareTreePanel(Composite parent, String title, List<DifferenceReport> diffReports, boolean showCheckBoxes, int terminology) {
        this(parent, title, showCheckBoxes, false, terminology);
        this.setDifferenceReports(diffReports);
    }

    public CompareTreePanel(Composite parent, String title, List<DifferenceReport> diffReports, int terminology) {
        this(parent, title, true, false, terminology);
        this.setDifferenceReports(diffReports);
    }

    public CompareTreePanel(Composite parent, String title, DifferenceReport diffReport, int terminology) {
        this(parent, title, Collections.singletonList(diffReport), terminology);
    }

    public CompareTreePanel(Composite theParent, String theTitle, boolean showCheckBoxes, boolean bDisplayOnlyPrimaryMetamodelObjects, int terminology) {
        this.parent = theParent;
        this.title = theTitle;
        this.showCheckBoxes = showCheckBoxes;
        this.bDisplayOnlyPrimaryMetamodelObjects = bDisplayOnlyPrimaryMetamodelObjects;
        this.initialize(terminology);
    }

    public void clearSelection() {
        this.tree.deselectAll();
    }

    public void selectAll() {
        this.tree.selectAll();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void initialize(int terminology) {
        ILabelDecorator decorator;
        if (this.title != null && this.title.trim().length() > 0) {
            Label lblTitle = WidgetFactory.createLabel((Composite)this.parent, (String)this.title);
            Font fOld = lblTitle.getFont();
            FontData data = fOld.getFontData()[0];
            data.setStyle(1);
            Font fNewFont = GlobalUiFontManager.getFont((FontData)data);
            lblTitle.setFont(fNewFont);
        }
        this.createToolBar();
        this.controller = new CompareTreeController();
        this.treeViewer = this.showCheckBoxes ? WidgetFactory.createTreeViewer((Composite)this.parent, (int)804, (int)1808, (ITreeViewerController)this.controller) : WidgetFactory.createTreeViewer((Composite)this.parent, (int)772, (int)1808, (ITreeViewerController)this.controller);
        this.tree = this.treeViewer.getTree();
        this.treeViewer.getTree().setVisible(true);
        GridData treeGD = new GridData(1808);
        treeGD.heightHint = 140;
        this.tree.setLayoutData((Object)treeGD);
        this.contentProvider = new MappingTreeContentProvider();
        if (this.diffReports != null && this.diffReports.get(0) != null) {
            ((MappingTreeContentProvider)this.contentProvider).setDifferenceReports(this.diffReports);
        }
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        ILabelProvider labelProvider = DifferenceAnalysis.getMappingDecoratingLabelProvider(terminology);
        if (labelProvider instanceof DecoratingLabelProvider && (decorator = ((DecoratingLabelProvider)labelProvider).getLabelDecorator()) instanceof MappingLabelDecorator) {
            ((MappingLabelDecorator)decorator).setMappingTreeContentProvider((MappingTreeContentProvider)this.contentProvider);
        }
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        if (this.bDisplayOnlyPrimaryMetamodelObjects) {
            this.pmofViewerFilter = new PrimaryMetamodelObjectViewerFilter();
            this.treeViewer.addFilter((ViewerFilter)this.pmofViewerFilter);
        }
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                CompareTreePanel.this.handleTreeNodeSelection();
            }
        });
    }

    public void selectFirstDiff() {
        TreeItem tiFirst = this.getNextDiffItem(null);
        if (tiFirst != null) {
            TreeItem[] tiArray = new TreeItem[]{tiFirst};
            this.getTreeViewer().reveal((Object)tiFirst);
            this.forceTreeSelection(tiArray);
            this.setCurrentTreeItem(tiFirst);
        }
    }

    protected void createToolBar() {
        Composite buttonPanel = WidgetFactory.createPanel((Composite)this.parent);
        buttonPanel.setLayout((Layout)new GridLayout(4, false));
        this.upButton = new Button(buttonPanel, 8);
        this.upButton.setImage(UiPlugin.getDefault().getImage("icons/full/ctool16/next_nav.gif"));
        this.upButton.setToolTipText(NEXT_NAV_TIP);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompareTreePanel.this.handleUpArrow();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.downButton = new Button(buttonPanel, 8);
        this.downButton.setImage(UiPlugin.getDefault().getImage("icons/full/ctool16/prev_nav.gif"));
        this.downButton.setToolTipText(PREV_NAV_TIP);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompareTreePanel.this.handleDownArrow();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.selectAllButton = new Button(buttonPanel, 8);
        this.selectAllButton.setText(SELECT_ALL_TEXT);
        this.selectAllButton.setToolTipText(SELECT_ALL_TIP);
        this.selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompareTreePanel.this.handleSelectAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.deselectAllButton = new Button(buttonPanel, 8);
        this.deselectAllButton.setText(UNSELECT_ALL_TEXT);
        this.deselectAllButton.setToolTipText(UNSELECT_ALL_TIP);
        this.deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompareTreePanel.this.handleUnselectAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    void handleSelectAll() {
        this.setAllNodesSelected(true);
    }

    void handleUnselectAll() {
        this.setAllNodesSelected(false);
    }

    public void setDifferenceReports(List<DifferenceReport> theDifferenceReports) {
        this.diffReports = theDifferenceReports;
        if (this.contentProvider != null) {
            ((MappingTreeContentProvider)this.contentProvider).setDifferenceReports(this.diffReports);
        }
        this.treeViewer.setInput(this.diffReports);
        this.initTreeSelections();
        this.generateStats();
        if (this.getAdditionCount() == 0 && this.getChangeCount() == 0 && this.getDeletionCount() == 0) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public void initTreeSelections() {
        this.arylTreeItemDepthFirstList = new ArrayList();
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            this.selectItemAndChildren(items[i]);
            ++i;
        }
    }

    public void generateStats() {
        this.iAdditions = 0;
        this.iChanges = 0;
        this.iDeletions = 0;
        this.getTreeViewer().expandAll();
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            this.calculateCounts(items[i]);
            ++i;
        }
        this.getTreeViewer().collapseAll();
    }

    private void calculateCounts(TreeItem item) {
        DifferenceDescriptor desc;
        Mapping mapping;
        Object data = item.getData();
        if (data != null && data instanceof DifferenceReport) {
            mapping = ((DifferenceReport)data).getMapping();
            if (mapping == null) {
                return;
            }
            if ((this.pmofViewerFilter == null || this.pmofViewerFilter.passesFilter(mapping)) && (desc = DifferenceAnalysis.getDifferenceDescriptor(mapping)) != null) {
                if (desc.isAddition()) {
                    ++this.iAdditions;
                } else if (desc.isChanged()) {
                    ++this.iChanges;
                } else if (desc.isDeletion()) {
                    ++this.iDeletions;
                }
            }
        } else if (data != null && data instanceof Mapping && (desc = DifferenceAnalysis.getDifferenceDescriptor(mapping = (Mapping)data)) != null) {
            if (desc.isAddition()) {
                ++this.iAdditions;
            } else if (desc.isChanged()) {
                ++this.iChanges;
            } else if (desc.isDeletion()) {
                ++this.iDeletions;
            }
        }
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            this.calculateCounts(children[i]);
            ++i;
        }
    }

    public boolean isUpdatingMappingSkipFlag() {
        return this.updateMapping;
    }

    private void selectItemAndChildren(TreeItem item) {
        boolean skip;
        DifferenceDescriptor desc;
        Mapping mapping;
        this.arylTreeItemDepthFirstList.add(item);
        Object data = item.getData();
        if (data != null && data instanceof DifferenceReport) {
            mapping = ((DifferenceReport)data).getMapping();
            if (mapping == null) {
                return;
            }
            desc = DifferenceAnalysis.getDifferenceDescriptor(mapping);
            if (desc != null) {
                skip = desc.isSkip();
                WidgetUtil.setChecked((TreeItem)item, (!skip ? 1 : 0) != 0, (boolean)false, (ITreeViewerController)this.controller);
            }
            if (!this.controller.isItemCheckable(item)) {
                item.setGrayed(true);
                this.controller.update(item, false);
            }
        } else if (data != null && data instanceof Mapping) {
            mapping = (Mapping)data;
            desc = DifferenceAnalysis.getDifferenceDescriptor(mapping);
            if (desc != null) {
                skip = desc.isSkip();
                WidgetUtil.setChecked((TreeItem)item, (!skip ? 1 : 0) != 0, (boolean)false, (ITreeViewerController)this.controller);
            }
            if (!this.controller.isItemCheckable(item)) {
                item.setGrayed(true);
                this.controller.update(item, false);
            }
        }
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            this.selectItemAndChildren(children[i]);
            ++i;
        }
    }

    private void setAllNodesSelected(boolean bSelected) {
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            this.setAllSelected(items[i], bSelected);
            ++i;
        }
    }

    private void setAllSelected(TreeItem item, boolean checked) {
        Mapping mapping;
        Object data = item.getData();
        if (data instanceof DifferenceReport) {
            mapping = ((DifferenceReport)data).getMapping();
        } else if (data instanceof Mapping) {
            mapping = (Mapping)data;
        } else {
            return;
        }
        DifferenceDescriptor desc = DifferenceAnalysis.getDifferenceDescriptor(mapping);
        if (desc != null) {
            WidgetUtil.setChecked((TreeItem)item, (boolean)checked, (boolean)false, (ITreeViewerController)this.controller);
        }
        if (!this.controller.isItemCheckable(item)) {
            item.setGrayed(true);
            this.controller.update(item, false);
        }
        TreeItem[] children = item.getItems();
        int ndx = 0;
        while (ndx < children.length) {
            this.setAllSelected(children[ndx], checked);
            ++ndx;
        }
    }

    public void setUpdateMappingSkipFlag(boolean theUpdateMappingFlag) {
        this.updateMapping = theUpdateMappingFlag;
    }

    public int getAdditionCount() {
        return this.iAdditions;
    }

    public int getChangeCount() {
        return this.iChanges;
    }

    public int getDeletionCount() {
        return this.iDeletions;
    }

    public EObject getEObjectForMapping(Mapping mapping) {
        EObject eoResult = null;
        MappingHelper helper = mapping.getHelper();
        if (helper instanceof DifferenceDescriptor) {
            DifferenceDescriptor desc = (DifferenceDescriptor)helper;
            DifferenceType type = desc.getType();
            if (type.getValue() == 2) {
                EObject input;
                EList inputs = mapping.getInputs();
                EObject eObject = input = inputs.isEmpty() ? null : (EObject)inputs.get(0);
                if (input != null) {
                    eoResult = input;
                }
            } else {
                EObject input;
                EList outputs = mapping.getOutputs();
                EObject output = outputs.isEmpty() ? null : (EObject)outputs.get(0);
                EList inputs = mapping.getInputs();
                EObject eObject = input = inputs.isEmpty() ? null : (EObject)inputs.get(0);
                if (output != null) {
                    eoResult = output;
                } else if (input != null) {
                    eoResult = input;
                }
            }
        }
        return eoResult;
    }

    void handleTreeNodeSelection() {
        if (this.bUpdatingSelection) {
            return;
        }
        TreeItem[] tiSelectedTreeItems = this.tree.getSelection();
        if (tiSelectedTreeItems != null && tiSelectedTreeItems.length > 0) {
            TreeItem ti = tiSelectedTreeItems[0];
            this.setCurrentTreeItem(ti);
        }
    }

    void handleUpArrow() {
        this.bUpdatingSelection = true;
        TreeItem tiPrev = this.getPrevDiffItem(this.getCurrentTreeItem());
        if (tiPrev != null) {
            TreeItem[] tiArray = new TreeItem[]{tiPrev};
            this.getTreeViewer().reveal((Object)tiPrev);
            this.forceTreeSelection(tiArray);
            this.setCurrentTreeItem(tiPrev);
        } else {
            TreeItem tiLast;
            boolean bContinue = MessageDialog.openQuestion(null, (String)GO_TO_NEXT_TITLE, (String)BEGINNING_OF_DOC_MSG);
            if (bContinue && (tiLast = this.getPrevDiffItem(null)) != null) {
                TreeItem[] tiArray = new TreeItem[]{tiLast};
                this.getTreeViewer().reveal((Object)tiLast);
                this.forceTreeSelection(tiArray);
                this.setCurrentTreeItem(tiLast);
            }
        }
        this.bUpdatingSelection = false;
    }

    void handleDownArrow() {
        this.bUpdatingSelection = true;
        TreeItem tiNext = this.getNextDiffItem(this.getCurrentTreeItem());
        if (tiNext != null) {
            TreeItem[] tiArray = new TreeItem[]{tiNext};
            this.forceTreeSelection(tiArray);
            this.setCurrentTreeItem(tiNext);
        } else {
            TreeItem tiFirst;
            boolean bContinue = MessageDialog.openQuestion(null, (String)GO_TO_NEXT_TITLE, (String)END_OF_DOC_MSG);
            if (bContinue && (tiFirst = this.getNextDiffItem(null)) != null) {
                TreeItem[] tiArray = new TreeItem[]{tiFirst};
                this.getTreeViewer().reveal((Object)tiFirst);
                this.forceTreeSelection(tiArray);
                this.setCurrentTreeItem(tiFirst);
            }
        }
        this.bUpdatingSelection = false;
    }

    private void forceTreeSelection(final TreeItem[] tiArray) {
        if (tiArray == null || tiArray.length == 0 || tiArray[0] == null || tiArray[0].getData() == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CompareTreePanel.this.doTreeSelection(tiArray);
                CompareTreePanel.this.forceTreeSelectionAgain(tiArray);
            }
        });
    }

    void forceTreeSelectionAgain(final TreeItem[] tiArray) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CompareTreePanel.this.doTreeSelection(tiArray);
            }
        });
    }

    void doTreeSelection(TreeItem[] tiArray) {
        StructuredSelection sel = new StructuredSelection(tiArray[0].getData());
        this.getTreeViewer().setSelection((ISelection)sel, true);
        Event event = new Event();
        event.widget = this.tree;
        this.tree.notifyListeners(13, event);
    }

    private void setCurrentTreeItem(TreeItem ti) {
        this.tiCurrentSelection = ti;
    }

    private TreeItem getCurrentTreeItem() {
        return this.tiCurrentSelection;
    }

    private TreeItem getNextDiffItem(TreeItem tiCurrentNode) {
        int iSize = this.arylTreeItemDepthFirstList.size();
        int iStartIndex = 0;
        TreeItem tiResult = null;
        if (tiCurrentNode != null) {
            iStartIndex = this.arylTreeItemDepthFirstList.indexOf(tiCurrentNode);
            ++iStartIndex;
        } else {
            iStartIndex = 0;
        }
        int i = iStartIndex;
        while (i < iSize) {
            TreeItem tiTemp = this.arylTreeItemDepthFirstList.get(i);
            if (this.controller.isItemChanged(tiTemp)) {
                tiResult = tiTemp;
                break;
            }
            ++i;
        }
        return tiResult;
    }

    private TreeItem getPrevDiffItem(TreeItem tiCurrentNode) {
        int iSize = this.arylTreeItemDepthFirstList.size();
        int iStartIndex = iSize - 1;
        TreeItem tiResult = null;
        if (tiCurrentNode != null) {
            iStartIndex = this.arylTreeItemDepthFirstList.indexOf(tiCurrentNode);
            --iStartIndex;
        } else {
            iStartIndex = iSize - 1;
        }
        int i = iStartIndex;
        while (i > -1) {
            TreeItem tiTemp = this.arylTreeItemDepthFirstList.get(i);
            if (this.controller.isItemChanged(tiTemp)) {
                tiResult = tiTemp;
                break;
            }
            --i;
        }
        return tiResult;
    }

    public void setTerminology(int terminology) {
        DecoratingLabelProvider labelProvider = (DecoratingLabelProvider)this.treeViewer.getLabelProvider();
        ((MappingLabelDecorator)labelProvider.getLabelDecorator()).setTerminology(terminology);
    }

    class CompareTreeController
    extends DefaultTreeViewerController {
        CompareTreeController() {
        }

        public boolean isItemCheckable(TreeItem theItem) {
            return this.isItemChanged(theItem);
        }

        public boolean isItemChanged(TreeItem theItem) {
            Object element = theItem.getData();
            MappingHelper helper = null;
            if (element instanceof DifferenceReport) {
                Mapping mapping = ((DifferenceReport)element).getMapping();
                helper = mapping.getHelper();
            } else if (element instanceof Mapping) {
                helper = ((Mapping)element).getHelper();
            }
            if (helper instanceof DifferenceDescriptor) {
                DifferenceDescriptor desc = (DifferenceDescriptor)helper;
                if (desc.isChangedBelow()) {
                    return false;
                }
                if (desc.isAddition() || desc.isDeletion() || desc.isChanged()) {
                    return true;
                }
            }
            return false;
        }

        public void checkedStateToggled(TreeItem theItem) {
            if (CompareTreePanel.this.isUpdatingMappingSkipFlag()) {
                Object element = theItem.getData();
                MappingHelper helper = null;
                if (element instanceof DifferenceReport) {
                    Mapping mapping = ((DifferenceReport)element).getMapping();
                    helper = mapping.getHelper();
                } else if (element instanceof Mapping) {
                    helper = ((Mapping)element).getHelper();
                }
                if (helper instanceof DifferenceDescriptor) {
                    ((DifferenceDescriptor)helper).setSkip(!theItem.getChecked());
                }
            }
        }

        public void update(TreeItem item, boolean selected) {
            super.update(item, selected);
            this.checkedStateToggled(item);
        }
    }

    class PaneToolBarManager
    extends ToolBarManager {
        public PaneToolBarManager(ToolBar paneToolBar) {
            super(paneToolBar);
        }

        protected void relayout(ToolBar toolBar, int oldCount, int newCount) {
            toolBar.layout();
            Composite parent = toolBar.getParent();
            parent.layout();
            if (parent.getParent() != null) {
                parent.getParent().layout();
            }
        }
    }
}

