/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.ui.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.compare.DifferenceDescriptor;
import org.teiid.designer.compare.PropertyDifference;
import org.teiid.designer.compare.ui.UiConstants;
import org.teiid.designer.compare.ui.tree.DifferenceAnalysis;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DifferenceDescriptorPanel
extends Composite
implements UiConstants,
CoreStringUtil.Constants {
    private static final String PREFIX = "DifferenceDescriptorPanel.";
    private static final String[] TBL_HDRS_OLDNEW = new String[]{"", Util.getString("DifferenceDescriptorPanel.nameHdr", new Object[0]), Util.getString("DifferenceDescriptorPanel.oldValueHdr", new Object[0]), Util.getString("DifferenceDescriptorPanel.newValueHdr", new Object[0])};
    private static final String[] TBL_HDRS_FIRSTSECOND = new String[]{"", Util.getString("DifferenceDescriptorPanel.nameHdr", new Object[0]), Util.getString("DifferenceDescriptorPanel.firstValueHdr", new Object[0]), Util.getString("DifferenceDescriptorPanel.secondValueHdr", new Object[0])};
    private static final String NO_SELECTION = Util.getString("DifferenceDescriptorPanel.noSelection.text", new Object[0]);
    private static final String SELECTION_IS_DELETION = Util.getString("DifferenceDescriptorPanel.selectionIsDeletion.text", new Object[0]);
    private static final String SELECTION_IS_ADDITION = Util.getString("DifferenceDescriptorPanel.selectionIsAddition.text", new Object[0]);
    private static final String SELECTION_IS_CHANGED = Util.getString("DifferenceDescriptorPanel.selectionIsChanged.text", new Object[0]);
    private static final String SELECTION_IS_UNCHANGED = Util.getString("DifferenceDescriptorPanel.selectionIsUnchanged.text", new Object[0]);
    private static final String SELECTION_IS_CHANGE_BELOW = Util.getString("DifferenceDescriptorPanel.selectionIsChangeBelow.text", new Object[0]);
    private CLabel label;
    private ILabelProvider labelProvider = DifferenceAnalysis.getMappingLabelProvider();
    private ILabelProvider propTableLabelProvider;
    private TableViewer tableViewer;
    private Table table;
    List<PropertyDifference> tableRowList;
    private String title;
    private boolean enablePropSelection;
    private boolean showCheckboxes;
    private int iTerminology = 1;

    public DifferenceDescriptorPanel(Composite parent, String title, boolean enablePropertySelection, boolean showCheckboxes, int iTerminology) {
        super(parent, 0);
        this.title = title;
        this.enablePropSelection = enablePropertySelection;
        this.showCheckboxes = showCheckboxes;
        this.iTerminology = iTerminology;
        this.initialize();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private void initialize() {
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Group group = WidgetFactory.createGroup((Composite)this, (String)this.title, (int)1808);
        this.label = WidgetFactory.createLabel((Composite)group, (int)768);
        this.label.setText("");
        int style = 2816;
        this.tableViewer = this.showCheckboxes ? CheckboxTableViewer.newCheckList((Composite)group, (int)style) : new TableViewer((Composite)group, style);
        this.table = this.tableViewer.getTable();
        this.table.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        String[] sHeaders = new String[]{""};
        if (this.iTerminology == 1) {
            sHeaders = TBL_HDRS_OLDNEW;
        } else if (this.iTerminology == 2) {
            sHeaders = TBL_HDRS_FIRSTSECOND;
        }
        int i = 0;
        while (i < sHeaders.length) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.setText(sHeaders[i]);
            if (!this.enablePropSelection) {
                column.setWidth(0);
            }
            ++i;
        }
        this.tableViewer.setContentProvider((IContentProvider)new TableViewerContentProvider());
        this.propTableLabelProvider = new TableViewerLabelProvider();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.propTableLabelProvider);
        this.tableRowList = new ArrayList<PropertyDifference>();
        this.tableViewer.setInput(this.tableRowList);
    }

    private void setColumnHeaderText() {
        String[] sHeaders = new String[]{""};
        if (this.iTerminology == 1) {
            sHeaders = TBL_HDRS_OLDNEW;
        } else if (this.iTerminology == 2) {
            sHeaders = TBL_HDRS_FIRSTSECOND;
        }
        int i = 0;
        while (i < this.table.getColumnCount()) {
            TableColumn column = this.table.getColumn(i);
            column.setText(sHeaders[i]);
            if (!this.enablePropSelection) {
                column.setWidth(0);
            }
            ++i;
        }
    }

    public void setTerminologyStyle(int iTerminology) {
        this.iTerminology = iTerminology;
        this.setColumnHeaderText();
    }

    public void initCheckStates() {
        TableItem[] tableItems = this.tableViewer.getTable().getItems();
        int i = 0;
        while (i < tableItems.length) {
            TableItem item = tableItems[i];
            Object itemData = item.getData();
            if (itemData instanceof PropertyDifference) {
                PropertyDifference propDiff = (PropertyDifference)itemData;
                if (propDiff.isSkip()) {
                    item.setChecked(false);
                } else {
                    item.setChecked(true);
                }
            }
            ++i;
        }
    }

    public void clear() {
        this.setDescriptor(null);
    }

    public void setDescriptor(DifferenceDescriptor descriptor) {
        if (descriptor != null) {
            Mapping mapping = descriptor.getMapper();
            StringBuffer sb = new StringBuffer();
            sb.append(this.labelProvider.getText((Object)mapping));
            if (DifferenceAnalysis.isAdd(mapping)) {
                sb.append(" - " + SELECTION_IS_ADDITION);
            } else if (DifferenceAnalysis.isDelete(mapping)) {
                sb.append(" - " + SELECTION_IS_DELETION);
            } else if (DifferenceAnalysis.isChange(mapping)) {
                sb.append(" - " + SELECTION_IS_CHANGED);
            } else if (DifferenceAnalysis.isUnchanged(mapping)) {
                sb.append(" - " + SELECTION_IS_UNCHANGED);
            } else if (DifferenceAnalysis.isChangeBelow(mapping)) {
                sb.append(" - " + SELECTION_IS_CHANGE_BELOW);
            }
            this.label.setText(sb.toString());
        } else {
            this.label.setText(NO_SELECTION);
        }
        this.updateTableRows(descriptor);
    }

    private void updateTableRows(DifferenceDescriptor descriptor) {
        Mapping mapping = null;
        if (descriptor != null) {
            mapping = descriptor.getMapper();
            if (mapping != null && DifferenceAnalysis.isChange(mapping)) {
                this.tableRowList.clear();
                for (PropertyDifference propDiff : descriptor.getPropertyDifferences()) {
                    this.tableRowList.add(propDiff);
                }
                this.tableViewer.refresh();
                this.initCheckStates();
                TableColumn[] cols = this.table.getColumns();
                int ndx = 0;
                while (ndx < cols.length) {
                    if (ndx == 0 && !this.enablePropSelection) {
                        cols[ndx].setWidth(0);
                    } else {
                        cols[ndx].pack();
                    }
                    ++ndx;
                }
                this.table.setVisible(true);
            } else {
                this.tableRowList.clear();
                this.tableViewer.refresh();
                this.table.setVisible(false);
            }
        } else {
            this.tableRowList.clear();
            this.tableViewer.refresh();
            this.table.setVisible(false);
        }
    }

    String getValueString(Object value, ILabelProvider propertyLabelProvider) {
        String result = null;
        if (propertyLabelProvider != null) {
            if (value instanceof List) {
                String str = new String();
                Iterator iter = ((List)value).iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    str = o instanceof EObject ? String.valueOf(str) + ModelUtilities.getEMFLabelProvider().getText(o) : String.valueOf(str) + propertyLabelProvider.getText(o);
                    if (!iter.hasNext()) continue;
                    str = String.valueOf(str) + "; ";
                }
                result = str;
            } else {
                result = propertyLabelProvider.getText(value);
            }
        } else if (value != null) {
            result = value.toString();
        }
        return result;
    }

    class TableViewerContentProvider
    implements IStructuredContentProvider {
        TableViewerContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            return DifferenceDescriptorPanel.this.tableRowList.toArray();
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
        }
    }

    class TableViewerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableViewerLabelProvider() {
        }

        public Image getColumnImage(Object theElement, int theColumnIndex) {
            Image result = null;
            switch (theColumnIndex) {
                case 2: 
                case 3: {
                    IPropertySource source = ModelObjectUtilities.getEmfPropertySourceProvider().getPropertySource(theElement);
                    IPropertyDescriptor[] descs = source.getPropertyDescriptors();
                    ILabelProvider propertyLabelProvider = descs[1].getLabelProvider();
                    if (propertyLabelProvider == null) break;
                    result = propertyLabelProvider.getImage(theElement);
                    break;
                }
            }
            return result;
        }

        public String getColumnText(Object theElement, int theColumnIndex) {
            String result;
            block7: {
                block6: {
                    result = null;
                    if (!(theElement instanceof PropertyDifference)) break block6;
                    PropertyDifference row = (PropertyDifference)theElement;
                    IPropertySource source = ModelObjectUtilities.getEmfPropertySourceProvider().getPropertySource((Object)row);
                    IPropertyDescriptor[] descs = source.getPropertyDescriptors();
                    ILabelProvider propertyLabelProvider = descs[1].getLabelProvider();
                    switch (theColumnIndex) {
                        case 1: {
                            EStructuralFeature feature = row.getAffectedFeature();
                            if (feature != null) {
                                result = feature.getName();
                                break;
                            }
                            break block7;
                        }
                        case 2: {
                            Object old = row.getOldValue();
                            result = DifferenceDescriptorPanel.this.getValueString(old, propertyLabelProvider);
                            break;
                        }
                        case 3: {
                            Object newVal = row.getNewValue();
                            result = DifferenceDescriptorPanel.this.getValueString(newVal, propertyLabelProvider);
                            break;
                        }
                        default: {
                            result = "";
                            break;
                        }
                    }
                    break block7;
                }
                result = super.getText(theElement);
            }
            return result;
        }
    }
}

