/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.ui.tree;

import org.eclipse.emf.mapping.Mapping;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.compare.DifferenceDescriptor;
import org.teiid.designer.compare.DifferenceType;
import org.teiid.designer.compare.ui.PluginConstants;
import org.teiid.designer.compare.ui.UiPlugin;
import org.teiid.designer.compare.ui.tree.DifferenceAnalysis;
import org.teiid.designer.compare.ui.tree.MappingTreeContentProvider;
import org.teiid.designer.ui.OverlayImageIcon;

class MappingLabelDecorator
implements ILabelDecorator,
PluginConstants {
    static final Image CHG_AND_CHG_BELOW_IMG = UiPlugin.getDefault().getImage("icons/full/ovr16/chg_and_chg_below_ov.gif");
    static final Image CHG_BELOW_IMG = UiPlugin.getDefault().getImage("icons/full/ovr16/chg_below_ov.gif");
    static final Image CHG_IMG = UiPlugin.getDefault().getImage("icons/full/ovr16/chg_ov.gif");
    static final Image OLD_IMG = UiPlugin.getDefault().getImage("icons/full/ovr16/old_ov.gif");
    static final Image NEW_IMG = UiPlugin.getDefault().getImage("icons/full/ovr16/new_ov.gif");
    static final Image FIRST_IMG = UiPlugin.getDefault().getImage("icons/full/ovr16/first_ov.gif");
    static final Image SECOND_IMG = UiPlugin.getDefault().getImage("icons/full/ovr16/second_ov.gif");
    private int terminology;
    private MappingTreeContentProvider contentProvider;

    MappingLabelDecorator(int terminology) {
        this.setTerminology(terminology);
    }

    public void setMappingTreeContentProvider(MappingTreeContentProvider theProvider) {
        this.contentProvider = theProvider;
    }

    public Image decorateImage(Image baseImage, Object object) {
        if (!(object instanceof Mapping)) {
            return baseImage;
        }
        Mapping mapping = (Mapping)object;
        Image icon = null;
        if (DifferenceAnalysis.isAdd(mapping)) {
            icon = this.terminology == 2 ? SECOND_IMG : NEW_IMG;
        } else if (DifferenceAnalysis.isDelete(mapping)) {
            icon = this.terminology == 2 ? FIRST_IMG : OLD_IMG;
        } else if (DifferenceAnalysis.isChange(mapping)) {
            icon = CHG_IMG;
            if (this.mappingIsChangedBelow(mapping)) {
                icon = CHG_AND_CHG_BELOW_IMG;
            }
        } else if (DifferenceAnalysis.isChangeBelow(mapping)) {
            icon = CHG_BELOW_IMG;
        } else if (this.contentProvider != null && this.contentProvider.hasAdditionalPropertyDifferences((Mapping)object)) {
            icon = CHG_IMG;
        }
        if (icon != null) {
            OverlayImageIcon overlayIcon = new OverlayImageIcon(baseImage, icon, icon == CHG_BELOW_IMG ? 2 : 3);
            return overlayIcon.getImage();
        }
        return baseImage;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    private boolean mappingIsChangedBelow(Mapping mapping) {
        for (Mapping child : mapping.getNested()) {
            if (((DifferenceDescriptor)child.getHelper()).getType() == DifferenceType.NO_CHANGE_LITERAL) continue;
            return true;
        }
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void setTerminology(int terminology) {
        switch (terminology) {
            case 1: 
            case 2: {
                this.terminology = terminology;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

