/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.ui.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.compare.CompareFactory;
import org.teiid.designer.compare.DifferenceDescriptor;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.DifferenceType;
import org.teiid.designer.compare.PropertyDifference;
import org.teiid.designer.compare.impl.CompareFactoryImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramContainer;
import org.teiid.designer.metamodels.diagram.DiagramEntity;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.MappingClassSetContainer;
import org.teiid.designer.metamodels.transformation.TransformationContainer;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;

public class MappingTreeContentProvider
implements ITreeContentProvider {
    private List diffReports;
    private HashMap hmTargetToRelatedNodes;
    private ArrayList arylContainerNodes;
    private boolean bInsertRelatedNodes = true;
    private CompareFactory compareFactory = new CompareFactoryImpl();
    private Map propDiffMap = null;

    private Map getPropertyDifferenceMap() {
        if (this.propDiffMap == null) {
            this.propDiffMap = new PropertyDifferenceMap();
        }
        return this.propDiffMap;
    }

    public boolean hasAdditionalPropertyDifferences(Mapping theMapping) {
        EObject eobj = MappingTreeContentProvider.getEObjectForMapping(theMapping);
        return eobj != null && this.propDiffMap != null && this.propDiffMap.containsKey(eobj);
    }

    public boolean hasChildAdditionalPropertyDifferences(Mapping theMapping) {
        if (this.propDiffMap == null) {
            return false;
        }
        EObject eobj = MappingTreeContentProvider.getEObjectForMapping(theMapping);
        if (eobj == null) {
            return false;
        }
        return this.hasChildAdditionalPropertyDifferences(eobj);
    }

    public boolean hasChildAdditionalPropertyDifferences(EObject eobj) {
        Iterator children = eobj.eContents().iterator();
        boolean result = false;
        while (children.hasNext() && !result) {
            EObject nextChild = (EObject)children.next();
            result = this.propDiffMap.containsKey(nextChild) ? true : this.hasChildAdditionalPropertyDifferences(nextChild);
        }
        return result;
    }

    public void setDifferenceReports(List diffReports) {
        this.hmTargetToRelatedNodes = null;
        this.arylContainerNodes = null;
        this.propDiffMap = null;
        this.diffReports = diffReports;
        if (this.diffReports != null) {
            for (DifferenceReport drTemp : this.diffReports) {
                this.parseReport(drTemp);
            }
        }
    }

    private void parseReport(DifferenceReport drReport) {
        MappingHelper helper;
        if (drReport == null) {
            return;
        }
        Mapping mapping = drReport.getMapping();
        if (mapping != null && (helper = mapping.getHelper()) instanceof DifferenceDescriptor) {
            this.parseChildren(drReport);
        }
    }

    private HashMap getTargetToRelatedMap() {
        if (this.hmTargetToRelatedNodes == null) {
            this.hmTargetToRelatedNodes = new HashMap();
        }
        return this.hmTargetToRelatedNodes;
    }

    private ArrayList getcontainerNodesArray() {
        if (this.arylContainerNodes == null) {
            this.arylContainerNodes = new ArrayList();
        }
        return this.arylContainerNodes;
    }

    public static EObject getEObjectForMapping(Mapping mapping) {
        EObject eoResult = null;
        MappingHelper helper = mapping.getHelper();
        if (helper instanceof DifferenceDescriptor) {
            DifferenceDescriptor desc = (DifferenceDescriptor)helper;
            DifferenceType type = desc.getType();
            if (type.getValue() == 2) {
                EObject input;
                EList inputs = mapping.getInputs();
                EObject eObject = input = inputs.isEmpty() ? null : (EObject)inputs.get(0);
                if (input != null) {
                    eoResult = input;
                }
            } else {
                EObject input;
                EList outputs = mapping.getOutputs();
                EObject output = outputs.isEmpty() ? null : (EObject)outputs.get(0);
                EList inputs = mapping.getInputs();
                EObject eObject = input = inputs.isEmpty() ? null : (EObject)inputs.get(0);
                if (output != null) {
                    eoResult = output;
                } else if (input != null) {
                    eoResult = input;
                }
            }
        }
        return eoResult;
    }

    private void parseChildren(Object mapping) {
        block25: {
            block28: {
                EList mappings;
                block29: {
                    EObject eo;
                    block27: {
                        block26: {
                            block24: {
                                eo = null;
                                if (mapping instanceof Mapping) {
                                    eo = MappingTreeContentProvider.getEObjectForMapping((Mapping)mapping);
                                }
                                if (eo == null || !(eo instanceof DiagramContainer)) break block24;
                                this.getcontainerNodesArray().add(mapping);
                                Object[] children = this.getTheChildren(mapping);
                                int i = 0;
                                int j = children.length;
                                while (i < j) {
                                    EObject eoTarget;
                                    EObject eoChild = MappingTreeContentProvider.getEObjectForMapping((Mapping)children[i]);
                                    if (eoChild instanceof Diagram) {
                                        eoTarget = ((Diagram)eoChild).getTarget();
                                        this.addEntry(eoTarget, (Mapping)children[i]);
                                    } else if (eoChild instanceof DiagramEntity) {
                                        eoTarget = ((DiagramEntity)eoChild).getDiagram().getTarget();
                                        this.addEntry(eoTarget, (Mapping)children[i]);
                                    }
                                    ++i;
                                }
                                break block25;
                            }
                            if (eo == null || !(eo instanceof TransformationContainer)) break block26;
                            this.getcontainerNodesArray().add(mapping);
                            Object[] children = this.getTheChildren(mapping);
                            int i = 0;
                            int j = children.length;
                            while (i < j) {
                                EObject eoChild = MappingTreeContentProvider.getEObjectForMapping((Mapping)children[i]);
                                if (eoChild instanceof TransformationMappingRoot) {
                                    EObject eoTarget = ((TransformationMappingRoot)eoChild).getTarget();
                                    this.addEntry(eoTarget, (Mapping)children[i]);
                                }
                                ++i;
                            }
                            break block25;
                        }
                        if (eo == null || !(eo instanceof MappingClassSetContainer)) break block27;
                        this.getcontainerNodesArray().add(mapping);
                        Object[] children = this.getTheChildren(mapping);
                        int i = 0;
                        int j = children.length;
                        while (i < j) {
                            EObject eoChild = MappingTreeContentProvider.getEObjectForMapping((Mapping)children[i]);
                            if (eoChild instanceof MappingClassSet) {
                                EObject eoTarget = ((MappingClassSet)eoChild).getTarget();
                                this.addEntry(eoTarget, (Mapping)children[i]);
                            }
                            ++i;
                        }
                        break block25;
                    }
                    if (eo == null || !(eo instanceof AnnotationContainer)) break block28;
                    this.getcontainerNodesArray().add(mapping);
                    EList annotations = ((AnnotationContainer)eo).getAnnotations();
                    if (annotations == null || annotations.isEmpty()) break block25;
                    mappings = ((Mapping)mapping).getNested();
                    if (!mappings.isEmpty()) break block29;
                    EList list = null;
                    AnnotationContainer ac = null;
                    MappingHelper helper = ((Mapping)mapping).getHelper();
                    if (!(helper instanceof DifferenceDescriptor)) break block25;
                    boolean isAdd = true;
                    if (((DifferenceDescriptor)helper).isAddition()) {
                        list = ((Mapping)mapping).getOutputs();
                    } else if (((DifferenceDescriptor)helper).isDeletion()) {
                        list = ((Mapping)mapping).getInputs();
                        isAdd = false;
                    }
                    if (list != null && !list.isEmpty()) {
                        ac = (AnnotationContainer)list.get(0);
                        EList newAnnotations = ac.getAnnotations();
                        int size = newAnnotations.size();
                        int i = 0;
                        while (i < size) {
                            Annotation a = (Annotation)newAnnotations.get(i);
                            String desc = a.getDescription();
                            EMap tags = a.getTags();
                            if (isAdd) {
                                if (!CoreStringUtil.isEmpty((String)desc)) {
                                    this.createNewDescriptionPropertyDifference(a, true);
                                }
                                if (tags != null && !tags.isEmpty()) {
                                    this.createNewAnnotationTagPropertyDifference(a, true);
                                }
                            } else {
                                if (!CoreStringUtil.isEmpty((String)desc)) {
                                    this.createNewDescriptionPropertyDifference(a, false);
                                }
                                if (tags != null && !tags.isEmpty()) {
                                    this.createNewAnnotationTagPropertyDifference(a, false);
                                }
                            }
                            ++i;
                        }
                    }
                    break block25;
                    break block25;
                }
                int size = mappings.size();
                int i = 0;
                while (i < size) {
                    Mapping nestedMapping = (Mapping)mappings.get(i);
                    MappingHelper nestedHelper = nestedMapping.getHelper();
                    if (nestedHelper instanceof DifferenceDescriptor && !((DifferenceDescriptor)nestedHelper).isNoChange()) {
                        EList inputs = nestedMapping.getInputs();
                        Annotation oldValue = inputs.isEmpty() ? null : (Annotation)inputs.get(0);
                        EList outputs = nestedMapping.getOutputs();
                        Annotation newValue = outputs.isEmpty() ? null : (Annotation)outputs.get(0);
                        this.createChangedDescriptionPropertyDifference(oldValue, newValue);
                    }
                    ++i;
                }
                break block25;
            }
            Object[] children = this.getTheChildren(mapping);
            int i = 0;
            int j = children.length;
            while (i < j) {
                if (children[i] instanceof Mapping) {
                    this.parseChildren(children[i]);
                }
                ++i;
            }
        }
    }

    private void createChangedDescriptionPropertyDifference(Annotation theOldAnnotation, Annotation theNewAnnotation) {
        EClass eclass = theNewAnnotation == null ? theOldAnnotation.eClass() : theNewAnnotation.eClass();
        PropertyDifference propDiff = this.compareFactory.createPropertyDifference();
        propDiff.setAffectedFeature((EStructuralFeature)eclass.getEAttributes().get(0));
        propDiff.setOldValue((Object)(theOldAnnotation == null ? null : theOldAnnotation.getDescription()));
        propDiff.setNewValue((Object)(theNewAnnotation == null ? null : theNewAnnotation.getDescription()));
        EObject target = theNewAnnotation == null ? theOldAnnotation.getAnnotatedObject() : theNewAnnotation.getAnnotatedObject();
        this.registerDescriptionPropertyDifference(target, propDiff);
    }

    private boolean associate(PropertyDifference thePropDifference, Mapping theMapping) {
        boolean result = false;
        MappingHelper helper = theMapping.getHelper();
        if (helper instanceof DifferenceDescriptor) {
            thePropDifference.setDescriptor((DifferenceDescriptor)helper);
            if (((DifferenceDescriptor)helper).isNoChange()) {
                ((DifferenceDescriptor)helper).setType(DifferenceType.get((int)3));
            }
            result = true;
        }
        return result;
    }

    private void registerDescriptionPropertyDifference(EObject theObject, PropertyDifference thePropDifference) {
        boolean cacheDiff = true;
        Mapping mapping = this.getPropertyDifferenceMapping(theObject);
        if (mapping != null) {
            boolean bl = cacheDiff = !this.associate(thePropDifference, mapping);
        }
        if (cacheDiff) {
            this.getPropertyDifferenceMap().put(theObject, thePropDifference);
        }
    }

    private void createNewDescriptionPropertyDifference(Annotation theAnnotation, boolean theAddedFlag) {
        EClass eclass = theAnnotation.eClass();
        PropertyDifference propDiff = this.compareFactory.createPropertyDifference();
        propDiff.setAffectedFeature(eclass.getEStructuralFeature(0));
        if (theAddedFlag) {
            propDiff.setNewValue((Object)theAnnotation.getDescription());
        } else {
            propDiff.setOldValue((Object)theAnnotation.getDescription());
        }
        EObject target = theAnnotation.getAnnotatedObject();
        this.registerDescriptionPropertyDifference(target, propDiff);
    }

    private void createNewAnnotationTagPropertyDifference(Annotation theAnnotation, boolean theAddedFlag) {
        EClass eclass = theAnnotation.eClass();
        PropertyDifference propDiff = this.compareFactory.createPropertyDifference();
        propDiff.setAffectedFeature(eclass.getEStructuralFeature(2));
        if (theAddedFlag) {
            propDiff.setOldValue((Object)new BasicEMap());
            propDiff.setNewValue((Object)theAnnotation.getTags());
        } else {
            propDiff.setOldValue((Object)theAnnotation.getTags());
            propDiff.setNewValue((Object)new BasicEMap());
        }
        EObject target = theAnnotation.getAnnotatedObject();
        this.registerDescriptionPropertyDifference(target, propDiff);
    }

    private Object[] getTheChildren(Object node) {
        Object[] result;
        if (node instanceof DifferenceReport) {
            Mapping mapping = ((DifferenceReport)node).getMapping();
            result = this.getTheChildren(mapping);
        } else if (node instanceof List) {
            result = ((List)node).toArray();
        } else if (node instanceof Mapping) {
            EList nestedMappings = ((Mapping)node).getNested();
            result = nestedMappings.toArray();
        } else {
            EObject parent = (EObject)node;
            EList children = parent.eContents();
            result = children.toArray();
        }
        return result;
    }

    private void addEntry(Object oKey, Mapping mpgValue) {
        if (this.getTargetToRelatedMap().containsKey(oKey)) {
            List lstNodes = (List)this.getTargetToRelatedMap().get(oKey);
            lstNodes.add(mpgValue);
        } else {
            ArrayList<Mapping> aryl = new ArrayList<Mapping>();
            aryl.add(mpgValue);
            this.getTargetToRelatedMap().put(oKey, aryl);
        }
    }

    private Mapping getPropertyDifferenceMapping(EObject theObject) {
        Mapping result = null;
        List list = (List)this.getTargetToRelatedMap().get(theObject);
        if (list != null) {
            IPath path = ModelerCore.getModelEditor().getModelRelativePath(theObject);
            int size = list.size();
            int i = 0;
            while (i < size) {
                Mapping m = (Mapping)list.get(i);
                EObject eobj = MappingTreeContentProvider.getEObjectForMapping(m);
                if (eobj != null && path.equals((Object)ModelerCore.getModelEditor().getModelRelativePath(eobj))) {
                    result = m;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public Object[] getChildren(Object node) {
        Object[] result;
        if (node instanceof DifferenceReport) {
            Mapping mapping = ((DifferenceReport)node).getMapping();
            this.bInsertRelatedNodes = false;
            result = this.getChildren(mapping);
            this.bInsertRelatedNodes = true;
            result = this.filterContainers(result);
        } else if (node instanceof List) {
            result = ((List)node).toArray();
        } else if (node instanceof Mapping) {
            ArrayList aryl = new ArrayList();
            if (this.getcontainerNodesArray().contains(node)) {
                return aryl.toArray();
            }
            if (this.bInsertRelatedNodes) {
                EObject eo = MappingTreeContentProvider.getEObjectForMapping((Mapping)node);
                List lst = (List)this.getTargetToRelatedMap().get(eo);
                if (this.hasAdditionalPropertyDifferences((Mapping)node)) {
                    PropertyDifference propDiff = (PropertyDifference)this.getPropertyDifferenceMap().get(eo);
                    this.associate(propDiff, (Mapping)node);
                }
                if (lst != null) {
                    aryl.addAll(lst);
                }
            }
            EList nestedMappings = ((Mapping)node).getNested();
            aryl.addAll(nestedMappings);
            result = aryl.toArray();
        } else {
            EObject parent = (EObject)node;
            EList children = parent.eContents();
            result = children.toArray();
        }
        return result;
    }

    private Object[] filterContainers(Object[] children) {
        ArrayList<Object> aryl = new ArrayList<Object>();
        int i = 0;
        int j = children.length;
        while (i < j) {
            if (!this.getcontainerNodesArray().contains(children[i])) {
                aryl.add(children[i]);
            }
            ++i;
        }
        return aryl.toArray();
    }

    public boolean hasChildren(Object node) {
        boolean hasChildren = false;
        if (node instanceof DifferenceReport) {
            Mapping mapping = ((DifferenceReport)node).getMapping();
            hasChildren = this.hasChildren(mapping);
        } else if (node instanceof List) {
            hasChildren = ((List)node).size() > 0;
        } else if (node instanceof Mapping) {
            Mapping parent = (Mapping)node;
            EList children = parent.getNested();
            hasChildren = children.size() > 0;
        }
        return hasChildren;
    }

    public Object[] getElements(Object node) {
        Object[] array = null;
        if (node instanceof DifferenceReport) {
            Mapping mapping = ((DifferenceReport)node).getMapping();
            ArrayList<Mapping> aryl = new ArrayList<Mapping>(1);
            aryl.add(mapping);
            array = aryl.toArray();
        } else if (node instanceof List) {
            array = ((List)node).toArray();
        } else if (node instanceof Mapping) {
            Mapping parent = (Mapping)node;
            Object elements = parent.getNested();
            if (elements == null) {
                elements = new ArrayList(0);
            }
            array = elements.toArray();
        }
        return array;
    }

    public Object getParent(Object node) {
        EObject result = null;
        if (node instanceof Mapping) {
            Mapping child = (Mapping)node;
            result = child.eContainer();
        }
        return result;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    class PropertyDifferenceMap
    extends HashMap {
        private static final long serialVersionUID = 1L;

        PropertyDifferenceMap() {
        }

        @Override
        public boolean containsKey(Object theKey) {
            Object key = this.getKey(theKey);
            return key == null ? false : super.containsKey(key);
        }

        @Override
        public Object get(Object theKey) {
            Object key = this.getKey(theKey);
            return key == null ? null : super.get(key);
        }

        private Object getKey(Object theObject) {
            return theObject instanceof EObject ? ModelerCore.getModelEditor().getModelRelativePath((EObject)theObject) : null;
        }

        @Override
        public Object put(Object theKey, Object theValue) {
            Object key = this.getKey(theKey);
            return key == null ? null : super.put(key, theValue);
        }
    }
}

