/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.services.PluginResourceLocator;
import org.osgi.framework.BundleContext;

public class DesignerSPIPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.teiid.designer.spi";
    private static final String TARGET = "target";
    private static final String SOURCES = "sources";
    private static final String JAR = "jar";
    public static final String PACKAGE_ID = DesignerSPIPlugin.class.getPackage().getName();
    private static DesignerSPIPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    private static void log(int error, Throwable throwable, String message) {
        plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, throwable));
    }

    public static void log(Throwable throwable) {
        DesignerSPIPlugin.log(4, throwable, throwable.getLocalizedMessage());
    }

    private static String findPluginJar(IPath path) {
        String osPath;
        File jarFile;
        if (path == null) {
            return null;
        }
        if (!path.getFileExtension().equals(JAR)) {
            path = path.addFileExtension(JAR);
        }
        if ((jarFile = new File(osPath = path.toOSString())).exists()) {
            return osPath;
        }
        return null;
    }

    private static String findTargetJar(IPath path) {
        if (path == null) {
            return null;
        }
        File targetDir = new File((path = path.append(TARGET)).toOSString());
        if (!targetDir.isDirectory()) {
            return null;
        }
        File[] fileArray = targetDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(JAR) && !file.getName().contains(SOURCES) && file.getName().startsWith(PLUGIN_ID)) {
                return file.getAbsolutePath();
            }
            ++n2;
        }
        return null;
    }

    public static String getPluginPath() {
        IPath path = PluginResourceLocator.getPluginRootPath((String)PLUGIN_ID);
        String jarPath = DesignerSPIPlugin.findPluginJar(path);
        if (jarPath == null) {
            jarPath = DesignerSPIPlugin.findTargetJar(path);
        }
        return jarPath;
    }
}

