/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.teiid.designer.ExtensionRegistryUtils;
import org.teiid.designer.IExtensionRegistryCallback;

public abstract class AbstractExtensionRegistry<K, V> {
    private Map<K, V> extensions = new HashMap();
    private String extPointId;
    private String elementId;

    protected AbstractExtensionRegistry(String extPointId, String elementId) throws Exception {
        this.extPointId = extPointId;
        this.elementId = elementId;
        this.load();
    }

    private void load() throws Exception {
        IExtensionRegistryCallback callback = new IExtensionRegistryCallback<V>(){

            @Override
            public String getExtensionPointId() {
                return AbstractExtensionRegistry.this.extPointId;
            }

            @Override
            public String getElementId() {
                return AbstractExtensionRegistry.this.elementId;
            }

            @Override
            public String getAttributeId() {
                return "class";
            }

            @Override
            public boolean isSingle() {
                return false;
            }

            @Override
            public void process(V instance, IConfigurationElement element) {
                AbstractExtensionRegistry.this.register(element, instance);
            }
        };
        ExtensionRegistryUtils.createExtensionInstances(callback);
    }

    protected abstract void register(IConfigurationElement var1, V var2);

    protected void register(K key, V value) {
        this.extensions.put(key, value);
    }

    public V getRegistered(K key) {
        return this.extensions.get(key);
    }

    public Collection<K> getRegisteredKeys() {
        return Collections.unmodifiableCollection(this.extensions.keySet());
    }

    public Collection<V> getRegistered() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    protected Collection<Map.Entry<K, V>> getRegisteredEntries() {
        return Collections.unmodifiableCollection(this.extensions.entrySet());
    }
}

