/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.teiid.core.designer.PluginUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.common.EditorPerspectiveListener;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.common.graphics.ImageImageDescriptor;
import org.teiid.designer.ui.common.product.IProductContext;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;

public abstract class AbstractUiPlugin
extends AbstractUIPlugin {
    static List<IWorkbenchWindow> windowList = new ArrayList<IWorkbenchWindow>(3);
    Map<IWorkbenchWindow, ActionService> windowServiceMap;
    IWorkbenchWindow lastActiveWorkbenchWindow;
    private FormColors formColors;
    private FormToolkit ftk;
    private static IWorkbenchPage lastPage;

    private void constructAbstractUiPlugin() {
        this.windowServiceMap = new HashMap<IWorkbenchWindow, ActionService>();
        IWorkbench workbench = this.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow theWindow = workbench.getActiveWorkbenchWindow();
        if (theWindow != null && !windowList.contains(theWindow)) {
            theWindow.addPerspectiveListener((IPerspectiveListener)new EditorPerspectiveListener(theWindow));
            windowList.add(theWindow);
        }
        workbench.addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow theWindow) {
                AbstractUiPlugin.this.lastActiveWorkbenchWindow = theWindow;
            }

            public void windowDeactivated(IWorkbenchWindow theWindow) {
            }

            public void windowClosed(IWorkbenchWindow theWindow) {
                AbstractUiPlugin.this.windowServiceMap.remove(theWindow);
                windowList.remove(theWindow);
            }

            public void windowOpened(IWorkbenchWindow theWindow) {
                if (!windowList.contains(theWindow)) {
                    theWindow.addPerspectiveListener((IPerspectiveListener)new EditorPerspectiveListener(theWindow));
                    windowList.add(theWindow);
                }
            }
        });
    }

    protected abstract ActionService createActionService(IWorkbenchPage var1);

    public abstract PluginUtil getPluginUtil();

    private ImageDescriptor createImageDescriptor(String key) {
        try {
            URL url = new URL(String.valueOf(this.getBundle().getEntry("/").toString()) + key);
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
            ImageRegistry registry = this.getImageRegistry();
            registry.put(key, descriptor);
            return descriptor;
        }
        catch (MalformedURLException err) {
            this.getPluginUtil().log((Throwable)err);
            return null;
        }
    }

    public ActionService getActionService(IWorkbenchPage pg) {
        if (this.windowServiceMap == null) {
            this.constructAbstractUiPlugin();
        }
        if (pg != null) {
            lastPage = pg;
        } else {
            pg = lastPage;
        }
        if (pg != null) {
            IWorkbenchWindow theWindow = pg.getWorkbenchWindow();
            ActionService service = this.windowServiceMap.get(theWindow);
            if (service == null) {
                service = this.createActionService(pg);
                this.windowServiceMap.put(theWindow, service);
            }
            return service;
        }
        return null;
    }

    public final Image getImage(String key) {
        ImageRegistry registry = this.getImageRegistry();
        Image img = registry.get(key);
        if (img != null) {
            return img;
        }
        try {
            this.createImageDescriptor(key);
            img = registry.get(key);
            return img != null ? img : ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        catch (SWTException err) {
            this.getPluginUtil().log(2, (Throwable)err, err.getMessage());
            return null;
        }
    }

    public final ImageDescriptor getImageDescriptor(String key) {
        ImageRegistry registry = this.getImageRegistry();
        ImageDescriptor descriptor = registry.getDescriptor(key);
        if (descriptor != null) {
            return descriptor;
        }
        return this.createImageDescriptor(key);
    }

    public final IWorkbenchWindow getCurrentWorkbenchWindow() {
        IWorkbenchWindow result = this.getWorkbench().getActiveWorkbenchWindow();
        if (result == null) {
            result = this.lastActiveWorkbenchWindow;
        }
        return result;
    }

    public final IEclipsePreferences getPreferences() {
        return ModelerCore.getPreferences((String)this.getBundle().getSymbolicName());
    }

    public final void savePreferences() {
        try {
            ModelerCore.savePreferences((String)this.getBundle().getSymbolicName());
        }
        catch (BackingStoreException e) {
            this.getPluginUtil().log((Throwable)e);
        }
    }

    public final IEclipsePreferences getDefaultPreferences() {
        return ModelerCore.getDefaultPreferences((String)this.getBundle().getSymbolicName());
    }

    public boolean isImageRegistered(String imageId) {
        return this.getImageRegistry().get(imageId) != null;
    }

    protected void registerPluginImage(String plugin, String key) {
        ImageRegistry registry = this.getImageRegistry();
        URL viewsUrl = Platform.getBundle((String)plugin).getEntry("/");
        try {
            URL url = new URL(viewsUrl + key);
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
            if (registry.get(key) != null) {
                registry.put(key, descriptor);
            }
        }
        catch (MalformedURLException err) {
            this.getPluginUtil().log((Throwable)err);
        }
    }

    public void registerPluginImage(String key, Image image) {
        ImageRegistry registry = this.getImageRegistry();
        registry.put(key, (ImageDescriptor)new ImageImageDescriptor(image));
    }

    public void stop(BundleContext context) throws Exception {
        if (this.windowServiceMap != null) {
            for (ActionService actionService : this.windowServiceMap.values()) {
                actionService.shutdown();
            }
        }
        super.stop(context);
    }

    public FormToolkit getFormToolkit(Display display) {
        if (this.ftk == null) {
            this.ftk = new FormToolkit(this.getFormColors(display));
        }
        return this.ftk;
    }

    private FormColors getFormColors(Display display) {
        if (this.formColors == null) {
            this.formColors = new FormColors(display);
            this.formColors.markShared();
        }
        return this.formColors;
    }

    public boolean isProductContextSupported(IProductContext theContext) {
        return ProductCustomizerMgr.getInstance().supports(theContext);
    }

    public boolean isProductContextValueSupported(IProductContext theContext, Object theValue) {
        return ProductCustomizerMgr.getInstance().supports(theContext, theValue);
    }

    public static IWorkbenchPage getLastValidPage() {
        return lastPage;
    }
}

