/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.PluginUtil;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.graphics.ImageImageDescriptor;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;

public abstract class AbstractAction
extends Action
implements INullSelectionListener,
ISelectionChangedListener {
    private String acceleratorId;
    private String descriptionId;
    private String disabledImageId;
    private String helpId;
    private String hoverImageId;
    private String imageId;
    private AbstractUiPlugin plugin;
    private ISelection selection;
    private SelectionChangedEvent selectionEvent;
    private String textId;
    private String tipId;
    private PluginUtil pluginUtils;
    private boolean useWaitCursor = true;
    private IWorkbenchPart part;

    public AbstractAction(AbstractUiPlugin thePlugin) {
        this.plugin = thePlugin;
        this.init();
    }

    public AbstractAction(AbstractUiPlugin thePlugin, int theStyle) {
        super("", theStyle);
        this.plugin = thePlugin;
        this.init();
    }

    public void dispose() {
    }

    public String getAcceleratorId() {
        return this.acceleratorId;
    }

    private String getActionPropertyKey(String thePropertyId) {
        return new StringBuffer().append(this.getId()).append(".").append(thePropertyId).toString();
    }

    public String getDescriptionId() {
        return this.descriptionId;
    }

    public String getDisabledImageId() {
        return this.disabledImageId;
    }

    public String getHelpContextId() {
        return this.helpId;
    }

    public String getHoverImageId() {
        return this.hoverImageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public AbstractUiPlugin getPlugin() {
        return this.plugin;
    }

    protected PluginUtil getPluginUtils() {
        return this.pluginUtils;
    }

    public Object getSelectedObject() {
        return SelectionUtilities.getSelectedObject(this.selection);
    }

    public List getSelectedObjects() {
        return SelectionUtilities.getSelectedObjects(this.selection);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public SelectionChangedEvent getSelectionEvent() {
        return this.selectionEvent;
    }

    public String getTextId() {
        return this.textId;
    }

    public String getToolTipId() {
        return this.tipId;
    }

    protected IWorkbenchPart getPart() {
        return this.part;
    }

    protected void init() {
        this.pluginUtils = this.plugin.getPluginUtil();
        this.setId(((Object)((Object)this)).getClass().getName());
        String key = this.getActionPropertyKey("accelerator");
        if (this.pluginUtils.keyExists(key)) {
            this.setAcceleratorId(key);
        }
        if (this.pluginUtils.keyExists(key = this.getActionPropertyKey("description"))) {
            this.setDescriptionId(key);
        }
        if (this.pluginUtils.keyExists(key = this.getActionPropertyKey("disabledImage"))) {
            this.setDisabledImageId(key);
        }
        if (this.pluginUtils.keyExists(key = this.getActionPropertyKey("helpId"))) {
            this.setHelpContextId(key);
        }
        if (this.pluginUtils.keyExists(key = this.getActionPropertyKey("hoverImage"))) {
            this.setHoverImageId(key);
        }
        if (this.pluginUtils.keyExists(key = this.getActionPropertyKey("image"))) {
            this.setImageId(key);
        }
        if (this.pluginUtils.keyExists(key = this.getActionPropertyKey("text"))) {
            this.setTextId(key);
        }
        if (this.pluginUtils.keyExists(key = this.getActionPropertyKey("toolTip"))) {
            this.setToolTipTextId(key);
        }
    }

    public boolean isEmptySelection() {
        return this.selection == null || this.selection.isEmpty();
    }

    public boolean isMultiSelection() {
        return SelectionUtilities.isMultiSelection(this.selection);
    }

    public void selectionChanged(SelectionChangedEvent theEvent) {
        this.selection = theEvent.getSelection();
        this.part = null;
        this.selectionEvent = theEvent;
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        this.part = thePart;
        this.selection = theSelection;
        this.selectionEvent = null;
    }

    public void setAcceleratorId(String theId) {
        this.acceleratorId = theId;
    }

    public void setDescriptionId(String theId) {
        this.descriptionId = theId;
        this.setDescription(theId != null ? this.pluginUtils.getString(theId, new Object[0]) : "");
    }

    public void setDisabledImage(Image theImage) {
        this.setDisabledImageDescriptor(new ImageImageDescriptor(theImage));
    }

    public void setDisabledImageId(String theId) {
        this.disabledImageId = theId;
        ImageDescriptor descriptor = null;
        if (theId != null) {
            descriptor = this.plugin.getImageDescriptor(this.pluginUtils.getString(theId, new Object[0]));
        }
        super.setDisabledImageDescriptor(descriptor);
    }

    public void setHelpContextId(String theId) {
        this.helpId = theId;
        this.part.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((IAction)this, theId);
    }

    public void setHoverImage(Image theImage) {
        this.setHoverImageDescriptor(new ImageImageDescriptor(theImage));
    }

    public void setHoverImageId(String theId) {
        this.hoverImageId = theId;
        ImageDescriptor descriptor = null;
        if (theId != null) {
            descriptor = this.plugin.getImageDescriptor(this.pluginUtils.getString(theId, new Object[0]));
        }
        super.setHoverImageDescriptor(descriptor);
    }

    public void setImage(Image theImage) {
        this.setImageDescriptor(new ImageImageDescriptor(theImage));
    }

    public void setImageId(String theId) {
        this.imageId = theId;
        ImageDescriptor descriptor = null;
        if (theId != null) {
            descriptor = this.plugin.getImageDescriptor(this.pluginUtils.getString(theId, new Object[0]));
        }
        super.setImageDescriptor(descriptor);
    }

    public void setPluginUtil(PluginUtil theUtil) {
        this.pluginUtils = theUtil;
    }

    public void setTextId(String theId) {
        String acceleratorText;
        String label;
        this.textId = theId;
        String string = label = theId != null ? this.pluginUtils.getString(theId, new Object[0]) : "";
        if (this.acceleratorId != null && (acceleratorText = this.pluginUtils.getString(this.acceleratorId, new Object[0])) != null && acceleratorText.length() > 0) {
            label = String.valueOf(label) + "@" + acceleratorText;
        }
        this.setText(label);
    }

    public void setToolTipTextId(String theId) {
        this.tipId = theId;
        this.setToolTipText(theId != null ? this.pluginUtils.getString(theId, new Object[0]) : "");
    }

    protected void setUseWaitCursor(boolean flag) {
        this.useWaitCursor = flag;
    }

    protected abstract void doRun();

    protected boolean preRun() {
        return true;
    }

    public final void run() {
        if (this.preRun()) {
            if (this.useWaitCursor) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        AbstractAction.this.doRun();
                    }
                };
                UiBusyIndicator.showWhile(null, runnable);
            } else {
                this.doRun();
            }
        }
        this.postRun();
    }

    protected void postRun() {
    }
}

