/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.dialog;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.teiid.designer.ui.common.InternalUiConstants;

public class FolderSelectionDialog
extends ElementTreeSelectionDialog
implements ISelectionChangedListener {
    private Button fNewFolderButton;
    private IContainer fSelectedContainer;
    private static final String TITLE = InternalUiConstants.Util.getString("FolderSelectionDialog.title.text", new Object[0]);
    private static final String FOLDER_SELECTION_DIALOG_MESSAGE = InternalUiConstants.Util.getString("FolderSelectionDialog.message.text", new Object[0]);
    private static final String CREATE_NEW_BUTTON_TEXT = InternalUiConstants.Util.getString("FolderSelectionDialog.createNewButton.text", new Object[0]);

    public FolderSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setTitle(TITLE);
        this.setMessage(FOLDER_SELECTION_DIALOG_MESSAGE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        Button button = new Button(result, 8);
        button.setText(CREATE_NEW_BUTTON_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FolderSelectionDialog.this.newFolderButtonPressed();
            }
        });
        button.setFont(parent.getFont());
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        this.fNewFolderButton = button;
        FolderSelectionDialog.applyDialogFont((Control)result);
        return result;
    }

    private void updateNewFolderButtonState() {
        Object first;
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        this.fSelectedContainer = null;
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IContainer) {
            this.fSelectedContainer = (IContainer)first;
        }
        this.fNewFolderButton.setEnabled(this.fSelectedContainer != null);
    }

    protected void newFolderButtonPressed() {
        NewFolderDialog dialog = new NewFolderDialog(this.getShell(), this.fSelectedContainer);
        if (dialog.open() == 0) {
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.refresh((Object)this.fSelectedContainer);
            Object createdFolder = dialog.getResult()[0];
            treeViewer.reveal(createdFolder);
            treeViewer.setSelection((ISelection)new StructuredSelection(createdFolder));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateNewFolderButtonState();
    }
}

