/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.dialog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.ui.common.widget.MessageLabel;

public class RadioMessageDialog
extends MessageDialog {
    private String[] radioEntries;
    private String radioTitle;
    private Integer selected;
    private int dftRadio;
    private IStatus[] errorMessages;
    private MessageLabel ml;

    public RadioMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String dialogRadioTitle, String[] dialogRadioLabelsAndValues, int defaultRadioIndex, String[] dialogButtonLabels, int defaultButtonIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultButtonIndex);
        this.radioTitle = dialogRadioTitle;
        this.radioEntries = dialogRadioLabelsAndValues;
        this.dftRadio = defaultRadioIndex;
        this.selected = new Integer(defaultRadioIndex);
    }

    public RadioMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String dialogRadioTitle, String[] dialogRadioLabelsAndValues, IStatus[] errorMessages, int defaultRadioIndex, String[] dialogButtonLabels, int defaultButtonIndex) {
        this(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogRadioTitle, dialogRadioLabelsAndValues, defaultRadioIndex, dialogButtonLabels, defaultButtonIndex);
        this.errorMessages = errorMessages;
    }

    protected Control createMessageArea(Composite parent) {
        super.createMessageArea(parent);
        new Composite(parent, 0);
        return this.getRadioControl(parent, this.radioTitle, this.radioEntries, this.dftRadio);
    }

    protected Control createCustomArea(Composite parent) {
        super.createCustomArea(parent);
        if (this.errorMessages == null) {
            this.errorMessages = new IStatus[this.radioEntries.length];
        }
        this.ml = new MessageLabel(parent);
        GridData data = new GridData(768);
        this.ml.setLayoutData(data);
        this.setSelected(this.selected);
        return this.ml;
    }

    void setSelected(Integer which) {
        this.selected = which;
        IStatus err = this.errorMessages[which];
        if (err != null) {
            this.ml.setErrorStatus(err);
            this.ml.redraw();
        } else {
            this.ml.setErrorStatus(null);
        }
    }

    public Composite getRadioControl(Composite parent, String groupTitle, String[] radioNames, int defaultRadio) {
        Font font = parent.getFont();
        Group radioGroup = new Group(parent, 0);
        GridData data = new GridData(770);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        radioGroup.setLayoutData((Object)data);
        radioGroup.setFont(font);
        if (groupTitle != null) {
            radioGroup.setText(groupTitle);
        }
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 8;
        layout.numColumns = 1;
        radioGroup.setLayout((Layout)layout);
        int i = 0;
        while (i < radioNames.length) {
            Button radio = new Button((Composite)radioGroup, 16400);
            radio.setFont(font);
            radio.setData((Object)new Integer(i));
            radio.setText(radioNames[i]);
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    RadioMessageDialog.this.setSelected((Integer)event.widget.getData());
                }
            });
            if (i == defaultRadio) {
                radio.setSelection(true);
            }
            ++i;
        }
        return radioGroup;
    }

    public int getSelected() {
        return this.selected;
    }

    public static int openMulti(Shell parent, int type, String title, String message, String optionsTitle, String[] options, IStatus[] errorMessages, int defaultRadioButton) {
        RadioMessageDialog dialog = new RadioMessageDialog(parent, title, null, message, type, optionsTitle, options, errorMessages, defaultRadioButton, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
        return dialog.getSelected();
    }
}

