/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.eventsupport;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.teiid.designer.ui.common.eventsupport.SelectionProvider;

public class CompositeSelectionProvider
extends SelectionProvider
implements ISelectionChangedListener {
    private List<ISelectionProvider> subProviders = new ArrayList<ISelectionProvider>();

    @Override
    public synchronized void addSelectionChangedListener(ISelectionChangedListener theListener) {
        super.addSelectionChangedListener(theListener);
        ISelection selection = this.getSelection();
        if (selection != null) {
            theListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    public void addSelectionProvider(ISelectionProvider theSelectionProvider) {
        this.subProviders.add(theSelectionProvider);
        theSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        ISelection selection = theSelectionProvider.getSelection();
        if (selection != null) {
            this.setSelection(selection, true, this);
        }
    }

    public void removeSelectionProvider(ISelectionProvider theSelectionProvider) {
        this.subProviders.remove(theSelectionProvider);
        theSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent theEvent) {
        this.setSelection(theEvent.getSelection(), true, this);
    }
}

