/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.eventsupport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.teiid.designer.ui.common.UiConstants;

public class SelectionUtilities
implements UiConstants {
    private SelectionUtilities() {
    }

    public static EObject getSelectedEObject(ISelection theSelection) {
        EObject result = null;
        Object temp = SelectionUtilities.getSelectedObject(theSelection);
        if (temp != null && temp instanceof EObject) {
            result = (EObject)temp;
        }
        return result;
    }

    public static List<EObject> getSelectedEObjects(ISelection theSelection) {
        List<Object> result = SelectionUtilities.getSelectedObjects(theSelection);
        if (!result.isEmpty()) {
            Iterator<Object> itr = result.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (obj instanceof EObject) continue;
                itr.remove();
            }
        }
        return result;
    }

    public static List getSelectedIResourceObjects(ISelection theSelection) {
        List<Object> result = SelectionUtilities.getSelectedObjects(theSelection);
        if (!result.isEmpty()) {
            Iterator<Object> itr = result.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (obj instanceof IResource) continue;
                itr.remove();
            }
        }
        return result;
    }

    public static Object getSelectedObject(ISelection theSelection) {
        Object result = null;
        if (SelectionUtilities.isSingleSelection(theSelection) && theSelection instanceof IStructuredSelection) {
            result = ((IStructuredSelection)theSelection).getFirstElement();
        }
        return result;
    }

    public static List<Object> getSelectedObjects(ISelection theSelection) {
        ArrayList result = null;
        if (theSelection != null && !theSelection.isEmpty() && theSelection instanceof IStructuredSelection) {
            result = new ArrayList(((IStructuredSelection)theSelection).toList());
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public static boolean isAllEObjects(ISelection theSelection) {
        boolean result;
        boolean bl = result = theSelection != null && !theSelection.isEmpty() && theSelection instanceof IStructuredSelection;
        if (result) {
            result = SelectionUtilities.getSelectedObjects(theSelection).size() == SelectionUtilities.getSelectedEObjects(theSelection).size();
        }
        return result;
    }

    public static boolean isMixedObjectTypes(ISelection theSelection) {
        if (SelectionUtilities.isSingleSelection(theSelection)) {
            return false;
        }
        return !SelectionUtilities.isAllEObjects(theSelection) && !SelectionUtilities.isAllIResourceObjects(theSelection);
    }

    public static boolean isAllIResourceObjects(ISelection theSelection) {
        boolean result;
        boolean bl = result = theSelection != null && !theSelection.isEmpty() && theSelection instanceof IStructuredSelection;
        if (result) {
            result = SelectionUtilities.getSelectedObjects(theSelection).size() == SelectionUtilities.getSelectedIResourceObjects(theSelection).size();
        }
        return result;
    }

    public static boolean isMultiSelection(ISelection theSelection) {
        boolean result;
        boolean bl = result = theSelection != null;
        if (result && theSelection instanceof IStructuredSelection) {
            result = ((IStructuredSelection)theSelection).size() > 1;
        }
        return result;
    }

    public static boolean isSingleSelection(ISelection theSelection) {
        boolean result;
        boolean bl = result = theSelection != null;
        if (result && theSelection instanceof IStructuredSelection) {
            result = ((IStructuredSelection)theSelection).size() == 1;
        }
        return result;
    }

    public static boolean isEmptySelection(ISelection theSelection) {
        return theSelection == null || theSelection.isEmpty();
    }
}

