/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.product;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.product.IProductContext;
import org.teiid.designer.ui.common.product.IProductCustomizer;

public abstract class AbstractProductCustomizer
implements IProductCustomizer,
UiConstants {
    private static final Set ALL_VALUES = Collections.singleton(new Object());
    private static final String PREFIX = I18nUtil.getPropertyPrefix(AbstractProductCustomizer.class);
    protected Map supportedMap = new HashMap();
    protected Map unsupportedMap = new HashMap();

    protected boolean addContextSupport(IProductContext theContext) {
        boolean result = true;
        if (!this.unsupportedMap.containsKey(theContext)) {
            this.supportedMap.put(theContext, ALL_VALUES);
        } else {
            result = false;
            Util.log(2, this.getString(PREFIX, "addContextSupportFailed", new Object[]{theContext}));
        }
        return result;
    }

    protected boolean addContextValueSupport(IProductContext theContext, Object theValue) {
        boolean result = true;
        if (!this.unsupportedMap.containsKey(theContext)) {
            HashSet<Object> values = (HashSet<Object>)this.supportedMap.get(theContext);
            if (values == null) {
                values = new HashSet<Object>();
                this.supportedMap.put(theContext, values);
            }
            if (!values.equals(ALL_VALUES)) {
                values.add(theValue);
            }
        } else {
            result = false;
            Util.log(2, this.getString(PREFIX, "addContextValueSupportFailed", new Object[]{theValue, theContext}));
        }
        return result;
    }

    protected boolean removeContextSupport(IProductContext theContext) {
        boolean result = true;
        if (!this.supportedMap.containsKey(theContext)) {
            this.unsupportedMap.put(theContext, ALL_VALUES);
        } else {
            result = false;
            Util.log(2, this.getString(PREFIX, "removeContextSupportFailed", new Object[]{theContext}));
        }
        return result;
    }

    protected boolean removeContextValueSupport(IProductContext theContext, Object theValue) {
        boolean result = true;
        if (!this.supportedMap.containsKey(theContext)) {
            HashSet<Object> values = (HashSet<Object>)this.unsupportedMap.get(theContext);
            if (values == null) {
                values = new HashSet<Object>();
                this.unsupportedMap.put(theContext, values);
            }
            if (!values.equals(ALL_VALUES)) {
                values.add(theValue);
            }
        } else {
            result = false;
            Util.log(2, this.getString(PREFIX, "removeContextValueSupportFailed", new Object[]{theValue, theContext}));
        }
        return result;
    }

    protected String getString(String thePrefix, String theKey, Object[] theParams) {
        return Util.getString(String.valueOf(thePrefix) + theKey, theParams);
    }

    @Override
    public boolean supports(IProductContext theContext) {
        boolean result = true;
        Collection values = (Collection)this.supportedMap.get(theContext);
        if (values != null) {
            result = values.equals(ALL_VALUES);
        } else if (this.unsupportedMap.get(theContext) != null) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean supports(IProductContext theContext, Object theValue) {
        boolean result = true;
        Collection values = (Collection)this.supportedMap.get(theContext);
        if (values == null) {
            values = (Collection)this.unsupportedMap.get(theContext);
            if (values != null) {
                result = values.equals(ALL_VALUES) ? false : !values.contains(theValue);
            }
        } else if (!values.equals(ALL_VALUES)) {
            result = values.contains(theValue);
        }
        return result;
    }
}

