/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.product;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.product.DefaultProductCharacteristics;
import org.teiid.designer.ui.common.product.IProductCharacteristics;
import org.teiid.designer.ui.common.product.IProductContext;
import org.teiid.designer.ui.common.product.IProductCustomizer;

public final class ProductCustomizerMgr
implements IProductCustomizer,
UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ProductCustomizerMgr.class);
    public static final String DEFAULT_PRODUCT_ID = "noproductapplication";
    public static final DefaultProductCharacteristics DEFAULT_PRODUCT_CHARACTERISTICS = new DefaultProductCharacteristics();
    public static final String DEFAULT_PRODUCT_NAME = "No Product Application";
    private static ProductCustomizerMgr instance;
    private IProductCustomizer delegate;
    private String productName = "No Product Application";

    public static ProductCustomizerMgr getInstance() {
        if (instance == null) {
            instance = new ProductCustomizerMgr();
        }
        return instance;
    }

    private ProductCustomizerMgr() {
    }

    @Override
    public String getProductId() {
        return this.delegate == null ? DEFAULT_PRODUCT_ID : this.delegate.getProductId();
    }

    public String getProductName() {
        return this.productName;
    }

    @Override
    public void loadCustomizations() {
        IProduct product = Platform.getProduct();
        if (product != null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui.common", "productCustomizer");
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        Object extension = elements[j].createExecutableExtension("name");
                        if (extension instanceof IProductCustomizer) {
                            IProductCustomizer customizer = (IProductCustomizer)extension;
                            if (customizer.getProductId().equals(product.getId())) {
                                this.delegate = customizer;
                                this.productName = product.getName();
                                customizer.loadCustomizations();
                                break;
                            }
                        } else {
                            Util.log(4, Util.getString(String.valueOf(PREFIX) + "productCustomizerIncorrectClass", (Object)extension.getClass().getName()));
                        }
                    }
                    catch (Exception theException) {
                        String msg = Util.getString(String.valueOf(PREFIX) + "productCustomizerInitializationError", (Object)elements[j].getAttribute("name"));
                        Util.log(4, (Throwable)theException, msg);
                        this.delegate = null;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean supports(IProductContext theContext) {
        return this.delegate == null ? true : this.delegate.supports(theContext);
    }

    @Override
    public boolean supports(IProductContext theContext, Object theValue) {
        return this.delegate == null ? true : this.delegate.supports(theContext, theValue);
    }

    @Override
    public IProductCharacteristics getProductCharacteristics() {
        return this.delegate == null ? DEFAULT_PRODUCT_CHARACTERISTICS : this.delegate.getProductCharacteristics();
    }
}

