/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.table;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class DoubleClickTableViewer
extends TableViewer {
    boolean editEnabled = false;
    private Table tableControl;

    public DoubleClickTableViewer(Composite parent, int style) {
        super(parent, style);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.tableControl = (Table)control;
        this.tableControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DoubleClickTableViewer.this.activateEdit(e);
            }
        });
    }

    protected void activateEdit(MouseEvent e) {
        int columnToEdit;
        int columns = this.tableControl.getColumnCount();
        if (columns == 0) {
            columnToEdit = 0;
        } else {
            columnToEdit = -1;
            TableItem[] selection = this.tableControl.getSelection();
            if (selection.length != 1) {
                return;
            }
            TableItem tableItem = selection[0];
            int i = 0;
            while (i < columns) {
                Rectangle bounds = tableItem.getBounds(i);
                if (bounds.contains(e.x, e.y)) {
                    columnToEdit = i;
                    break;
                }
                ++i;
            }
            if (columnToEdit == -1) {
                return;
            }
        }
        this.editEnabled = true;
        this.renameInline(columnToEdit);
    }

    public void renameInline(int columnToEdit) {
        IStructuredSelection selection = (IStructuredSelection)super.getSelection();
        Object element = selection.getFirstElement();
        this.editEnabled = true;
        super.editElement(element, columnToEdit);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DoubleClickTableViewer.this.editEnabled = false;
            }
        });
    }

    public void setCellModifier(ICellModifier modifier) {
        super.setCellModifier((ICellModifier)new DoubleClickCellModifier(modifier));
    }

    class DoubleClickCellModifier
    implements ICellModifier {
        private ICellModifier delegate;

        public DoubleClickCellModifier(ICellModifier modifier) {
            this.delegate = modifier;
        }

        public boolean canModify(Object element, String property) {
            if (DoubleClickTableViewer.this.editEnabled) {
                return this.delegate.canModify(element, property);
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            return this.delegate.getValue(element, property);
        }

        public void modify(Object element, String property, Object value) {
            this.delegate.modify(element, property, value);
        }
    }
}

