/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.table;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;

public abstract class ResourceEditingSupport
extends EditingSupport {
    protected CellEditor currentEditor;
    private String[] allowedValues;
    private ICellEditorValidator validator;
    private IResource resource;

    public ResourceEditingSupport(ColumnViewer viewer, IResource resource) {
        super(viewer);
        this.resource = resource;
    }

    protected boolean canAddNewValue(Object element) {
        return false;
    }

    protected boolean canEdit(Object element) {
        return !this.resource.getResourceAttributes().isReadOnly();
    }

    protected CellEditor getCellEditor(Object element) {
        this.allowedValues = this.refreshItems(element);
        if (this.allowedValues != null && this.allowedValues.length == 0) {
            this.allowedValues = null;
        }
        if (this.allowedValues == null) {
            this.currentEditor = new TextCellEditor((Composite)this.getViewer().getControl());
            if (this.validator != null) {
                this.currentEditor.setValidator(this.validator);
            }
        } else {
            int style = this.canAddNewValue(element) ? 0 : 8;
            ComboBoxCellEditor comboEditor = new ComboBoxCellEditor((Composite)this.getViewer().getControl(), new String[0], style);
            comboEditor.setItems(this.allowedValues);
            this.currentEditor = comboEditor;
        }
        return this.currentEditor;
    }

    protected abstract String getElementValue(Object var1);

    protected Object getValue(Object element) {
        String value = this.getElementValue(element);
        if (value == null) {
            value = "";
        }
        if (this.allowedValues == null) {
            return value;
        }
        int i = 0;
        while (i < this.allowedValues.length) {
            if (value.equals(this.allowedValues[i])) {
                return i;
            }
            ++i;
        }
        String[] temp = new String[this.allowedValues.length + 1];
        temp[0] = value;
        System.arraycopy(this.allowedValues, 0, temp, 1, this.allowedValues.length);
        this.allowedValues = temp;
        ((ComboBoxCellEditor)this.currentEditor).setItems(this.allowedValues);
        return 0;
    }

    protected abstract String[] refreshItems(Object var1);

    protected abstract void setElementValue(Object var1, String var2);

    protected void setValue(Object element, Object value) {
        int index;
        String newValue = value instanceof Integer ? ((index = ((Integer)value).intValue()) == -1 ? ((CCombo)((ComboBoxCellEditor)this.currentEditor).getControl()).getText() : this.allowedValues[index]) : (String)value;
        this.setElementValue(element, newValue);
        this.getViewer().refresh(element);
    }

    public void setValidator(ICellEditorValidator validator) {
        this.validator = validator;
    }
}

