/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.table;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.teiid.core.designer.util.CoreArgCheck;

public class TableColumnSelectionHelper {
    private int selectedColumn = -1;
    private int selectedRow = -1;
    private Table table;

    public TableColumnSelectionHelper(TableViewer theViewer) {
        CoreArgCheck.isNotNull((Object)theViewer);
        this.construct(theViewer.getTable());
    }

    protected void construct(Table theTable) {
        CoreArgCheck.isNotNull((Object)theTable);
        this.table = theTable;
        this.table.addMouseListener((MouseListener)new TableMouseListener());
        this.table.addKeyListener((KeyListener)new TableKeyListener());
        this.table.addSelectionListener((SelectionListener)new TableSelectionListener());
        this.handleSelectionEvent(null);
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public int[] getSelectedRowAndColumn() {
        return new int[]{this.getSelectedRow(), this.getSelectedColumn()};
    }

    protected void handleKeyEvent(KeyEvent theEvent) {
        if (theEvent.keyCode == 0x1000001) {
            this.selectedColumn = -1;
        } else if (theEvent.keyCode == 0x1000002) {
            this.selectedColumn = -1;
        }
    }

    protected void handleMouseEvent(MouseEvent theEvent) {
        TableItem[] selection = this.table.getSelection();
        if (selection.length > 0) {
            int numCols = this.table.getColumnCount();
            int i = 0;
            while (i < numCols) {
                Rectangle bounds = selection[0].getBounds(i);
                if (bounds.contains(theEvent.x, theEvent.y)) {
                    this.selectedColumn = i;
                    break;
                }
                ++i;
            }
            this.selectedRow = this.table.getSelectionIndex();
        }
    }

    protected void handleSelectionEvent(SelectionEvent theEvent) {
        int[] indexes = this.table.getSelectionIndices();
        if (indexes.length > 0) {
            this.selectedRow = indexes[0];
        } else {
            this.selectedRow = -1;
            this.selectedColumn = -1;
        }
    }

    class TableKeyListener
    extends KeyAdapter {
        TableKeyListener() {
        }

        public void keyPressed(KeyEvent theEvent) {
            TableColumnSelectionHelper.this.handleKeyEvent(theEvent);
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        TableMouseListener() {
        }

        public void mouseDown(MouseEvent theEvent) {
            TableColumnSelectionHelper.this.handleMouseEvent(theEvent);
        }
    }

    class TableSelectionListener
    extends SelectionAdapter {
        TableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent theEvent) {
            TableColumnSelectionHelper.this.handleSelectionEvent(theEvent);
        }
    }
}

