/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.table;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableSizeAdapter
extends ControlAdapter {
    private Table table;
    private int margin;

    public TableSizeAdapter(Table table, int margin) {
        this.table = table;
        this.margin = margin;
        table.getParent().addControlListener((ControlListener)this);
    }

    public void controlResized(ControlEvent e) {
        Composite container = this.table.getParent();
        Rectangle area = container.getClientArea();
        Point preferredSize = this.table.computeSize(-1, -1);
        int width = area.width - 2 * this.table.getBorderWidth() - this.margin;
        if (preferredSize.y > area.height) {
            Point vBarSize = this.table.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        Point oldSize = this.table.getSize();
        TableColumn[] columns = this.table.getColumns();
        if (columns.length == 2) {
            if (oldSize.x > area.width) {
                columns[0].setWidth(width / 2);
                columns[1].setWidth(width - columns[0].getWidth());
                this.table.setSize(area.width, area.height);
            } else {
                this.table.setSize(area.width, area.height);
                columns[0].setWidth(width / 2);
                columns[1].setWidth(width - columns[0].getWidth());
            }
        } else if (columns.length == 1) {
            columns[0].setWidth(width);
        }
    }
}

