/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.table;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class TableViewerBuilder {
    private final Composite tableComposite;
    private final TableColumnLayout tableColumnLayout;
    private final TableViewer tableViewer;

    public TableViewerBuilder(Composite parent, int tableViewerStyles) {
        this.tableComposite = new Composite(parent, 0);
        if (parent.getLayout() instanceof GridLayout) {
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tableComposite);
        }
        this.tableColumnLayout = new TableColumnLayout();
        this.tableComposite.setLayout((Layout)this.tableColumnLayout);
        this.tableViewer = new TableViewer(this.tableComposite, tableViewerStyles);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
    }

    public Composite getTableComposite() {
        return this.tableComposite;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public Table getControl() {
        return this.getTable();
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.tableViewer.setSelection(selection);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.tableViewer.setSelection(selection, reveal);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.tableViewer.setContentProvider(contentProvider);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.tableViewer.setLabelProvider(labelProvider);
    }

    public void setComparator(ViewerComparator comparator) {
        this.tableViewer.setComparator(comparator);
    }

    public void addSelectionChangedListener(ISelectionChangedListener selectionChangedListener) {
        this.tableViewer.addSelectionChangedListener(selectionChangedListener);
    }

    public void addDoubleClickListener(IDoubleClickListener doubleClickListener) {
        this.tableViewer.addDoubleClickListener(doubleClickListener);
    }

    public TableViewerColumn createColumn(int columnStyle, int weight, int minSize, boolean resizeable) {
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, columnStyle);
        this.tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, minSize, resizeable));
        return column;
    }

    public void setInput(Object input) {
        this.tableViewer.setInput(input);
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    public void refresh(Object element) {
        this.tableViewer.refresh(element);
    }

    public void add(Object element) {
        this.tableViewer.add(element);
    }
}

