/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.table;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.UiPlugin;

public class TableViewerSorter
extends ViewerSorter
implements UiConstants.Images {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    private static final int UNSORT = 2;
    TableViewer viewer;
    private int sortColumn = 0;
    private int sortOrder = 2;
    private SelectionListener headerListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableViewerSorter.this.setSortColumn(TableViewerSorter.this.viewer.getTable().indexOf((TableColumn)e.widget));
            TableViewerSorter.this.viewer.refresh();
        }
    };

    public TableViewerSorter(TableViewer tableViewer) {
        this.viewer = tableViewer;
        this.setSortListener();
    }

    public TableViewerSorter(TableViewer tableViewer, int initialColumn, int initialSortOrder) {
        this(tableViewer);
        this.sortColumn = initialColumn;
        this.sortOrder = initialSortOrder;
    }

    protected int compareColumn(TableViewer viewer, Object object1, Object object2, int column) {
        return super.compare((Viewer)this.viewer, object1, object2);
    }

    public void setSortListener() {
        TableColumn[] columns = this.viewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].addSelectionListener(this.headerListener);
            ++i;
        }
    }

    public boolean isUnsorted() {
        return this.sortOrder == 2;
    }

    void setSortColumn(int columnIndex) {
        if (this.sortColumn == columnIndex) {
            this.sortOrder = this.sortOrder == 0 ? 1 : (this.sortOrder == 1 ? 2 : 0);
        } else {
            this.sortOrder = 0;
            if (this.sortColumn >= 0) {
                this.viewer.getTable().getColumn(this.sortColumn).setImage(null);
            }
        }
        this.setImageForSortOrder(columnIndex, this.sortOrder);
        this.sortColumn = columnIndex;
    }

    private void setImageForSortOrder(int columnIndex, int sorOrder) {
        switch (this.sortOrder) {
            case 0: {
                this.viewer.getTable().getColumn(columnIndex).setImage(UiPlugin.getDefault().getImage("icons/full/cview16/ascending.gif"));
                break;
            }
            case 1: {
                this.viewer.getTable().getColumn(columnIndex).setImage(UiPlugin.getDefault().getImage("icons/full/cview16/descending.gif"));
                break;
            }
            default: {
                this.viewer.getTable().getColumn(columnIndex).setImage(null);
            }
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result = 0;
        if (this.sortColumn >= 0) {
            if (this.sortOrder != 2) {
                result = this.compareColumn((TableViewer)viewer, e1, e2, this.sortColumn);
            }
            if (this.sortOrder == 1) {
                if (result > 0) {
                    result = -1;
                } else if (result < 0) {
                    result = 1;
                }
            }
        }
        this.setImageForSortOrder(this.sortColumn, this.sortOrder);
        return result;
    }
}

