/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.TextViewer;
import org.teiid.designer.ui.common.text.IFontChangeListener;
import org.teiid.designer.ui.common.text.ScaledFont;
import org.teiid.designer.ui.common.text.ScaledFontManager;

public class TextFontManager
implements ScaledFont {
    private TextViewer viewer;
    private ScaledFontManager sfmManager;
    private List listeners = new ArrayList();

    public TextFontManager(TextViewer viewer, ScaledFontManager sfmManager) {
        this.viewer = viewer;
        this.sfmManager = sfmManager;
    }

    @Override
    public void increase() {
        if (this.sfmManager.canIncrease()) {
            this.sfmManager.increase();
            this.updateTextWidget();
        }
    }

    @Override
    public void decrease() {
        if (this.sfmManager.canDecrease()) {
            this.sfmManager.decrease();
            this.updateTextWidget();
        }
    }

    public void updateTextWidget() {
        if (this.sfmManager != null && this.viewer.getTextWidget() != null) {
            this.viewer.getTextWidget().setFont(this.sfmManager.createFontOfSize(this.sfmManager.getSize()));
            this.viewer.getTextWidget().update();
            this.fireFontChanged();
        }
    }

    @Override
    public boolean canIncrease() {
        return this.sfmManager.canIncrease();
    }

    @Override
    public boolean canDecrease() {
        return this.sfmManager.canDecrease();
    }

    @Override
    public void addFontChangeListener(IFontChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeFontChangeListener(IFontChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireFontChanged() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((IFontChangeListener)iter.next()).fontChanged();
        }
    }

    public void setViewer(TextViewer viewer) {
        this.viewer = viewer;
    }
}

