/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.teiid.core.designer.util.CoreArgCheck;

public class CompositeProgressMonitor
implements IProgressMonitor {
    private final Set<IProgressMonitor> monitors = new HashSet<IProgressMonitor>();

    public CompositeProgressMonitor(IProgressMonitor ... monitors) {
        CoreArgCheck.isNotNull((Object)monitors);
        this.monitors.addAll(Arrays.asList(monitors));
    }

    public void beginTask(String name, int totalWork) {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.beginTask(name, totalWork);
        }
    }

    public void done() {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.done();
        }
    }

    public void internalWorked(double work) {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.internalWorked(work);
        }
    }

    public boolean isCanceled() {
        for (IProgressMonitor monitor : this.monitors) {
            if (!monitor.isCanceled()) continue;
            return true;
        }
        return false;
    }

    public void setCanceled(boolean value) {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.setCanceled(value);
        }
    }

    public void setTaskName(String name) {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.setTaskName(name);
        }
    }

    public void subTask(String name) {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.subTask(name);
        }
    }

    public void worked(int work) {
        for (IProgressMonitor monitor : this.monitors) {
            monitor.worked(work);
        }
    }
}

