/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.util;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;

public class LayoutDebugger {
    public static void debugLayout(Composite composite) {
        LayoutDebugger.debugLayout(composite, false, true, null);
    }

    public static void debugLayout(Composite composite, Color gridColor) {
        LayoutDebugger.debugLayout(composite, false, true, gridColor);
    }

    public static void debugLayout(Composite composite, boolean paintDiagonals) {
        LayoutDebugger.debugLayout(composite, paintDiagonals, true, null);
    }

    public static void debugLayout(Composite composite, boolean paintDiagonals, boolean showDistance) {
        LayoutDebugger.debugLayout(composite, paintDiagonals, showDistance, null);
    }

    public static void debugLayout(Composite composite, boolean paintDiagonals, boolean showDistance, Color gridColor) {
        FormDebug debug = new FormDebug();
        if (gridColor == null) {
            gridColor = GlobalUiColorManager.getColor(new RGB(255, 0, 0));
            composite.addDisposeListener((DisposeListener)debug);
        }
        debug.color = gridColor;
        debug.paintDiagonals = paintDiagonals;
        debug.showDistance = showDistance;
        debug.composite = composite;
        LayoutDebugger.listenToCompositeAndKids(composite, debug);
    }

    private static void listenToCompositeAndKids(Composite c, PaintListener l) {
        c.addPaintListener(l);
        Control[] kids = c.getChildren();
        int i = 0;
        while (i < kids.length) {
            Control ctrl = kids[i];
            if (ctrl instanceof Composite) {
                LayoutDebugger.listenToCompositeAndKids((Composite)ctrl, l);
            } else {
                ctrl.addPaintListener(l);
            }
            ++i;
        }
    }

    static class FormDebug
    implements DisposeListener,
    PaintListener {
        Composite composite = null;
        Color color = null;
        boolean paintDiagonals = false;
        boolean showDistance;

        FormDebug() {
        }

        public void paintControl(PaintEvent paintEvent) {
            GC gc = paintEvent.gc;
            gc.setForeground(this.color);
            this.drawOnControl((Control)paintEvent.widget, gc);
        }

        private void drawOnControl(Control ctrl, GC gc) {
            Rectangle r = gc.getClipping();
            if (r.height == 0 || r.width == 0) {
                r = ctrl.getBounds();
            }
            int width = r.width - 1;
            int height = r.height - 1;
            int left = r.x;
            int top = r.y;
            int bottom = top + height;
            int right = left + width;
            if (this.showDistance) {
                int distance = this.getDistanceToDebugged(ctrl);
                int hcenter = (left + right) / 2;
                gc.drawText(Integer.toString(distance), hcenter, top - 2, true);
            }
            if (ctrl instanceof Composite) {
                gc.setLineStyle(3);
            }
            gc.drawRectangle(left, top, width, height);
            if (this.paintDiagonals) {
                gc.drawLine(left, top, right, bottom);
                gc.drawLine(left, bottom, right, top);
            }
        }

        private int getDistanceToDebugged(Control c) {
            int rv = 0;
            Control walker = c;
            while (walker != this.composite) {
                walker = walker.getParent();
                ++rv;
            }
            return rv;
        }

        public void widgetDisposed(DisposeEvent arg0) {
        }
    }
}

