/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.navigator.ResourceNavigator;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.UiPlugin;
import org.teiid.designer.ui.common.util.CloseEditorRunnable;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;

public final class UiUtil
implements UiConstants {
    static IWorkbenchWindow currentWorkbenchWindow;

    public static boolean close(IFile modelFile, boolean save) {
        CloseEditorRunnable runnable = new CloseEditorRunnable(modelFile, save);
        Display.getDefault().syncExec((Runnable)runnable);
        return runnable.didClose;
    }

    public static Image createImage(Image theSourceImage, Color theOldColor, Color theNewColor) {
        CoreArgCheck.isNotNull((Object)theSourceImage);
        CoreArgCheck.isNotNull((Object)theOldColor);
        CoreArgCheck.isNotNull((Object)theNewColor);
        ImageData imageData = (ImageData)theSourceImage.getImageData().clone();
        PaletteData palette = imageData.palette;
        if (palette.isDirect) {
            int y = 0;
            while (y < imageData.height) {
                int x = 0;
                while (x < imageData.width) {
                    int value = imageData.getPixel(x, y);
                    if (palette.getRGB(value).equals((Object)theOldColor.getRGB())) {
                        imageData.setPixel(x, y, palette.getPixel(theNewColor.getRGB()));
                    }
                    ++x;
                }
                ++y;
            }
        } else {
            int i = 0;
            while (i < palette.colors.length) {
                if (palette.colors[i].equals((Object)theOldColor.getRGB())) {
                    palette.colors[i] = theNewColor.getRGB();
                    break;
                }
                ++i;
            }
        }
        return new Image(null, imageData);
    }

    public static int getDialogMessageType(IStatus theStatus) {
        int result = 0;
        switch (theStatus.getSeverity()) {
            case 4: {
                result = 3;
                break;
            }
            case 0: {
                result = 0;
                break;
            }
            case 1: {
                result = 1;
                break;
            }
            case 2: {
                result = 2;
                break;
            }
            default: {
                result = 3;
            }
        }
        return result;
    }

    public static Collection<IEditorPart> getEditorsForFile(IFile file) {
        ArrayList<IEditorPart> results = new ArrayList<IEditorPart>();
        if (file == null) {
            return Collections.emptyList();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return Collections.emptyList();
        }
        IWorkbenchWindow[] workbenchWindows = workbench.getWorkbenchWindows();
        if (workbenchWindows == null || workbenchWindows.length == 0) {
            return Collections.emptyList();
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows;
        int n = workbenchWindows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] pages = window.getPages();
            if (pages != null && pages.length != 0) {
                IWorkbenchPage[] iWorkbenchPageArray = pages;
                int n3 = pages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    IEditorReference[] editors = page.getEditorReferences();
                    if (editors != null && editors.length != 0) {
                        IEditorReference[] iEditorReferenceArray = editors;
                        int n5 = editors.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorInput input;
                            IEditorReference editorReference = iEditorReferenceArray[n6];
                            IEditorPart editor = editorReference.getEditor(false);
                            if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && file.equals((Object)((IFileEditorInput)input).getFile())) {
                                results.add(editor);
                                break;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return results;
    }

    public static IEditorPart getEditorForFile(IFile file, boolean forceOpen) {
        IEditorPart result = null;
        if (file == null) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow[] workbenchWindows = workbench.getWorkbenchWindows();
        if (workbenchWindows == null || workbenchWindows.length == 0) {
            return null;
        }
        IWorkbenchPage firstPage = null;
        IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows;
        int n = workbenchWindows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            if (result == null && (pages = window.getPages()) != null && pages.length != 0) {
                IWorkbenchPage[] iWorkbenchPageArray = pages;
                int n3 = pages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference[] editors;
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    if (firstPage == null) {
                        firstPage = page;
                    }
                    if (result == null && (editors = page.getEditorReferences()) != null && editors.length != 0) {
                        IEditorReference[] iEditorReferenceArray = editors;
                        int n5 = editors.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorInput input;
                            IEditorReference editorReference = iEditorReferenceArray[n6];
                            IEditorPart editor = editorReference.getEditor(false);
                            if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && file.equals((Object)((IFileEditorInput)input).getFile())) {
                                result = editor;
                                break;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (result == null && firstPage != null && forceOpen) {
            try {
                result = IDE.openEditor(firstPage, (IFile)file);
            }
            catch (PartInitException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        return result;
    }

    public static String getPerspectiveId() {
        IWorkbenchPage page = UiUtil.getWorkbenchPage();
        if (page == null) {
            return null;
        }
        IPerspectiveDescriptor descriptor = page.getPerspective();
        if (descriptor == null) {
            return null;
        }
        return descriptor.getId();
    }

    public static ViewerFilter getResourceFilter(String theResourceNavigatorViewId) {
        CoreArgCheck.isNotEmpty((String)theResourceNavigatorViewId);
        ResourcePatternFilter result = null;
        IViewPart view = UiUtil.getViewPart(theResourceNavigatorViewId);
        result = view == null || !(view instanceof ResourceNavigator) ? new ResourcePatternFilter() : ((ResourceNavigator)view).getPatternFilter();
        return result;
    }

    public static Image getStatusImage(IStatus theStatus) {
        Image result = null;
        int severity = theStatus.getSeverity();
        switch (severity) {
            case 4: {
                result = UiPlugin.getDefault().getImage("icons/full/obj16/error_st_obj.gif");
                break;
            }
            case 2: {
                result = UiPlugin.getDefault().getImage("icons/full/obj16/warn_st_obj.gif");
                break;
            }
            case 1: {
                result = UiPlugin.getDefault().getImage("icons/full/obj16/info_st_obj.gif");
                break;
            }
        }
        return result;
    }

    public static IStructuredSelection getStructuredSelection() {
        ISelection selection = UiUtil.getWorkbenchWindowOnlyIfUiThread().getSelectionService().getSelection();
        return selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
    }

    public static Color getSystemColor(int id) {
        return Display.getDefault().getSystemColor(id);
    }

    public static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public static IWorkbenchPage getWorkbenchPage() {
        IWorkbenchWindow window = UiUtil.getWorkbenchWindowOnlyIfUiThread();
        return window == null ? null : window.getActivePage();
    }

    public static IViewPart getViewPart(String theViewId) {
        CoreArgCheck.isNotNull((Object)theViewId);
        IViewPart result = null;
        IWorkbenchPage page = UiUtil.getWorkbenchPage();
        if (page != null) {
            result = page.findView(theViewId);
        }
        return result;
    }

    public static Shell getWorkbenchShellOnlyIfUiThread() {
        return UiUtil.getWorkbenchWindowOnlyIfUiThread().getShell();
    }

    public static IWorkbenchWindow getWorkbenchWindow() {
        UiUtil.runInSwtThread(new Runnable(){

            @Override
            public void run() {
                currentWorkbenchWindow = UiUtil.getWorkbench().getActiveWorkbenchWindow();
            }
        }, true);
        IWorkbenchWindow window = currentWorkbenchWindow;
        currentWorkbenchWindow = null;
        return window;
    }

    public static IWorkbenchWindow getWorkbenchWindowOnlyIfUiThread() {
        IWorkbenchWindow activeWorkbenchWindow = UiUtil.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            throw new RuntimeException("Active workbench window being requested but is not available. This is most certainly a programming bug.");
        }
        return activeWorkbenchWindow;
    }

    public static void openPerspective(String perspectiveId) {
        IWorkbench workbench = UiUtil.getWorkbench();
        IWorkbenchWindow window = UiUtil.getWorkbenchWindow();
        try {
            workbench.showPerspective(perspectiveId, window);
        }
        catch (Exception theException) {
            Util.log((Throwable)theException);
        }
    }

    public static boolean openSystemEditor(File theFile) {
        return UiUtil.openSystemEditor(theFile.getAbsolutePath());
    }

    public static boolean openSystemEditor(IFile theFile) {
        return UiUtil.openSystemEditor(theFile.getLocation().toOSString());
    }

    private static boolean openSystemEditor(final String theFileName) {
        final boolean[] result = new boolean[1];
        UiBusyIndicator.showWhile(Display.getDefault(), new Runnable(){

            @Override
            public void run() {
                if (Program.findProgram((String)FileUtils.getExtension((String)theFileName)) != null) {
                    try {
                        result[0] = Program.launch((String)theFileName);
                    }
                    catch (Throwable theException) {
                        theException.printStackTrace();
                        result[0] = false;
                    }
                }
            }
        });
        return result[0];
    }

    public static void runInSwtThread(Runnable operation, boolean asynchronous) {
        Display display;
        Display display2 = display = Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent();
        if (Thread.currentThread() != display.getThread()) {
            if (asynchronous) {
                display.asyncExec(operation);
            } else {
                display.syncExec(operation);
            }
        } else {
            operation.run();
        }
    }

    public static void save(IDialogSettings theSettings, String theId, List theValues, int theLimit) {
        String[] values = new String[]{};
        if (theValues != null && !theValues.isEmpty()) {
            int size = theValues.size();
            int j = 0;
            if (theLimit > 0 && theValues.size() > theLimit) {
                j = size - theLimit;
                values = new String[theLimit];
            } else {
                values = new String[theValues.size()];
            }
            int i = 0;
            while (i < values.length) {
                values[i] = theValues.get(j++).toString();
                ++i;
            }
        }
        theSettings.put(theId, values);
    }

    public static void savePreferences(IPreferenceStore store) {
        if (store.needsSaving() && store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException err) {
                WidgetUtil.showError(err);
            }
        }
    }

    public static boolean saveDirtyEditors(IShellProvider shellProvider, ISaveableFilter filter, boolean confirm) {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        ProgressMonitorDialog dialog;
        IWorkbench workbench = UiPlugin.getDefault().getWorkbench();
        if (shellProvider == null) {
            shellProvider = workbench.getActiveWorkbenchWindow();
        }
        if (workbench.saveAll(shellProvider, (IRunnableContext)(dialog = new ProgressMonitorDialog(shellProvider.getShell())), filter, confirm) && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            IEditorPart[] dirtyEditors = page.getDirtyEditors();
            if (filter == null) {
                return dirtyEditors.length == 0;
            }
            IEditorPart[] iEditorPartArray = dirtyEditors;
            int n = dirtyEditors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart part = iEditorPartArray[n2];
                if (filter.select(null, new IWorkbenchPart[]{part})) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static boolean showView(String viewId) {
        boolean success = false;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            try {
                activePage.showView(viewId);
                success = true;
            }
            catch (PartInitException partInitException) {}
        }
        return success;
    }

    public static void updateIntegerPreference(String preference, int value, int defaultValue, IPreferenceStore store) {
        int val = store.getInt(preference);
        if (value == defaultValue) {
            if (val != 0) {
                store.setToDefault(preference);
            }
        } else if (value != val) {
            store.setValue(preference, value);
        }
    }

    private UiUtil() {
    }
}

