/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.viewsupport;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.common.UiConstants;

public class JobUtils {
    public static boolean jobExists(String jobName) {
        Job[] allJobs = Job.getJobManager().find(null);
        int i = 0;
        while (i < allJobs.length) {
            if (allJobs[i].getName() != null && allJobs[i].getName().equals(jobName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean jobIsRunning(Object family) {
        IJobManager jobMgr;
        Job currentJob;
        boolean result = false;
        if (family != null && (currentJob = (jobMgr = Job.getJobManager()).currentJob()) != null) {
            return currentJob.belongsTo(family);
        }
        return result;
    }

    public static boolean jobsExist(List theJobFamilies, boolean theMustExistInAllFamiliesFlag) {
        boolean result = false;
        if (theJobFamilies != null && !theJobFamilies.isEmpty()) {
            IJobManager jobMgr = Job.getJobManager();
            int size = theJobFamilies.size();
            int i = 0;
            while (i < size) {
                Object family = theJobFamilies.get(i);
                if (family != null && jobMgr.find(family).length != 0) {
                    result = true;
                }
                if (theMustExistInAllFamiliesFlag && !result || result) break;
                ++i;
            }
        }
        return result;
    }

    public static boolean setAutoBuild(boolean doBuild) {
        IWorkspace workspace = ModelerCore.getWorkspace();
        if (workspace.isAutoBuilding() == doBuild) {
            return false;
        }
        IWorkspaceDescription description = workspace.getDescription();
        description.setAutoBuilding(doBuild);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            UiConstants.Util.log(4, (Throwable)e, UiConstants.Util.getString("JobUtils.autoBuildProblem", new Object[0]));
        }
        return true;
    }

    public static boolean validationJobsExist() {
        ArrayList<Object> families = new ArrayList<Object>(2);
        families.add(ResourcesPlugin.FAMILY_MANUAL_BUILD);
        families.add(ResourcesPlugin.FAMILY_AUTO_BUILD);
        return JobUtils.jobsExist(families, false);
    }

    private JobUtils() {
    }
}

