/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.ui.common.util.WidgetFactory;

public abstract class AbstractVerticalButtonPanel
extends Composite {
    private static final int COLUMN_COUNT = 2;
    private Viewer viewer;
    private Composite buttonBar;
    private Group group;

    protected AbstractVerticalButtonPanel(String name, Composite parent, int style) {
        this(name, parent, style, 1808);
    }

    protected AbstractVerticalButtonPanel(String name, Composite parent, int style, int gridStyle) {
        this(name, parent, style, gridStyle, 1);
    }

    protected AbstractVerticalButtonPanel(String name, Composite parent, int style, int gridStyle, int span) {
        super(parent, 0);
        this.constructVerticalButtonPanel(name, style, gridStyle, span);
    }

    protected void constructVerticalButtonPanel(String name, int style, int gridStyle, int span) {
        CoreArgCheck.isNotEmpty((String)name);
        GridData gridData = new GridData(gridStyle);
        gridData.horizontalSpan = span;
        this.setLayoutData(gridData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.group = WidgetFactory.createGroup(this, name, 1808, 1, 2);
        this.viewer = this.createViewer((Composite)this.group, style | 0x800);
        if (this.viewer != null) {
            this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        }
        this.buttonBar = WidgetFactory.createPanel((Composite)this.group, 8, 4);
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public Group getGroup() {
        return this.group;
    }

    public Button addButton(String name) {
        return WidgetFactory.createButton(this.buttonBar, name, 320);
    }

    protected abstract Viewer createViewer(Composite var1, int var2);

    public IStructuredSelection getSelection() {
        ISelection selection;
        Viewer viewer = this.getViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }
}

