/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TypedListener;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.common.InternalUiConstants;

public class CalendarWidget
extends Composite
implements InternalUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(CalendarWidget.class);
    int m_Day;
    int m_Month;
    int m_Year;
    boolean m_showCalendar;
    boolean m_showTime;
    private Button nextMonth;
    private Button nextYear;
    private Button prevMonth;
    private Button prevYear;
    private Label m_CalendarLabel;
    private TDatePanel m_DatePanel;
    private Spinner m_hourSpinner;
    private Spinner m_minuteSpinner;
    Composite pnlCalendar;
    private Composite pnlTime;

    public CalendarWidget(Composite theParent, int theStyle, boolean theShowTime) {
        this(theParent, theStyle, theShowTime, true);
    }

    public CalendarWidget(Composite theParent, int theStyle, boolean theShowTime, boolean theShowCalendar) {
        super(theParent, theStyle);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.setBackground(Display.getDefault().getSystemColor(2));
        this.m_showTime = theShowTime;
        this.m_showCalendar = theShowCalendar;
        this.construct(this);
        Calendar currentDate = Calendar.getInstance();
        this.m_Day = currentDate.get(5);
        this.m_Month = currentDate.get(2);
        this.m_Year = currentDate.get(1);
        this.m_hourSpinner.setSelection(currentDate.get(11));
        this.m_minuteSpinner.setSelection(currentDate.get(12));
    }

    private void construct(Composite theParent) {
        this.pnlCalendar = new Composite(theParent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                if (!CalendarWidget.this.m_showCalendar) {
                    return new Point(0, 0);
                }
                return super.computeSize(wHint, hHint, changed);
            }
        };
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.pnlCalendar.setLayout((Layout)gridLayout);
        this.pnlCalendar.setLayoutData((Object)new GridData(768));
        this.prevYear = new Button(this.pnlCalendar, 0);
        GridData gridData = new GridData(32);
        gridData.heightHint = 20;
        gridData.widthHint = 20;
        this.prevYear.setLayoutData((Object)gridData);
        this.prevYear.setText("<<");
        this.prevYear.setToolTipText(Util.getString(String.valueOf(PREFIX) + "previousYear", new Object[0]));
        this.prevYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                --CalendarWidget.this.m_Year;
                CalendarWidget.this.updateDate();
            }
        });
        this.prevMonth = new Button(this.pnlCalendar, 0);
        gridData = new GridData(32);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        this.prevMonth.setLayoutData((Object)gridData);
        this.prevMonth.setText("<");
        this.prevMonth.setToolTipText(Util.getString(String.valueOf(PREFIX) + "previousMonth", new Object[0]));
        this.prevMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                --CalendarWidget.this.m_Month;
                CalendarWidget.this.updateDate();
            }
        });
        this.m_CalendarLabel = new Label(this.pnlCalendar, 0x1000000);
        gridData = new GridData(768);
        gridData.heightHint = this.prevYear.computeSize((int)20, (int)20).y;
        int minLabelChars = 20;
        gridData.minimumWidth = this.getMinCalWidth(this.m_CalendarLabel, minLabelChars);
        this.m_CalendarLabel.setLayoutData((Object)gridData);
        this.nextMonth = new Button(this.pnlCalendar, 0);
        gridData = new GridData(128);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        this.nextMonth.setLayoutData((Object)gridData);
        this.nextMonth.setText(">");
        this.nextMonth.setToolTipText(Util.getString(String.valueOf(PREFIX) + "nextMonth", new Object[0]));
        this.nextMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                ++CalendarWidget.this.m_Month;
                CalendarWidget.this.updateDate();
            }
        });
        this.nextYear = new Button(this.pnlCalendar, 0);
        gridData = new GridData(128);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        this.nextYear.setLayoutData((Object)gridData);
        this.nextYear.setText(">>");
        this.nextYear.setToolTipText(Util.getString(String.valueOf(PREFIX) + "nextYear", new Object[0]));
        this.nextYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                ++CalendarWidget.this.m_Year;
                CalendarWidget.this.updateDate();
            }
        });
        this.m_DatePanel = new TDatePanel(this.pnlCalendar, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 5;
        this.m_DatePanel.setLayoutData(gridData);
        this.pnlTime = new Composite(theParent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                if (!CalendarWidget.this.m_showTime) {
                    return new Point(0, 0);
                }
                return super.computeSize(wHint, hHint, changed);
            }
        };
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 4;
        gridLayout2.marginHeight = 1;
        gridLayout2.marginWidth = 1;
        this.pnlTime.setLayout((Layout)gridLayout2);
        Label lblHour = new Label(this.pnlTime, 0);
        lblHour.setText(Util.getString(String.valueOf(PREFIX) + "lblHour", new Object[0]));
        this.m_hourSpinner = new Spinner(this.pnlTime, 0);
        this.m_hourSpinner.setMinimum(0);
        this.m_hourSpinner.setMaximum(23);
        this.m_hourSpinner.setToolTipText(Util.getString(String.valueOf(PREFIX) + "hourSpinner.toolTip", new Object[]{this.m_hourSpinner.getMinimum(), this.m_hourSpinner.getMaximum()}));
        Label lblMinute = new Label(this.pnlTime, 0);
        lblMinute.setText(Util.getString(String.valueOf(PREFIX) + "lblMinute", new Object[0]));
        this.m_minuteSpinner = new Spinner(this.pnlTime, 0);
        this.m_minuteSpinner.setMinimum(0);
        this.m_minuteSpinner.setMaximum(59);
        this.m_minuteSpinner.setToolTipText(Util.getString(String.valueOf(PREFIX) + "minuteSpinner.toolTip", new Object[]{this.m_minuteSpinner.getMinimum(), this.m_minuteSpinner.getMaximum()}));
        if (!this.m_showCalendar) {
            this.showCalendar(false);
        }
        if (!this.m_showTime) {
            this.showTime(false);
        }
        this.panelChanged();
    }

    private int getMinCalWidth(Label label, int nChars) {
        int widthPixels = 0;
        GC gc = new GC((Drawable)label);
        gc.setFont(label.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        widthPixels = fontMetrics.getAverageCharWidth() * nChars;
        gc.dispose();
        return widthPixels;
    }

    public void addSelectionListener(SelectionListener theListener) {
        this.checkWidget();
        if (theListener == null) {
            SWT.error((int)4);
        }
        if (this.m_showCalendar) {
            TypedListener typedListener = new TypedListener((SWTEventListener)theListener);
            this.addListener(13, (Listener)typedListener);
            this.addListener(14, (Listener)typedListener);
            this.prevMonth.addSelectionListener(theListener);
            this.prevYear.addSelectionListener(theListener);
            this.nextMonth.addSelectionListener(theListener);
            this.nextYear.addSelectionListener(theListener);
        }
        if (this.m_showTime) {
            this.m_hourSpinner.addSelectionListener(theListener);
            this.m_minuteSpinner.addSelectionListener(theListener);
        }
    }

    void dateSelected(boolean good) {
        Event event = new Event();
        event.doit = good;
        this.m_DatePanel.redraw();
        this.notifyListeners(13, event);
    }

    public Date getDate() {
        Calendar date = Calendar.getInstance();
        date.set(2, this.getMonth());
        date.set(5, this.getDay());
        date.set(1, this.getYear());
        return new Date(date.getTime().getTime());
    }

    public int getDay() {
        return this.m_Day;
    }

    public int getHour() {
        return this.m_hourSpinner.getSelection();
    }

    public int getMinute() {
        return this.m_minuteSpinner.getSelection();
    }

    public int getMonth() {
        return this.m_Month;
    }

    private String getMonthName(int theMonth) {
        return this.m_DatePanel.getMonthName(theMonth - 1);
    }

    public Time getTime() {
        Calendar date = Calendar.getInstance();
        date.set(11, this.m_hourSpinner.getSelection());
        date.set(12, this.m_minuteSpinner.getSelection());
        date.set(13, 0);
        date.set(14, 0);
        return new Time(date.getTime().getTime());
    }

    public Timestamp getTimestamp() {
        Calendar date = Calendar.getInstance();
        date.set(2, this.getMonth());
        date.set(5, this.getDay());
        date.set(1, this.getYear());
        date.set(11, this.m_hourSpinner.getSelection());
        date.set(12, this.m_minuteSpinner.getSelection());
        date.set(13, 0);
        date.set(14, 0);
        return new Timestamp(date.getTime().getTime());
    }

    public int getYear() {
        return this.m_Year;
    }

    public boolean isDateWidget() {
        return this.m_showCalendar && !this.m_showTime;
    }

    public boolean isTimeWidget() {
        return !this.m_showCalendar && this.m_showTime;
    }

    public boolean isTimestampWidget() {
        return this.m_showCalendar && this.m_showTime;
    }

    void normalizeDay() {
        Calendar calendar = Calendar.getInstance();
        if (this.m_showCalendar) {
            calendar.set(1, this.m_Year);
            calendar.set(2, this.m_Month);
            calendar.set(5, this.m_Day);
            this.m_Year = calendar.get(1);
            this.m_Month = calendar.get(2);
            this.m_Day = calendar.get(5);
        }
        if (this.m_showTime) {
            calendar.set(11, this.m_hourSpinner.getSelection());
            calendar.set(12, this.m_minuteSpinner.getSelection());
            this.m_hourSpinner.setSelection(calendar.get(11));
            this.m_minuteSpinner.setSelection(calendar.get(12));
        }
    }

    void panelChanged() {
        if (this.m_showCalendar) {
            this.m_CalendarLabel.setText(String.valueOf(this.getMonthName(this.m_Month + 1)) + ", " + this.m_Year);
        }
    }

    public void removeSelectionListener(SelectionListener theListener) {
        this.checkWidget();
        if (theListener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)theListener);
        this.removeListener(14, (SWTEventListener)theListener);
    }

    public void setValue(Date theDate) {
        Calendar date = Calendar.getInstance();
        date.setTime(theDate);
        this.m_Day = date.get(5);
        this.m_Month = date.get(2);
        this.m_Year = date.get(1);
        this.panelChanged();
    }

    public void setValue(Time theTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(theTime);
        this.m_hourSpinner.setSelection(date.get(11));
        this.m_minuteSpinner.setSelection(date.get(12));
        this.panelChanged();
    }

    public void setValue(Timestamp theTimestamp) {
        Calendar date = Calendar.getInstance();
        date.setTime(theTimestamp);
        this.m_Day = date.get(5);
        this.m_Month = date.get(2);
        this.m_Year = date.get(1);
        this.m_hourSpinner.setSelection(date.get(11));
        this.m_minuteSpinner.setSelection(date.get(12));
        this.panelChanged();
    }

    public void showCalendar(boolean theShowFlag) {
        this.m_showCalendar = theShowFlag;
        this.pnlCalendar.setVisible(theShowFlag);
    }

    public void showTime(boolean theShowFlag) {
        this.m_showTime = theShowFlag;
        this.pnlTime.setVisible(theShowFlag);
    }

    void updateDate() {
        this.normalizeDay();
        this.m_DatePanel.redraw();
        this.panelChanged();
    }

    private class TDatePanel
    extends Canvas {
        private Display m_Display;
        private Calendar m_Calendar;
        private int m_ColSize;
        private int m_RowSize;
        private String[] m_Days;
        private String[] m_Months;

        public TDatePanel(Composite parent, int style) {
            super(parent, style | 0x40000 | 0x100000);
            this.m_Display = Display.getCurrent();
            this.m_Calendar = Calendar.getInstance();
            this.m_Days = new String[7];
            this.m_Months = new String[12];
            Calendar cal = Calendar.getInstance();
            CalendarWidget.this.m_Year = cal.get(1);
            CalendarWidget.this.m_Month = cal.get(2);
            CalendarWidget.this.m_Day = cal.get(5);
            SimpleDateFormat format = new SimpleDateFormat("EE");
            int i = 1;
            while (i <= 7) {
                cal.set(7, i);
                this.m_Days[i - 1] = format.format(cal.getTime()).substring(0, 2);
                ++i;
            }
            format = new SimpleDateFormat("MMMM");
            i = 0;
            while (i < 12) {
                cal.set(2, i);
                this.m_Months[i] = format.format(cal.getTime());
                ++i;
            }
            GC gc = new GC((Drawable)this);
            Point p = gc.stringExtent("Q");
            gc.dispose();
            this.m_ColSize = p.x * 3;
            this.m_RowSize = (int)((double)p.y * 1.2);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    TDatePanel.this.onPaint(event);
                }
            });
            this.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    TDatePanel.this.redraw();
                }
            });
            this.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    TDatePanel.this.onKeyDown(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TDatePanel.this.onMouseDown(e);
                }
            });
        }

        private int calendarDayToNormal(int theDay) {
            switch (theDay) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 5;
                }
                case 7: {
                    return 6;
                }
            }
            return -1;
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Point size = CalendarWidget.this.pnlCalendar.getSize();
            this.m_ColSize = (int)((double)size.x / 7.0);
            return new Point((int)((double)size.x / 7.0 * 7.0), this.m_RowSize * 7);
        }

        private int getDayFromPoint(int x, int y) {
            int i = 1;
            while (i <= 31) {
                Point p = this.getDayPoint(i);
                Rectangle r = new Rectangle(p.x, p.y, this.m_ColSize, this.m_RowSize);
                if (r.contains(x, y)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private String getDayName(int day) {
            return this.m_Days[day];
        }

        private Point getDayPoint(int day) {
            this.m_Calendar.set(1, CalendarWidget.this.m_Year);
            this.m_Calendar.set(2, CalendarWidget.this.m_Month);
            this.m_Calendar.set(5, 1);
            int first_day_of_week = this.calendarDayToNormal(this.m_Calendar.get(7)) - 1;
            this.m_Calendar.set(5, day);
            int day_of_week = this.calendarDayToNormal(this.m_Calendar.get(7));
            int x = day_of_week * this.m_ColSize;
            int y = (1 + (first_day_of_week + day) / 7) * this.m_RowSize;
            return new Point(x, y);
        }

        private int getMaxDay() {
            this.m_Calendar.set(1, CalendarWidget.this.m_Year);
            this.m_Calendar.set(2, CalendarWidget.this.m_Month);
            int day = 28;
            int i = 0;
            while (i < 10) {
                this.m_Calendar.set(5, day);
                if (this.m_Calendar.get(2) != CalendarWidget.this.m_Month) {
                    return day - 1;
                }
                ++day;
                ++i;
            }
            return -1;
        }

        String getMonthName(int month) {
            return this.m_Months[month];
        }

        void onKeyDown(KeyEvent theEvent) {
            if (theEvent.character == '\u001b') {
                CalendarWidget.this.dateSelected(false);
                return;
            }
            if (theEvent.character == ' ' || theEvent.character == '\r') {
                CalendarWidget.this.dateSelected(true);
                return;
            }
            int oldDay = CalendarWidget.this.m_Day--;
            int oldMonth = CalendarWidget.this.m_Month--;
            if (theEvent.keyCode != 0x1000003) {
                if (theEvent.keyCode == 0x1000004) {
                    ++CalendarWidget.this.m_Day;
                } else if (theEvent.keyCode == 0x1000001) {
                    CalendarWidget.this.m_Day -= 7;
                    if (CalendarWidget.this.m_Day < 1) {
                        CalendarWidget.this.m_Day = oldDay;
                    }
                } else if (theEvent.keyCode == 0x1000002) {
                    CalendarWidget.this.m_Day += 7;
                    if (CalendarWidget.this.m_Day > this.getMaxDay()) {
                        CalendarWidget.this.m_Day = oldDay;
                    }
                } else if (theEvent.keyCode != 0x1000005 && theEvent.keyCode == 0x1000006) {
                    ++CalendarWidget.this.m_Month;
                }
            }
            CalendarWidget.this.normalizeDay();
            if (CalendarWidget.this.m_Day != oldDay || CalendarWidget.this.m_Month != oldMonth) {
                this.redraw();
                if (CalendarWidget.this.m_Month != oldMonth) {
                    CalendarWidget.this.panelChanged();
                }
            }
        }

        void onMouseDown(MouseEvent theEvent) {
            int day = this.getDayFromPoint(theEvent.x, theEvent.y);
            if (day > 0) {
                CalendarWidget.this.m_Day = day;
                CalendarWidget.this.dateSelected(true);
            }
        }

        void onPaint(PaintEvent event) {
            Rectangle rect = this.getClientArea();
            GC gc0 = event.gc;
            Image image = new Image((Device)this.m_Display, rect.width, rect.height);
            GC gc = new GC((Drawable)image);
            gc.setBackground(this.m_Display.getSystemColor(22));
            gc.fillRectangle(rect);
            int x = 0;
            int y = 0;
            int i = 0;
            while (i < 7) {
                if (i == 0) {
                    gc.setForeground(this.m_Display.getSystemColor(3));
                } else {
                    gc.setForeground(this.m_Display.getSystemColor(2));
                }
                String text = this.getDayName(i);
                Point size = gc.stringExtent(text);
                gc.drawText(text, x + (this.m_ColSize - size.x) / 2, (this.m_RowSize - size.y) / 2, true);
                x += this.m_ColSize;
                ++i;
            }
            gc.setForeground(this.m_Display.getSystemColor(2));
            gc.drawLine(0, 0, rect.width, 0);
            gc.drawLine(0, (y += this.m_RowSize) - 1, rect.width, y - 1);
            this.m_Calendar.set(1, CalendarWidget.this.m_Year);
            this.m_Calendar.set(2, CalendarWidget.this.m_Month);
            int day = 1;
            Font stdFont = gc.getFont();
            FontData fontData = stdFont.getFontData()[0];
            Font boldFont = new Font(null, fontData.getName(), fontData.getHeight(), 1);
            while (true) {
                this.m_Calendar.set(5, day);
                if (this.m_Calendar.get(2) != CalendarWidget.this.m_Month) break;
                int day_of_week = this.calendarDayToNormal(this.m_Calendar.get(7));
                Point p = this.getDayPoint(day);
                if (day == CalendarWidget.this.m_Day) {
                    gc.setFont(boldFont);
                    gc.setForeground(this.m_Display.getSystemColor(2));
                    gc.setBackground(this.m_Display.getSystemColor(26));
                } else {
                    gc.setFont(stdFont);
                    gc.setBackground(this.m_Display.getSystemColor(22));
                    if (day_of_week == 0) {
                        gc.setForeground(this.m_Display.getSystemColor(3));
                    } else {
                        gc.setForeground(this.m_Display.getSystemColor(2));
                    }
                }
                String text = "" + day;
                Point size = gc.stringExtent(text);
                gc.drawText(text, p.x + (this.m_ColSize - size.x) / 2, p.y + (this.m_RowSize - size.y) / 2, true);
                ++day;
            }
            gc0.drawImage(image, 0, 0);
            gc.dispose();
            image.dispose();
        }
    }
}

