/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.common.ICredentialsCommon;
import org.teiid.designer.ui.common.UiConstants;

public class CredentialsComposite
extends Composite
implements UiConstants,
Listener,
ICredentialsCommon {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(CredentialsComposite.class);
    private Label securityLabel;
    protected Combo securityCombo;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    boolean handlingEvent = false;
    protected ICredentialsCommon.SecurityType securityType = ICredentialsCommon.SecurityType.None;
    private String password;
    private String userName;

    public CredentialsComposite(Composite parent, int style, String wsType) {
        super(parent, style);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo((Composite)this);
        this.securityLabel = new Label((Composite)this, 0);
        this.securityLabel.setText(Util.getString(String.valueOf(PREFIX) + "Common.Security.Type.Label", new Object[0]));
        this.securityLabel.setToolTipText(Util.getString(String.valueOf(PREFIX) + "Common.Context.Factory.ToolTip", new Object[0]));
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)this.securityLabel);
        this.securityCombo = new Combo((Composite)this, 2060);
        if ("rest".equals(wsType)) {
            this.securityCombo.setItems(new String[]{ICredentialsCommon.SecurityType.None.name(), ICredentialsCommon.SecurityType.HTTPBasic.name(), ICredentialsCommon.SecurityType.Digest.name()});
            this.securityCombo.setText(ICredentialsCommon.SecurityType.None.name());
        } else {
            this.securityCombo.setItems(new String[]{ICredentialsCommon.SecurityType.None.name(), ICredentialsCommon.SecurityType.HTTPBasic.name()});
            this.securityCombo.setText(ICredentialsCommon.SecurityType.None.name());
        }
        this.securityCombo.setToolTipText(Util.getString(String.valueOf(PREFIX) + "Common.Context.Factory.ToolTip", new Object[0]));
        this.securityCombo.addListener(24, (Listener)this);
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)this.securityCombo);
        this.usernameLabel = new Label((Composite)this, 0);
        this.usernameLabel.setText(Util.getString(String.valueOf(PREFIX) + "Common.Username.Label", new Object[0]));
        this.usernameLabel.setToolTipText(Util.getString(String.valueOf(PREFIX) + "Common.Username.ToolTip", new Object[0]));
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)this.usernameLabel);
        this.usernameText = new Text((Composite)this, 2052);
        this.usernameText.setToolTipText(Util.getString(String.valueOf(PREFIX) + "Common.Username.ToolTip", new Object[0]));
        this.usernameText.setEnabled(false);
        this.usernameText.addListener(24, (Listener)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.usernameText);
        this.passwordLabel = new Label((Composite)this, 0);
        this.passwordLabel.setText(Util.getString(String.valueOf(PREFIX) + "Common.Password.Label", new Object[0]));
        this.passwordLabel.setToolTipText(Util.getString(String.valueOf(PREFIX) + "Common.Password.ToolTip", new Object[0]));
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)this.passwordLabel);
        this.passwordText = new Text((Composite)this, 0x400804);
        this.passwordText.setToolTipText(Util.getString(String.valueOf(PREFIX) + "Common.Password.ToolTip", new Object[0]));
        this.passwordText.setEnabled(false);
        this.passwordText.addListener(24, (Listener)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.passwordText);
    }

    public void handleEvent(Event event) {
        if (!this.handlingEvent) {
            this.handlingEvent = true;
            if (event.widget == this.securityCombo) {
                if (this.securityCombo.getText().equals(ICredentialsCommon.SecurityType.None.name())) {
                    this.usernameText.setText("");
                    this.usernameText.setEnabled(false);
                    this.passwordText.setText("");
                    this.passwordText.setEnabled(false);
                } else {
                    this.usernameText.setEnabled(true);
                    this.passwordText.setEnabled(true);
                }
            }
            this.securityType = ICredentialsCommon.SecurityType.valueOf(this.securityCombo.getText());
            this.userName = this.usernameText.getText();
            this.password = this.passwordText.getText();
            this.handlingEvent = false;
        }
    }

    public void addSecurityOptionListener(int eventType, Listener listener) {
        this.securityCombo.addListener(eventType, listener);
    }

    public void addUserNameListener(int eventType, Listener listener) {
        this.usernameText.addListener(eventType, listener);
    }

    public void addPasswordListener(int eventType, Listener listener) {
        this.passwordText.addListener(eventType, listener);
    }

    public ICredentialsCommon.SecurityType getSecurityOption() {
        return this.securityType;
    }

    public void setSecurityOption(String securityValue) {
        this.securityType = ICredentialsCommon.SecurityType.valueOf(securityValue);
        this.securityCombo.setText(securityValue);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userNameValue) {
        this.userName = userNameValue;
        this.usernameText.setText(userNameValue);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String passwordValue) {
        this.password = passwordValue;
        this.passwordText.setText(passwordValue);
    }
}

