/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget;

import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.teiid.designer.ui.common.tree.TreeViewerUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.common.widget.ICheckableController;
import org.teiid.designer.ui.common.widget.INodeDescendantsDeselectionHandler;

public class InheritanceCheckboxTreeViewer
extends CheckboxTreeViewer
implements ICheckStateListener {
    public static final int UNCHECKED_WHITE = 1;
    public static final int UNCHECKED_GRAYED = 2;
    public static final int CHECKED_WHITE_IF_ALL_DESCENDANTS_CHECKED_ELSE_UNCHECKED_GRAYED = 3;
    public static final int CHECKED_WHITE_IF_ALL_DESCENDANTS_CHECKED_ELSE_CHECKED_GRAYED_IF_ANY_CHECKED = 4;
    int uncheckedNodeWithCheckedDescendantsStyle;
    private boolean listenerEnabled = true;
    private INodeDescendantsDeselectionHandler deselectionHandler;
    private ICheckableController checkController;

    public InheritanceCheckboxTreeViewer(Tree tree, int style, INodeDescendantsDeselectionHandler deselectionHandler) {
        super(tree);
        this.uncheckedNodeWithCheckedDescendantsStyle = style;
        this.deselectionHandler = deselectionHandler;
        this.addCheckStateListener(this);
    }

    public Object getRoot() {
        return super.getRoot();
    }

    public void setListenerEnabled(boolean state) {
        this.listenerEnabled = state;
    }

    public void setCheckableController(ICheckableController theController) {
        this.checkController = theController;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (this.checkController != null && !this.checkController.isEditable(event.getElement())) {
            this.setChecked(event.getElement(), !event.getChecked());
        } else if (this.listenerEnabled) {
            boolean hasDescendant;
            this.listenerEnabled = false;
            final InheritanceCheckboxTreeViewer viewer = this;
            final ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
            final boolean isChecked = event.getChecked();
            final Object node = event.getElement();
            boolean deselecting = false;
            if (!isChecked && contentProvider != null && (hasDescendant = contentProvider.hasChildren(node))) {
                deselecting = this.deselectionHandler.deselectDescendants(node);
            }
            final boolean deselectingDescendants = deselecting;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    block29: {
                        block28: {
                            if (!isChecked) break block28;
                            viewer.setGrayed(node, false);
                            List descendants = TreeViewerUtil.getDescendantsOfNode((TreeViewer)viewer, node, false);
                            for (Object curNode : descendants) {
                                viewer.setChecked(curNode, true);
                                viewer.setGrayed(curNode, false);
                            }
                            if (viewer.uncheckedNodeWithCheckedDescendantsStyle == 1 || contentProvider == null) break block29;
                            Object parent = contentProvider.getParent(node);
                            switch (viewer.uncheckedNodeWithCheckedDescendantsStyle) {
                                case 2: {
                                    while (parent != null) {
                                        viewer.setGrayed(parent, true);
                                        parent = contentProvider.getParent(parent);
                                    }
                                    break block29;
                                }
                                case 3: {
                                    boolean allDescendantsChecked = true;
                                    while (parent != null) {
                                        if (allDescendantsChecked) {
                                            allDescendantsChecked = TreeViewerUtil.allDescendantsChecked(viewer, parent);
                                        }
                                        if (allDescendantsChecked) {
                                            viewer.setChecked(parent, true);
                                            viewer.setGrayed(parent, false);
                                        } else {
                                            viewer.setGrayed(parent, true);
                                        }
                                        parent = contentProvider.getParent(parent);
                                    }
                                    break block29;
                                }
                                case 4: {
                                    boolean anyDescendantsChecked2 = false;
                                    boolean allDescendantsChecked2 = true;
                                    while (parent != null) {
                                        anyDescendantsChecked2 = TreeViewerUtil.anyDescendantChecked(viewer, parent);
                                        if (allDescendantsChecked2) {
                                            allDescendantsChecked2 = TreeViewerUtil.allDescendantsChecked(viewer, parent);
                                        }
                                        if (allDescendantsChecked2) {
                                            viewer.setChecked(parent, true);
                                            viewer.setGrayed(parent, false);
                                        } else if (anyDescendantsChecked2) {
                                            viewer.setChecked(parent, true);
                                            viewer.setGrayed(parent, true);
                                        } else {
                                            viewer.setGrayed(parent, true);
                                        }
                                        parent = contentProvider.getParent(parent);
                                    }
                                    break block29;
                                }
                            }
                            break block29;
                        }
                        if (contentProvider != null) {
                            if (deselectingDescendants) {
                                List descendants = TreeViewerUtil.getDescendantsOfNode((TreeViewer)viewer, node, true);
                                for (Object curNode : descendants) {
                                    viewer.setChecked(curNode, false);
                                    viewer.setGrayed(curNode, false);
                                }
                            }
                            boolean anyDescendantChecked = false;
                            Object parent = node;
                            while (parent != null) {
                                viewer.setChecked(parent, false);
                                if (viewer.uncheckedNodeWithCheckedDescendantsStyle != 1) {
                                    if (!anyDescendantChecked) {
                                        anyDescendantChecked = TreeViewerUtil.anyDescendantChecked(viewer, parent);
                                    }
                                    switch (viewer.uncheckedNodeWithCheckedDescendantsStyle) {
                                        case 2: {
                                            viewer.setGrayed(parent, anyDescendantChecked);
                                            viewer.setChecked(parent, false);
                                            break;
                                        }
                                        case 3: {
                                            viewer.setGrayed(parent, anyDescendantChecked);
                                            viewer.setChecked(parent, false);
                                            break;
                                        }
                                        case 4: {
                                            viewer.setGrayed(parent, anyDescendantChecked);
                                            viewer.setChecked(parent, anyDescendantChecked);
                                            break;
                                        }
                                    }
                                }
                                parent = contentProvider.getParent(parent);
                            }
                        }
                    }
                }
            };
            UiBusyIndicator.showWhile(null, runnable);
            this.listenerEnabled = true;
        }
    }
}

