/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget;

import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.AbstractVerticalButtonPanel;
import org.teiid.designer.ui.common.widget.IListPanelController;

public class ListPanel
extends AbstractVerticalButtonPanel
implements CoreStringUtil.Constants,
InternalUiConstants.Widgets {
    private IListPanelController ctrlr;
    Button addButton;
    Button editButton;
    Button removeButton;
    Button upButton;
    Button downButton;
    Button selectAllButton;
    Button deselectAllButton;
    private boolean enabled = super.getEnabled();
    private ListenerList checkStateListeners;

    public ListPanel(Composite parent, String title, IListPanelController controller) {
        this(parent, title, controller, 0);
    }

    public ListPanel(Composite parent, String title, IListPanelController controller, int style) {
        this(parent, title, controller, style, 0);
    }

    public ListPanel(Composite parent, String title, IListPanelController controller, int style, int itemStyle) {
        this(parent, title, controller, style, itemStyle, 1808);
    }

    public ListPanel(Composite parent, String title, IListPanelController controller, int style, int itemStyle, int gridStyle) {
        this(parent, title, controller, style, itemStyle, gridStyle, null);
    }

    public ListPanel(Composite parent, String title, IListPanelController controller, int style, int itemStyle, List items) {
        this(parent, title, controller, style, itemStyle, 1808, items);
    }

    public ListPanel(Composite parent, String title, IListPanelController controller, int style, int itemStyle, int gridStyle, List items) {
        super(title, parent, style);
        this.constructListEditPanel(controller, itemStyle, gridStyle, items);
    }

    protected void constructListEditPanel(IListPanelController controller, int itemStyle, int gridStyle, List items) {
        int style;
        CoreArgCheck.isNotNull((Object)controller);
        this.ctrlr = controller;
        TableViewer viewer = this.getTableViewer();
        if (items != null && !items.isEmpty()) {
            viewer.add(items.toArray());
        }
        if (((style = viewer.getControl().getStyle()) & 8) == 0) {
            this.addButton = this.addButton(ADD_BUTTON);
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ListPanel.this.addButtonSelected();
                }
            });
        }
        if ((itemStyle & 2) != 0) {
            this.editButton = this.addButton(EDIT_BUTTON);
            this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ListPanel.this.editButtonSelected();
                }
            });
            viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (ListPanel.this.editButton.isEnabled()) {
                        ListPanel.this.editButtonSelected();
                    }
                }
            });
        }
        if ((style & 8) == 0) {
            this.removeButton = this.addButton(REMOVE_BUTTON);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ListPanel.this.removeButtonSelected();
                }
            });
        }
        if ((itemStyle & 1) != 0) {
            this.upButton = this.addButton(UP_BUTTON);
            this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ListPanel.this.upButtonSelected();
                }
            });
            this.downButton = this.addButton(DOWN_BUTTON);
            this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ListPanel.this.downButtonSelected();
                }
            });
        }
        if ((itemStyle & 4) != 0) {
            this.selectAllButton = this.addButton(SELECT_ALL_BUTTON);
            this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ListPanel.this.selectAllButtonSelected();
                }
            });
            this.deselectAllButton = this.addButton(DESELECT_ALL_BUTTON);
            this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ListPanel.this.deselectAllButtonSelected();
                }
            });
        }
        this.updateButtons();
    }

    public TableViewer getTableViewer() {
        return (TableViewer)this.getViewer();
    }

    public void addCheckStateListener(ICheckStateListener theListener) {
        if (this.getViewer() instanceof CheckboxTableViewer) {
            if (this.checkStateListeners == null) {
                this.checkStateListeners = new ListenerList(1);
            }
            this.checkStateListeners.add((Object)theListener);
        }
    }

    public void removeCheckStateListener(ICheckStateListener theListener) {
        if (this.checkStateListeners != null) {
            this.checkStateListeners.remove((Object)theListener);
        }
    }

    void notifyCheckStateListeners(final CheckStateChangedEvent theEvent) {
        if (this.checkStateListeners != null) {
            Object[] array = this.checkStateListeners.getListeners();
            int i = 0;
            while (i < array.length) {
                final ICheckStateListener l = (ICheckStateListener)array[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.checkStateChanged(theEvent);
                    }

                    public void handleException(Throwable theEvent2) {
                        super.handleException(theEvent2);
                        ListPanel.this.removeCheckStateListener(l);
                    }
                });
                ++i;
            }
        }
    }

    @Override
    protected Viewer createViewer(Composite parent, int style) {
        if (WidgetUtil.hasState(style, 32)) {
            final CheckListPanelViewer viewer = new CheckListPanelViewer(parent, style);
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ListPanel.this.itemsSelected((IStructuredSelection)event.getSelection());
                }
            });
            viewer.addCheckStateListenerAccess(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent theEvent) {
                    if (!ListPanel.this.getEnabled() && theEvent.getSource() != this) {
                        viewer.setChecked(theEvent.getElement(), !theEvent.getChecked());
                    } else {
                        ListPanel.this.notifyCheckStateListeners(theEvent);
                    }
                }
            });
            return viewer;
        }
        ListPanelViewer viewer = new ListPanelViewer(parent, style);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ListPanel.this.itemsSelected((IStructuredSelection)event.getSelection());
            }
        });
        return viewer;
    }

    public void addItem(Object item) {
        this.addItems(new Object[]{item});
    }

    public void addItems(Object[] items) {
        if (items.length > 0) {
            TableViewer viewer = this.getTableViewer();
            viewer.add(items);
            viewer.setSelection((ISelection)new StructuredSelection(items));
            this.updateButtons();
        }
    }

    public void clear() {
        TableViewer viewer = this.getTableViewer();
        Object obj = viewer.getElementAt(0);
        while (obj != null) {
            viewer.remove(obj);
            obj = viewer.getElementAt(0);
        }
    }

    public boolean contains(Object element) {
        CoreArgCheck.isNotNull((Object)element);
        TableItem[] items = this.getTableViewer().getTable().getItems();
        int ndx = items.length;
        while (--ndx >= 0) {
            if (!element.equals(items[ndx].getData())) continue;
            return true;
        }
        return false;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.getParent().isEnabled();
    }

    public void setEnabled(boolean theEnableFlag) {
        this.enabled = theEnableFlag;
        this.updateButtons();
        int colorCode = theEnableFlag ? 1 : 22;
        this.getViewer().getControl().setBackground(UiUtil.getSystemColor(colorCode));
        if (!theEnableFlag) {
            this.getTableViewer().setCellEditors(null);
        }
    }

    public Button getButton(String buttonNameConstant) {
        if (ADD_BUTTON.equals(buttonNameConstant)) {
            return this.addButton;
        }
        if (DESELECT_ALL_BUTTON.equals(buttonNameConstant)) {
            return this.deselectAllButton;
        }
        if (DOWN_BUTTON.equals(buttonNameConstant)) {
            return this.downButton;
        }
        if (EDIT_BUTTON.equals(buttonNameConstant)) {
            return this.editButton;
        }
        if (REMOVE_BUTTON.equals(buttonNameConstant)) {
            return this.removeButton;
        }
        if (SELECT_ALL_BUTTON.equals(buttonNameConstant)) {
            return this.selectAllButton;
        }
        if (UP_BUTTON.equals(buttonNameConstant)) {
            return this.upButton;
        }
        return null;
    }

    @Override
    public Button addButton(String name) {
        Button button = super.addButton(name);
        button.moveBelow((Control)this.addButton);
        return button;
    }

    public void updateButtons() {
        boolean itemsSelected;
        boolean itemsExist;
        TableViewer viewer = this.getTableViewer();
        IStructuredSelection selection = this.getSelection();
        int count = selection.size();
        int itemCount = viewer.getTable().getItemCount();
        boolean bl = itemsExist = itemCount > 0;
        if (this.editButton != null) {
            this.editButton.setEnabled(this.getEnabled() && count == 1);
        }
        boolean bl2 = itemsSelected = count > 0;
        if (this.removeButton != null) {
            this.removeButton.setEnabled(this.getEnabled() && itemsSelected);
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(this.getEnabled() && itemsSelected && selection.getFirstElement() != viewer.getElementAt(0));
            if (itemsExist && itemsSelected) {
                Object lastSelectedObj = selection.toArray()[count - 1];
                Object lastObj = viewer.getElementAt(itemCount - 1);
                this.downButton.setEnabled(this.getEnabled() && lastSelectedObj != lastObj);
            } else {
                this.downButton.setEnabled(false);
            }
        }
        if (this.selectAllButton != null) {
            this.selectAllButton.setEnabled(this.getEnabled() && itemsExist && count < itemCount);
            this.deselectAllButton.setEnabled(this.getEnabled() && itemsExist && itemsSelected);
        }
        if (this.addButton != null) {
            this.addButton.setEnabled(this.getEnabled());
        }
    }

    void addButtonSelected() {
        Object[] items = this.ctrlr.addButtonSelected();
        if (items != null) {
            this.addItems(items);
        }
    }

    void deselectAllButtonSelected() {
        this.getViewer().setSelection((ISelection)new StructuredSelection());
    }

    void downButtonSelected() {
        this.ctrlr.downButtonSelected(this.getSelection());
        this.moveItems(1);
    }

    void editButtonSelected() {
        Object item = this.ctrlr.editButtonSelected(this.getSelection());
        if (item != null) {
            TableViewer viewer = this.getTableViewer();
            viewer.getTable().getSelection()[0].setData(item);
            viewer.update(item, null);
            this.itemsSelected(this.getSelection());
        }
    }

    void itemsSelected(IStructuredSelection selection) {
        this.ctrlr.itemsSelected(selection);
        this.updateButtons();
    }

    void removeButtonSelected() {
        Object[] items = this.ctrlr.removeButtonSelected(this.getSelection());
        if (items.length > 0) {
            this.getTableViewer().remove(items);
            this.updateButtons();
        }
    }

    void selectAllButtonSelected() {
        ListPanelViewer viewer = (ListPanelViewer)this.getViewer();
        viewer.setSelection((ISelection)new StructuredSelection(viewer.getRawChildren(viewer.getInput())));
    }

    void upButtonSelected() {
        this.ctrlr.upButtonSelected(this.getSelection());
        this.moveItems(-1);
    }

    private void moveItems(int direction) {
        TableViewer viewer = this.getTableViewer();
        Table table = viewer.getTable();
        int[] rows = table.getSelectionIndices();
        Object[] items = new Object[rows.length * 2];
        int ndx = 0;
        while (ndx < rows.length) {
            int rowsNdx = direction < 0 ? ndx : rows.length - ndx - 1;
            int row = rows[rowsNdx];
            TableItem srcTableItem = table.getItem(row);
            TableItem destTableItem = table.getItem(row + direction);
            Object srcItem = srcTableItem.getData();
            Object destItem = destTableItem.getData();
            destTableItem.setData(srcItem);
            srcTableItem.setData(destItem);
            int itemsNdx = ndx * 2;
            items[itemsNdx] = srcItem;
            items[itemsNdx + 1] = destItem;
            int n = rowsNdx;
            rows[n] = rows[n] + direction;
            ++ndx;
        }
        viewer.update(items, null);
        table.setSelection(rows);
        this.updateButtons();
    }

    class CheckListPanelViewer
    extends CheckboxTableViewer {
        CheckListPanelViewer(Composite parent, int style) {
            super(new Table(parent, style));
        }

        public void addCheckStateListener(ICheckStateListener theListener) {
            throw new UnsupportedOperationException("Use " + ListPanel.class + ".addCheckStateListener(ICheckStateListener)");
        }

        void addCheckStateListenerAccess(ICheckStateListener theListener) {
            super.addCheckStateListener(theListener);
        }

        protected Object[] getRawChildren(Object parent) {
            Object[] children = super.getRawChildren(parent);
            Table table = this.getTable();
            int count = table.getItemCount();
            if (children.length == 0 && count > 0) {
                children = new Object[count];
                TableItem[] items = table.getItems();
                int ndx = 0;
                while (ndx < items.length) {
                    children[ndx] = items[ndx].getData();
                    ++ndx;
                }
            }
            return children;
        }
    }

    public static interface Constants {
        public static final int NONE = 0;
        public static final int ITEMS_ORDERED = 1;
        public static final int ITEMS_EDITABLE = 2;
        public static final int ITEMS_COMMONLY_ALL_SELECTED = 4;
        public static final int DOWN = 1;
        public static final int UP = -1;
    }

    private class ListPanelViewer
    extends TableViewer {
        ListPanelViewer(Composite parent, int style) {
            super(parent, style);
        }

        protected Object[] getRawChildren(Object parent) {
            Object[] children = super.getRawChildren(parent);
            Table table = this.getTable();
            int count = table.getItemCount();
            if (children.length == 0 && count > 0) {
                children = new Object[count];
                TableItem[] items = table.getItems();
                int ndx = 0;
                while (ndx < items.length) {
                    children[ndx] = items[ndx].getData();
                    ++ndx;
                }
            }
            return children;
        }
    }
}

