/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget.accumulator;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.ui.common.widget.accumulator.AccumulatorPanel;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatorSource;

public class AccumulatorDialog
extends Dialog {
    private IAccumulatorSource source;
    private String title;
    private String leftSideLabelText;
    private String rightSideLabelText;
    private Collection initialRightSideItems;
    private Collection endingRightSideItems;
    private Collection itemsMovedToRightSide;
    private Collection itemsRemovedFromRightSide;
    private ILabelProvider labelProvider;
    private AccumulatorPanel panel;
    private Composite contents;
    private boolean cancelled = false;

    public AccumulatorDialog(Shell parent, IAccumulatorSource source, String title, Collection initialRightSideItems, ILabelProvider labelProvider, String leftSideLabelText, String rightSideLabelText) {
        super(parent);
        this.source = source;
        this.title = title;
        this.initialRightSideItems = initialRightSideItems;
        this.labelProvider = labelProvider;
        this.leftSideLabelText = leftSideLabelText;
        this.rightSideLabelText = rightSideLabelText;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        this.contents = (Composite)super.createDialogArea(parent);
        this.panel = new AccumulatorPanel(this.contents, this.source, this.initialRightSideItems, this.labelProvider, this.leftSideLabelText, this.rightSideLabelText);
        return this.contents;
    }

    protected void okPressed() {
        this.endingRightSideItems = this.panel.getSelectedItems();
        this.itemsMovedToRightSide = this.panel.getItemsMovedToSelected();
        this.itemsRemovedFromRightSide = this.panel.getItemsRemovedFromSelected();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.cancelled = true;
        this.endingRightSideItems = this.initialRightSideItems;
        this.itemsMovedToRightSide = Collections.EMPTY_LIST;
        this.itemsRemovedFromRightSide = Collections.EMPTY_LIST;
        super.cancelPressed();
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public Collection getSelectedItems() {
        return this.endingRightSideItems;
    }

    public Collection getItemsMovedToSelected() {
        return this.itemsMovedToRightSide;
    }

    public Collection getItemsRemovedFromSelected() {
        return this.itemsRemovedFromRightSide;
    }
}

