/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.wizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.ui.common.util.WizardUtil;

public abstract class AbstractWizard
extends Wizard {
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private final List pgs = new ArrayList();

    public AbstractWizard(AbstractUIPlugin plugin, String title, ImageDescriptor image) {
        WizardUtil.initialize(this, plugin, title, image);
    }

    public final void addPage(IWizardPage page) {
        this.addPage(page, this.pgs.size());
    }

    public final void addPage(IWizardPage page, int index) {
        CoreArgCheck.isNotNull((Object)page);
        CoreArgCheck.isNonNegative((int)index);
        this.pgs.add(index, page);
        page.setWizard((IWizard)this);
    }

    public boolean canFinish() {
        Iterator iter = this.pgs.iterator();
        while (iter.hasNext()) {
            if (((IWizardPage)iter.next()).isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public boolean canFlipToNextPage(IWizardPage thePage) {
        int index = this.indexOf(thePage);
        return index != -1 && thePage.isPageComplete() && this.getPageCount() - 1 > index;
    }

    public void createPageControls(Composite pageContainer) {
        this.createPageControls(pageContainer, true);
    }

    public void createPageControls(Composite pageContainer, boolean restorePrevSize) {
        CoreArgCheck.isNotNull((Object)pageContainer);
        for (IWizardPage pg : this.pgs) {
            pg.createControl(pageContainer);
            Assert.isNotNull((Object)pg.getControl());
        }
        final IDialogSettings settings = this.getDialogSettings();
        final Shell shell = this.getShell();
        shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                if (shell.isVisible()) {
                    Point size = shell.getSize();
                    settings.put(AbstractWizard.WIDTH, size.x);
                    settings.put(AbstractWizard.HEIGHT, size.y);
                }
            }
        });
        if (restorePrevSize) {
            try {
                shell.setSize(settings.getInt(WIDTH), settings.getInt(HEIGHT));
                shell.layout();
                Rectangle screenSize = shell.getDisplay().getClientArea();
                Rectangle bounds = shell.getBounds();
                int newX = -1;
                int newY = -1;
                if (bounds.x + bounds.width > screenSize.width) {
                    newX = bounds.x - (bounds.width + bounds.x - screenSize.width);
                }
                if (bounds.y + bounds.height > screenSize.height) {
                    newY = bounds.y - (bounds.height + bounds.y - screenSize.height);
                }
                if (newX != -1 || newY != -1) {
                    shell.setLocation(newX == -1 ? bounds.x : newX, newY == -1 ? bounds.y : newY);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void dispose() {
        Iterator iter = this.pgs.iterator();
        while (iter.hasNext()) {
            ((IWizardPage)iter.next()).dispose();
        }
        super.dispose();
    }

    public abstract boolean finish();

    public IWizardPage getNextPage(IWizardPage page) {
        CoreArgCheck.isNotNull((Object)page);
        int ndx = this.indexOf(page);
        if (ndx == this.pgs.size() - 1 || ndx < 0) {
            return null;
        }
        return (IWizardPage)this.pgs.get(ndx + 1);
    }

    public final IWizardPage getPage(String name) {
        CoreArgCheck.isNotNull((Object)name);
        for (IWizardPage pg : this.pgs) {
            if (!name.equals(pg.getName())) continue;
            return pg;
        }
        return null;
    }

    public int getPageCount() {
        return this.pgs.size();
    }

    public final IWizardPage[] getPages() {
        return this.pgs.toArray(new IWizardPage[this.pgs.size()]);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        CoreArgCheck.isNotNull((Object)page);
        int ndx = this.indexOf(page);
        if (ndx <= 0) {
            return null;
        }
        return (IWizardPage)this.pgs.get(ndx - 1);
    }

    public final IWizardPage getStartingPage() {
        if (this.pgs.size() == 0) {
            return null;
        }
        return (IWizardPage)this.pgs.get(0);
    }

    public int indexOf(IWizardPage thePage) {
        return this.pgs.indexOf(thePage);
    }

    public final boolean needsPreviousAndNextButtons() {
        return super.needsPreviousAndNextButtons() || this.pgs.size() > 1;
    }

    public final boolean performFinish() {
        boolean finished = this.finish();
        if (finished) {
            WizardUtil.saveSettings((IWizard)this);
        }
        return finished;
    }

    public final void removePage(IWizardPage page) {
        CoreArgCheck.isNotNull((Object)page);
        this.pgs.remove(page);
    }
}

