/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.editors;

import java.util.Properties;
import org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;

public class OdaConnectionProvider {
    private DataSourceDesign dataSourceDesign;
    private IConnection connection;

    OdaConnectionProvider(DataSourceDesign dataSourceDesign) {
        this.dataSourceDesign = dataSourceDesign;
    }

    IConnection openConnection() throws OdaException {
        if (this.connection != null) {
            return this.connection;
        }
        IDriver jdbcDriver = JDBCDriverManager.getInstance().getDriver(this.dataSourceDesign.getEffectiveOdaExtensionId());
        try {
            this.connection = jdbcDriver.getConnection(this.dataSourceDesign.getEffectiveOdaExtensionId());
            Properties prop = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.dataSourceDesign);
            this.connection.open(prop);
        }
        catch (OdaException e) {
            this.connection = null;
            throw e;
        }
        return this.connection;
    }

    void release() {
        if (this.connection != null) {
            try {
                try {
                    this.connection.close();
                }
                catch (OdaException odaException) {
                    this.connection = null;
                }
            }
            finally {
                this.connection = null;
            }
        }
    }
}

